class CreateConfigOutputs < ActiveRecord::Migration
  def self.up
    create_table :config_outputs do |t|
      t.column :user_id, :int, :null => false
      t.column :display_to_list_id, :int, :null => false
      t.column :file_format, :string, :null => false, :default => "csv"
      t.column :name, :string
      t.column :eol_pattern, :string, :null => false, :default => "none"
      t.column :eol_parameter, :string
      t.column :separator_pattern, :string, :null => false, :default => "tab"
      t.column :separator_parameter, :string
      t.column :quotation_pattern, :string, :null => false, :default => "none"
      t.column :quotation_parameter, :string
      t.column :encoding, :string, :null => false, :default => "utf-8"
    end
  end

  def self.down
    drop_table :config_outputs
  end
end
