class DropRoles < ActiveRecord::Migration
  def self.up
    drop_table :roles
    remove_column :grant_ons, :role_id
    add_column :grant_ons, :roleable_id, :integer
    add_column :grant_ons, :roleable_type, :string
  end

  def self.down
    create_table :roles do |t|
      t.column :type, :string, :null => false
      t.column :company_id, :int
      t.column :organization_id, :int
      t.column :group_id, :int
      t.column :person_id, :int
    end
    add_column :grant_ons, :role_id, :integer
    remove_column :grant_ons, :roleable_id
    remove_column :grant_ons, :roleable_type
  end
end
