if defined?(OPTIONS) && OPTIONS.key?(:port)
  avahi_publish = nil
  ENV["PATH"].split(File::PATH_SEPARATOR).each do |path|
    ap = File.join(path, "avahi-publish")
    if File.exist?(ap)
      avahi_publish = ap
      break
    end
  end
  if avahi_publish
    begin
      pid = fork do
        require "socket"
        exec(avahi_publish, "-s", "#{Socket.gethostname}: #{File.basename(RAILS_ROOT)} (#{ENV['RAILS_ENV']})", "_http._tcp", OPTIONS[:port].to_s)
      end
      at_exit do
        begin
          Process.waitpid(pid, Process::WNOHANG) # raise Errno::ECHILD when no child processes
          Process.kill(:TERM, pid)
        rescue Exception
          # ignore
        end
      end
    rescue NotImplementedError
      # ignore when jruby (or mswin32)
    end
  end
end
