# http://netflux.com.ar/articles/2008/06/10/betternestedset-en-rails-2-1
module SymetrieCom
  module Acts #:nodoc:
    module NestedSet #:nodoc:
      module InstanceMethods
        def attributes_with_quotes(include_primary_key = true, include_readonly_attributes = true, attribute_names = @attributes.keys)
          left_and_right_column = [acts_as_nested_set_options[:left_column], acts_as_nested_set_options[:right_column]]
          quoted = {}
          connection = self.class.connection
          attribute_names.each do |name|
            if column = column_for_attribute(name)
              quoted[name] = connection.quote(read_attribute(name), column) unless !include_primary_key && (column.primary || left_and_right_column.include?(column.name))
            end
          end
          include_readonly_attributes ? quoted : remove_readonly_attributes(quoted)
        end
      end
    end
  end
end

