# -*- coding: utf-8 -*-

require 'dispatcher'

ActionController::Dispatcher.class_eval do

  before_dispatch :start_accesslog
  after_dispatch :end_accesslog

  private

  def start_accesslog
    @started_at = Time.now
    @request.session[:uuid] = UUIDHelper.uuid
  end

  def end_accesslog
    login_id      = @request.session[:user_id]
    ip_address    = @request.env["HTTP_X_FORWARDED_FOR"] ||
                    @request.env["REMOTE_ADDR"]
    response_time = Time.now - @started_at
    parameters    = YAML.dump filtered_params(@request.parameters)
    uuid          = @request.session[:uuid]

    attributes = {
      :uuid          => uuid,
      :login_id      => login_id,
      :accessed_at   => @started_at.getlocal,
      :ip_address    => ip_address,
      :response_time => response_time,
      :parameters    => parameters,
    }

    AccessLog.create attributes
  end

  def filtered_params(params)
    if @controller && @controller.protected_instance_methods.include?('filter_parameters')
      params = params.inject({}) {|memo, (k, v)| memo[k.to_s] = v; memo }
      params = @controller.new.__send__(:filter_parameters, params)
    end
    params
  end
end

