# Be sure to restart your server when you modify this file

# Uncomment below to force Rails into production mode when
# you don't control web/app server and can't set it the proper way
# ENV['RAILS_ENV'] ||= 'production'

ENV['NLS_LANG'] = 'Japanese_Japan.UTF8' # for Oracle

# Specifies gem version of Rails to use when vendor/rails is not present
RAILS_GEM_VERSION = '2.1.2' unless defined? RAILS_GEM_VERSION

# Bootstrap the Rails environment, frameworks, and default configuration
require File.join(File.dirname(__FILE__), 'boot')

# http://www.texperts.com/2007/12/21/using-action-web-service-with-rails-20/
class Rails::Configuration
  attr_accessor :action_web_service
end

Rails::Initializer.run do |config|
  # Settings in config/environments/* take precedence over those specified here.
  # Application configuration should go into files in config/initializers
  # -- all .rb files in that directory are automatically loaded.
  # See Rails::Configuration for more options.

  # Skip frameworks you're not going to use. To use Rails without a database
  # you must remove the Active Record framework.
  # config.frameworks -= [ :active_record, :active_resource, :action_mailer ]

  # Specify gems that this application depends on. 
  # They can then be installed with "rake gems:install" on new installations.
  # config.gem "bj"
  # config.gem "hpricot", :version => '0.6', :source => "http://code.whytheluckystiff.net"
  # config.gem "aws-s3", :lib => "aws/s3"
  #config.gem "uuid", :version => '1.0.4'
  config.gem "ap4r"
  config.gem "gettext", :lib => 'gettext/rails', :version => '1.93.0'
  config.gem "vpim"
  config.gem "soap4r" if RUBY_VERSION >= "1.9.0"
  config.gem "json" if RUBY_VERSION < "1.9.0"
  config.gem "fastercsv"

  # Only load the plugins named here, in the order given. By default, all plugins 
  # in vendor/plugins are loaded in alphabetical order.
  # :all can be used as a placeholder for all plugins not explicitly named
  # config.plugins = [ :exception_notification, :ssl_requirement, :all ]

  # Add additional load paths for your own custom dirs
  # config.load_paths += %W( #{RAILS_ROOT}/extras )

  # Force all environments to use the same logger level
  # (by default production uses :info, the others :debug)
  # config.log_level = :debug

  # Make Time.zone default to the specified zone, and make Active Record store time values
  # in the database in UTC, and return them converted to the specified local zone.
  # Run "rake -D time" for a list of tasks for finding time zone names. Comment line to use default local time.
  #config.time_zone = 'UTC'

  # Your secret key for verifying cookie session data integrity.
  # If you change this key, all old sessions will become invalid!
  # Make sure the secret is at least 30 characters and all random,
  # no regular words or you'll be exposed to dictionary attacks.
  secret_path = Pathname.new(RAILS_ROOT) + ".secret.session.txt"
  unless secret_path.exist?
    require 'rails_generator/secret_key_generator'
    secret_path.open("w", 0400) do |f|
      f.puts Rails::SecretKeyGenerator.new(ENV['ID']).generate_secret
    end
  end
  secret = secret_path.read.chomp
  config.action_controller.session = {
    :session_key => '_rfw_session',
    :secret      => secret
  }

  # Use the database for sessions instead of the cookie-based default,
  # which shouldn't be used to store highly confidential information
  # (create the session table with "rake db:sessions:create")
  # config.action_controller.session_store = :active_record_store
  config.action_controller.session_store = :p_store
  #config.action_controller.session_store = :active_record_store
  # Use SQL instead of Active Record's schema dumper when creating the test database.
  # This is necessary if your schema can't be completely dumped by the schema dumper,
  # like if you have constraints or database-specific column types
  # config.active_record.schema_format = :sql

  # Activate observers that should always be running
  # config.active_record.observers = :cacher, :garbage_collector

  # http://www.texperts.com/2007/12/21/using-action-web-service-with-rails-20/
  #config.frameworks += [:action_web_service]
  config.action_web_service = Rails::OrderedOptions.new
  config.load_paths += %W(#{RAILS_ROOT}/app/apis)

  ENV["TMPDIR"] = File.join(RAILS_ROOT, "tmp") # for cross platform
end

