# ユーザーに通知するメールのモデル。
class UserNotify < ActionMailer::Base
  # <em>user</em> に対して <em>password</em> とともに登録を通知する。
  def signup(user, password, url=nil)
    setup_email(user)

    # Email header info
    @subject += s_("rfw|UserNotify|Welcome to %{app_name}!") % {:app_name => UserSystem::CONFIG[:app_name]}

    # Email body substitutions
    @body["name"] = user.name
    @body["login"] = user.login
    @body["password"] = password
    @body["url"] = url || UserSystem::CONFIG[:app_url].to_s
    @body["app_name"] = UserSystem::CONFIG[:app_name].to_s
  end

  # <em>user</em> に対してパスワードを忘れた場合の通知を行う。
  def forgot_password(user, url=nil)
    setup_email(user)

    # Email header info
    @subject += s_("rfw|UserNotify|Forgotten password notification")

    # Email body substitutions
    @body["name"] = user.name
    @body["login"] = user.login
    @body["url"] = url || UserSystem::CONFIG[:app_url].to_s
    @body["app_name"] = UserSystem::CONFIG[:app_name].to_s
  end

  # <em>user</em> に対して <em>password</em> への変更を通知する。
  def change_password(user, password, url=nil)
    setup_email(user)

    # Email header info
    @subject += s_("rfw|UserNotify|Changed password notification")

    # Email body substitutions
    @body["name"] = user.name
    @body["login"] = user.login
    @body["password"] = password
    @body["url"] = url || UserSystem::CONFIG[:app_url].to_s
    @body["app_name"] = UserSystem::CONFIG[:app_name].to_s
  end

  # <em>user</em> 宛のメールを設定する。
  def setup_email(user)
    recipients user.email
    from       UserSystem::CONFIG[:email_from].to_s
    subject    "[#{UserSystem::CONFIG[:app_name]}] "
    sent_on    Time.now
    content_type "text/plain; charset=#{UserSystem::CONFIG[:mail_charset]}; format=flowed"
  end
end
