# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: portlettable_members
#
#  id                    :integer       not null, primary key
#  domain_id             :integer       not null
#  portlettable_group_id :integer       not null
#  category              :string(255)   not null
#  portlettable_id       :integer       not null
#  portlettable_type     :string(255)   not null
#  created_at            :string(14)
#  updated_at            :string(14)
#  created_by            :integer
#  updated_by            :integer
#  created_in            :integer
#  updated_in            :integer
#  lock_version          :integer       default(0), not null
#

# ポートレットのメンバーのモデル。
class PortlettableMember < ActiveRecord::Base
  include PortlettableDelegator

  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :portlettable_group

  # 3段階でも縦サイズ <em>s</em> に合うかどうかを判定する。
  def fit?(s)
    category  == "L" || s == "S"
  end
end
