# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: portlettable_groups
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  name_po      :integer       not null
#  category     :string(255)   not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# ポートレットのグループのモデル。
class PortlettableGroup < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_translated :name
  belongs_to :domain
  has_many :portlettable_members, :dependent => :destroy

  # 3段階でのサイズ <em>s</em> に合うかどうかを判定する。
  def fit?(s)
    s  == "L" || category == "S"
  end
end
