# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: portals
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  user_id      :integer       not null
#  pattern      :string(255)   not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# ポータルのモデル。
class Portal < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :domain
  belongs_to :user
  has_one :screen, :as => :displayable
  has_many :portlets, :dependent => :destroy

  LABEL_PATTERN = [
    [N_("rfw|Portal|One Pane"),    "AAA"],
    [N_("rfw|Portal|Two Panes 1"), "ABB"],
    [N_("rfw|Portal|Two Panes 2"), "AAB"],
    [N_("rfw|Portal|Three Panes"), "ABC"],
  ]

  POSITION = {:A => 1, :B => 2, :C => 3}

  ALL_POSITIONS = {
    :AAA => [1],
    :ABB => [1, 2],
    :AAB => [1, 2],
    :ABC => [1, 2, 3],
  }

  SIZE = {
    :AAA => {
      :A => "L",
    },
    :ABB => {
      :A => "S",
      :B => "L",
    },
    :AAB => {
      :A => "L",
      :B => "S",
    },
    :ABC => {
      :A => "S",
      :B => "L",
      :C => "S",
    },
  }

  WIDTH = {
    :AAA => {
      :A => "900px",
    },
    :ABB => {
      :A => "200px",
      :B => "700px",
    },
    :AAB => {
      :A => "700px",
      :B => "200px",
    },
    :ABC => {
      :A => "200px",
      :B => "500px",
      :C => "200px",
    },
  }

  # 縦枠 <em>abc</em> の横サイズ(3段階)を返す。
  def size(abc)
    abc = abc.to_s.upcase.to_sym
    SIZE[pattern.to_sym][abc]
  end

  # 縦枠 <em>abc</em> に対応する pane を返す。
  def pane(abc)
    abc = abc.to_s.upcase.to_sym
    Pane.find_by_screen_id_and_position(screen.id, POSITION[abc])
  end

  # 縦枠 <em>abc</em> に含まれるポートレットの個数を返す。
  def count(abc)
    abc = abc.to_s.upcase.to_sym
    pane(abc).portlets.size
  end

  # パターンを <em>next_pattern</em> に変更する。
  def update_pattern(next_pattern)
    prev_pattern = pattern.to_sym
    next_pattern = next_pattern.to_s.upcase.to_sym
    return if prev_pattern == next_pattern
    Portal.transaction do
      pane_a = pane(:A)
      count_a = count(:A)
      case prev_pattern
      when :ABC
        pane_b = pane(:B)
        count_b = count(:B)
        pane_c = pane(:C)
        case next_pattern
        when :ABB
          pane_b.width = WIDTH[:ABB][:B]
          pane_b.save
#         portlets.each do |portlet|
#           if portlet.pane_id == pane_c.id
#             portlet.pane_id = pane_a.id 
#             portlet.position += count_a
#             portlet.save
#           end
#         end
        when :AAB
          pane_b.width = WIDTH[:AAB][:A]
          pane_b.save
          pane_b.move_to_top
#         portlets.each do |portlet|
#           if portlet.pane_id == pane_c.id
#             portlet.pane_id = pane_a.id
#             portlet.position += count_a
#             portlet.save
#           end
#         end
        when :AAA
          pane_b.width = WIDTH[:AAA][:A]
          pane_b.save
#         portlets.each do |portlet|
#           if portlet.pane_id == pane_a.id
#             portlet.pane_id = pane_b.id
#             portlet.position += count_b
#             portlet.save
#           elsif portlet.pane_id == pane_c.id
#             portlet.pane_id = pane_b.id
#             portlet.position += count_a + count_b
#             portlet.save
#           end
#         end
          pane_a.destroy
        else
          raise ArgumentError, "invild pattern: #{next_pattern}"
        end
        pane_c.destroy
      when :ABB
        pane_b = pane(:B)
        count_b = count(:B)
        case next_pattern
        when :ABC
          pane_b.width = WIDTH[:ABC][:B]
          pane_b.save
          pane_n = Pane.create :screen_id => screen.id, :width => WIDTH[:ABC][:C]
        when :AAB
          pane_a.move_to_bottom
        when :AAA
          pane_b.width = WIDTH[:AAA][:A]
          pane_b.save
#         portlets.each do |portlet|
#           if portlet.pane_id == pane_a.id
#             portlet.pane_id = pane_b.id
#             portlet.position += count_b
#             portlet.save
#           end
#         end
          pane_a.destroy
        else
          raise ArgumentError, "invild pattern: #{next_pattern}"
        end
      when :AAB
        pane_b = pane(:B)
        case next_pattern
        when :ABC
          pane_a.width = WIDTH[:ABC][:B]
          pane_a.save
          pane_n = Pane.create :screen_id => screen.id, :width => WIDTH[:ABC][:A]
          pane_n.move_to_top
        when :ABB
          pane_a.move_to_bottom
        when :AAA
          pane_a.width = WIDTH[:AAA][:A]
          pane_a.save
#         portlets.each do |portlet|
#           if portlet.pane_id == pane_b.id
#             portlet.pane_id = pane_a.id
#             portlet.position += count_a
#             portlet.save
#           end
#         end
          pane_b.destroy
        else
          raise ArgumentError, "invild pattern: #{next_pattern}"
        end
      when :AAA
        case next_pattern
        when :ABC
          pane_a.width = WIDTH[:ABC][:B]
          pane_a.save
          pane_n = Pane.create :screen_id => screen.id, :width => WIDTH[:ABC][:A]
          pane_n.move_to_top
          pane_c = Pane.create :screen_id => screen.id, :width => WIDTH[:ABC][:C]
        when :ABB
          pane_a.width = WIDTH[:ABB][:B]
          pane_a.save
          pane_n = Pane.create :screen_id => screen.id, :width => WIDTH[:ABB][:A]
          pane_n.move_to_top
        when :AAB
          pane_a.width = WIDTH[:AAB][:A]
          pane_a.save
          pane_n = Pane.create :screen_id => screen.id, :width => WIDTH[:AAB][:B]
        else
          raise ArgumentError, "invild pattern: #{next_pattern}"
        end
      end
      self.pattern = next_pattern.to_s
      self.save
    end
  end
end
