# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: po_messages
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  type         :string(255)   not null
#  msgctxt      :string(255)
#  msgid        :text          not null
#  msgid_plural :text
#  msgid_n      :string(255)
#  modified     :boolean
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# gettext の複数形に依存しない翻訳対象のモデル。
class PoMessageSingular < PoMessage
  # 翻訳を返す。
  def translation
    if modified? && User.current
      t = User.current.translation_class.find_by_po_message_id(id)
      return t.msgstr if t
    end
    return s_("#{domain_id}|#{msgctxt}#{msgid}")
  end

  # .po ファイルでの文字列に変換する。
  def to_po_string
    return "msgid " + "#{domain_id}|#{msgctxt}#{msgid}".po_mangle + "\n"
  end

  # msgid を返す。
  # (<em>id</em>のみに依存するため <em>to_po_string</em> より速い。)
  def to_po_string_fast
    return "msgid \"DB|PoMessageSingular|#{id}|\"\n"
  end

  def to_po_string_global
    return "msgid " + "#{msgctxt}#{msgid}".po_mangle + "\n"
  end

  # 複数形に依存するかどうかを返す。
  def plural?
    false
  end
end
