# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: po_arguments
#
#  id            :integer       not null, primary key
#  domain_id     :integer       not null
#  po_message_id :integer       not null
#  name          :string(255)   not null
#  value         :string(255)   not null
#  created_at    :string(14)
#  updated_at    :string(14)
#  created_by    :integer
#  updated_by    :integer
#  created_in    :integer
#  updated_in    :integer
#  lock_version  :integer       default(0), not null
#

# gettext による翻訳のパラメータのモデル。
class PoArgument < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :po_message

  # 個人利用のためのコピーを返す。
  def private_copy(po_message_id)
    argument = self.class.new
    argument.attributes = attributes
    argument.po_message_id = po_message_id
    argument.save!
    return argument
  end
end
