class PjcProjectDesignChange < ActiveRecord::Base
  set_table_name "project_design_changes"
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :project, :class_name => "PjcProject", :foreign_key => "project_id"
  belongs_to :segment, :class_name => "PjcProjectSegment", :foreign_key => "segment_id"
  belongs_to :request_person, :class_name => "PjcPerson", :foreign_key => "request_person_id"
  belongs_to :person_of_recovery, :class_name => "PjcPerson", :foreign_key => "person_of_recovery_id"

  before_create MakesAmendsForProject.new
  before_save MakesAmendsForProject.new

  acts_as_permissible :parent => "segment"

#start free line

  def name
    return subject
  end
#end free line
end
