class PjcPost < ActiveRecord::Base
  set_table_name "posts"

  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :company, :class_name => "PjcCompany", :foreign_key => "company_id"  
  has_many :details, :class_name =>"PjcPostedTo", :foreign_key => "person_id", :dependent => :destroy
  has_many :pjc_people, :class_name =>"PjcPerson", :foreign_key => "default_company_id", :dependent => :nullify
  
  acts_as_permissible :parent => "company"

#start free line

#end free line
end
