class PjcPersonalGroup < ActiveRecord::Base
  set_table_name "personal_groups"
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :person, :class_name => "PjcPerson", :foreign_key => "person_id"
  has_many :personal_group_members, :class_name =>"PjcPersonalGroupMember", :foreign_key => "personal_group_id"
  has_many :people, :class_name => "PjcPerson", :foreign_key => "personal_group_id",:through => :personal_group_members
  
  has_many :pjc_personal_schedule_sets, :as => "def_group_of_gschedule"
  has_many :pjc_personal_schedule_sets, :as => "def_group_of_gwschedule"
  
  has_many :details, :class_name =>"PjcPersonalGroupMember", :foreign_key => "personal_group_id", :dependent => :destroy , :order => "position"
  
  acts_as_permissible

#start free line
  def name_with_in
    name
  end
#end free line
end
