# == Schema Information
# Schema version: 20080822052847
#
# Table name: people
#
#  id                      :integer(4)      not null, primary key
#  domain_id               :integer(4)      not null
#  name                    :string(255)     not null
#  mail_address            :string(255)
#  last_language           :string(255)
#  default_company_id      :integer(4)
#  default_organization_id :integer(4)
#  default_post_id         :integer(4)
#  receive_mail            :boolean(1)      default(TRUE)
#  created_at              :string(14)
#  updated_at              :string(14)
#  created_by              :integer(4)
#  updated_by              :integer(4)
#  created_in              :integer(4)
#  updated_in              :integer(4)
#  lock_version            :integer(4)      default(0), not null
#  phonetic                :string(255)
#

# PJC参照用 個人のモデル。
class PjcPerson < ActiveRecord::Base
  set_table_name "people"

  untranslate_all
  timestamps_as_string
  user_monitor

  acts_as_permissible :parent => "pjc_company"

  has_many :reporting_persons, :foreign_key=>"reporting_person_id", :class_name=>"PjcMonthWorkinghourRept"
  belongs_to :pjc_company, :foreign_key=>"default_company_id", :class_name=>"PjcCompany"
  belongs_to :pjc_organization, :foreign_key=>"default_organization_id", :class_name=>"PjcOrganization"
#start free line
  belongs_to :domain
  has_one :user, :foreign_key=>"person_id",:dependent => :destroy
  has_many :company_members, :class_name=>"PjcCompanyMember",:foreign_key=>"person_id",:dependent => :destroy
  has_many :posted_tos, :class_name=>"PjcPostedTo",:foreign_key=>"person_id",:dependent => :destroy
  has_many :organization_members,  :class_name=>"PjcOrganizationMember",:foreign_key=>"person_id",:dependent => :destroy
  has_many :group_members, :class_name=>"PjcGroupMember",:foreign_key=>"person_id",:dependent => :destroy
  has_many :personal_group_members, :class_name=>"PjcPersonalGroupMember",:foreign_key=>"person_id", :dependent => :destroy

  attr_accessor :keep_original_membership
  before_update DefaultMembership.new(:company      => PjcCompanyMember,
                                      :organization => PjcOrganizationMember,
                                      :post         => PjcPostedTo)
  after_create DefaultMembership.new(:company      => PjcCompanyMember,
                                     :organization => PjcOrganizationMember,
                                     :post         => PjcPostedTo)
#end free line
# personモデルのメッソトを追加する
  # 所属する企業を配列で返す。
  def companies
    company_members.map(&:company).flatten
  end

  # 役職を配列で返す。
  def posts
    posted_tos.map(&:post).flatten
  end

  # 所属する組織を配列で返す。
  def organizations
    organization_members.map(&:organization).flatten
  end

  # 所属するグループを配列で返す。
  def groups
    group_members.map(&:group).flatten
  end

  # 同じ組織に属する個人を配列で返す。
  def colleagues
    organizations.inject([]) do |seed, organization|
      seed | organization.people
    end
  end

  # 同じグループに属する個人を配列で返す。
  def neighbors
    groups.inject([]) do |seed, group|
      seed | group.people
    end
  end

  # 名前および企業の名前と組織の名前を返す。
  def name_with_in
    if company = preferred_company
      if organization = preferred_organization
        "#{name} (#{preferred_company.name}/#{preferred_organization.name})"
      else
        "#{name} (#{preferred_company.name})"
      end
    end
    return name
  end

  # 優先される所属企業を返す。
  def preferred_company
    get_preferred("company")
  end

  # 優先される役職を返す。
  def preferred_post
    get_preferred("post")
  end

  # 優先される所属組織を返す。
  def preferred_organization
    get_preferred("organization")
  end

  # 個人の集合を返す。
  def people
    [self]
  end

  # メールの受信が可能である場合は true、さもなくば false を返す。
  def can_be_recipient?
    !mail_address.blank? && receive_mail
  end

  private

  def get_preferred(column)
    items = __send__(column.pluralize)
    prefer = __send__("default_#{column}_id")
    items.each do |it|
      return it if it.id == prefer
    end
    return items[0]
  end
end
