# == Schema Information
# Schema version: 20080822052847
#
# Table name: month_workinghour_repts
#
#  id                        :integer(4)      not null, primary key
#  domain_id                 :integer(4)      not null
#  workinghour_report_number :string(255)
#  reporting_person_id       :integer(4)
#  reporting_month           :string(255)
#  break_total_time          :integer(4)
#  overtime_total_work_time  :integer(4)
#  night_total_work_time     :integer(4)
#  total_work_time           :integer(4)
#  created_at                :string(14)
#  updated_at                :string(14)
#  created_by                :integer(4)
#  updated_by                :integer(4)
#  created_in                :integer(4)
#  updated_in                :integer(4)
#  lock_version              :integer(4)      default(0), not null
#

class PjcMonthWorkinghourRept < ActiveRecord::Base
  set_table_name "month_workinghour_repts"

  untranslate_all
  timestamps_as_string
  user_monitor
  #acts_as_permissible :parent => "reporting_person"

  belongs_to :reporting_person, :foreign_key=>"reporting_person_id", :class_name=>"PjcPerson"
  has_many :pjc_working_repts, :foreign_key => "month_workinghour_rept_id", :class_name => "PjcWorkingRept", :dependent=>:destroy
  belongs_to :reporting_person, :foreign_key=>"reporting_person_id", :class_name=>"PjcPerson"
  acts_as_permissible :parent => "reporting_person"
  
  #start free line


  #end free line
end
