class PjcBusinessCardOrg < ActiveRecord::Base
  set_table_name "business_card_orgs"

  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible :parent => "company"


  belongs_to :company, :class_name => "PjcBusinessCardCompany", :foreign_key => "company_id"
  has_many :organization1, :class_name =>"PjcBusinessCard", :foreign_key => "company_id", :dependent => :nullify
  has_many :organization2, :class_name =>"PjcBusinessCard", :foreign_key => "company_id", :dependent => :nullify


#start free line
  def name_with_in
    name
  end

#end free line
end
