# == Schema Information
# Schema version: 20080822052847
#
# Table name: business_cards
#
#  id                       :integer(4)      not null, primary key
#  domain_id                :integer(4)      not null
#  company_id               :integer(4)
#  company_branch_id        :integer(4)
#  organization_id1         :integer(4)
#  organization_id2         :integer(4)
#  post_name1               :string(255)
#  post_name2               :string(255)
#  code                     :string(255)
#  name                     :string(255)
#  honorific_title          :string(255)
#  phonetic                 :string(255)
#  name_english_description :string(255)
#  phone_number             :string(255)
#  mobile_phone_number1     :string(255)
#  mobile_phone_number2     :string(255)
#  mail_address1            :string(255)
#  mail_address2            :string(255)
#  postcode                 :string(255)
#  state                    :string(255)
#  city                     :string(255)
#  address1                 :string(255)
#  address2                 :string(255)
#  main_phone_number        :string(255)
#  fax_number               :string(255)
#  url                      :string(255)
#  remarks                  :text
#  created_at               :string(14)
#  updated_at               :string(14)
#  created_by               :integer(4)
#  updated_by               :integer(4)
#  created_in               :integer(4)
#  updated_in               :integer(4)
#  lock_version             :integer(4)      default(0), not null
#

# -*- coding: utf-8 -*-
# 名刺情報のモデル
class PjcBusinessCard < ActiveRecord::Base
  set_table_name "business_cards"
  
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible :parent => "company"

  belongs_to :company, :class_name => "PjcBusinessCardCompany", :foreign_key => "company_id"
  belongs_to :branch, :class_name => "PjcBusinessCardBranch", :foreign_key => "company_branch_id"
  has_many :pjc_matter_negotiations, :class_name =>"PjcMatterNegotiation", :foreign_key => "matter_id", :dependent => :nullify

  #validates_presence_of :company_id, :code


#start free line
  def name_with_in
    name
  end

#end free line
end
