# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: organization_members
#
#  id              :integer       not null, primary key
#  domain_id       :integer       not null
#  organization_id :integer       not null
#  person_id       :integer       not null
#  inception       :string(8)     not null
#  expiry          :string(8)     not null
#  created_at      :string(14)
#  updated_at      :string(14)
#  created_by      :integer
#  updated_by      :integer
#  created_in      :integer
#  updated_in      :integer
#  lock_version    :integer       default(0), not null
#

# 組織への所属関係のモデル。
class OrganizationMember < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_periodic
  belongs_to :organization
  belongs_to :person

  after_create Membership.new(:organization, Membership::PRIORITY_ORGANIZATION)
  after_update Membership.new(:organization, Membership::PRIORITY_ORGANIZATION)
  after_destroy Membership.new(:organization, Membership::PRIORITY_ORGANIZATION)
end
