# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: menus
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  code         :string(255)   not null
#  name_po      :integer       not null
#  motion       :string(255)
#  parent_id    :integer
#  lft          :integer
#  rgt          :integer
#  product_id   :integer
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

class Menu < ActiveRecord::Base
  untranslate_all

  acts_as_nested_set :scope => :domain_id
  acts_as_translated :name
  belongs_to :product

  after_create :move_to_child_of_root
  after_create :initialize_name

  alias_method :nested_set_root, :root
  alias_method :nested_set_children, :children

  validates_presence_of :code

  # メニューレイアウトでの根を返す。
  def self.root
    find(:first, :conditions => "menus.parent_id IS NULL", :order => "menus.id")
  end

  # 隠れているかどうかを判定する。
  def hidden?
    product && product.is_a?(ProductDetailed) && product.model_name == "Item" && product.detail_model_name == "GrantOnWithoutPeriodic"
  end

  # 閲覧可能かどうかを判定する。
  def visible?
    if product_id
      product && product.visible?
    else 
      nested_set_children.empty? || !children.empty?
    end
  end

  # <tt>necessary</tt> な子メニュー全体を返す。
  def children
    @children ||= nested_set_children.select(&:visible?)
  end

  # URL を構成するためのオプションを返す。
  def url_options
    return @url_options if defined?(@url_options)
    return {} unless self.motion
    @url_options = {}
    self.motion.scan(/(\w+)=(\w+)/) do |key, value|
      @url_options[key.to_sym] = value
    end
    return @url_options
  end

  def with_ajax?
    if /\A\// =~ motion
      return false
    else
      return true
    end
  end

  private

  def move_to_child_of_root
    self[:parent_id] || move_to_child_of(self.class.root)
  end

  def initialize_name
    unless self.name_po_message
      self.name_po_message = PoMessageSingular.create!(:msgctxt => "", :msgid => "Menu|#{id}|name|")
      if self.product_id == nil 
         Language.all.each do |lang|
            self.__send__ "name_#{lang.code}=", self.code
         end
      else   
         product = Product.find(self.product_id)
         Language.all.each do |lang|
            self.__send__ "name_#{lang.code}=", product.name_(lang.code)
         end
      end
    self.save!
    end
  end
end
