# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: mail_queues
#
#  id              :integer       not null, primary key
#  domain_id       :integer       not null
#  product_id      :integer       not null
#  document_id     :integer       not null
#  document_type   :string(255)   not null
#  from_id         :integer       not null
#  recipient_ids   :string(255)   not null
#  comment_message :text
#  field_type      :string(255)   not null
#  has_attachment  :boolean       not null
#  auto_login_url  :string(255)   not null
#  mail_mode       :string(255)   not null
#  copy_to_sender  :boolean       not null
#  processed       :boolean       not null
#  created_at      :string(14)
#  updated_at      :string(14)
#  created_by      :integer
#  updated_by      :integer
#  created_in      :integer
#  updated_in      :integer
#  lock_version    :integer       default(0), not null
#

# メールのキューのモデル。
class MailQueue < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :menu
  belongs_to :product
  belongs_to :document, :polymorphic => true
  belongs_to :from, :class_name => "Person", :foreign_key => "from_id"
  has_many :mail_histories, :dependent => :destroy

  validates_presence_of :mail_mode
  validates_row_of :mail_mode, :table => "mail_formats", :column => "mail_mode"

  # 名前を返す。
  def name
    "mail queue #{id}"
  end

  # 受信者の配列を返す。
  def recipients
    arr = Person.joints(recipient_ids)
    arr |= [from] if copy_to_sender
    arr.select(&:can_be_recipient?)
    return arr
  end
end
