# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: mail_histories
#
#  id              :integer       not null, primary key
#  domain_id       :integer       not null
#  mail_queue_id   :integer       not null
#  from_value      :string(255)   not null
#  recipient_value :string(255)   not null
#  subject         :string(255)   not null
#  body            :text          not null
#  status          :string(255)   not null
#  error_log       :text
#  created_at      :string(14)
#  updated_at      :string(14)
#  created_by      :integer
#  updated_by      :integer
#  created_in      :integer
#  updated_in      :integer
#  lock_version    :integer       default(0), not null
#

# メールの履歴のモデル。
class MailHistory < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :mail_queue

  # 配信をスケジューリングする。
  def self.schedule_to_deliver
    MiddleMan.schedule_worker({
      :class => :mail_sender_worker,
      :args => {
        :deliver => MailHistory.find(:all, {:conditions => {:status => "failed"}}).map(&:id),
      },
      :trigger_args => {
        :start => Time.now,
        :repeat_interval => 3.minutes,
      },
    })
  end

  # 配信する。
  def deliver
    if self.status == "delivered"
      logger.warn { "WARN: MailHistory #{id} was already delivered." }
      return false
    end
    text = true
    MailHistory.transaction do
      begin
        AsyncMailer.deliver_formatted_mail(self)
        self.status = "delivered"
      rescue => e
        text = e.inspect
        if self.error_log.blank?
          self.error_log = text
        else
          self.error_log += "\n" + text
        end
      end
      self.save!
    end
    return text
  end
end
