# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: mail_formats
#
#  id                :integer       not null, primary key
#  domain_id         :integer       not null
#  mail_mode         :string(255)
#  from_format       :string(255)
#  recipients_format :string(255)
#  subject_format    :string(255)
#  body_format       :text
#  created_at        :string(14)
#  updated_at        :string(14)
#  created_by        :integer
#  updated_by        :integer
#  created_in        :integer
#  updated_in        :integer
#  lock_version      :integer       default(0), not null
#

# メールの書式のモデル。
class MailFormat < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  # 引数に応じてメールの設定の情報をハッシュで返す。
  def format_all(product, document, from_person, to_person, url, comment)
    arguments = [product, document, from_person, to_person, url, comment]
    return {
      :from => _format(false, from_format, *arguments),
      :recipient => _format(false, recipients_format, *arguments),
      :subject => _format(false, subject_format, *arguments),
      :body => _format(true, body_format, *arguments),
    }
  end

  private

  def _format(need_url_and_comment, format, product, document, from_person, to_person, url, comment)
    url_used = false
    comment_used = false
    formatted = format.gsub(/ m=((frm|to)_p_(name|email|comp|post)|prd_name|get_[a-z]\w+|url|comment)(?= )/) do
      m, person, column = $~.captures
      case m
      when "url"
        url_used = true
        url
      when "comment"
        comment_used = true
        comment
      when "prd_name"
        product.name
      when /\Aget_(\w+)\z/
        column = $1
        begin
          document.send(column)
        rescue NoMethodError => e
          logger.error(e)
          s_("rfw|MailFormat|NoMethodError|(no such column: %{column})") % { :column => column }
        end
      else
        if person == "to"
          person = to_person
        else
          person = from_person
        end
        case column
        when "name"
          person.name
        when "email"
          person.mail_address
        when "comp"
          company = person.preferred_company
          if company
            company.name
          else
            s_("rfw|MailFormat|no companies")
          end
        when "post"
          post = person.preferred_post
          if post
            post.name
          else
            s_("rfw|MailFormat|no posts")
          end
        else
          raise "[bug] must not happen #{$&}"
        end
      end.to_s + "\0"
    end.gsub(/\0 ?/, "")
    if need_url_and_comment
      unless url_used
        formatted += "\n" + s_("rfw|MailFormat|Please click on the following link to login:") + "\n" + url
      end
      unless comment_used
        formatted += "\n\n" + comment
      end
    end
    return formatted
  end
end
