# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: languages
#
#  id           :integer       not null, primary key
#  code         :string(2)     not null
#  name_po      :integer       not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 言語のモデル。
class Language < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_translated :name

  class LanguageNotFound < ActiveRecord::RecordNotFound; end

  # 利用可能な全言語を返す。
  def self.all
    find(:all, :order => "id")
  end

  # 全言語の id と code の対からなるハッシュを返す。
  def self.to_h
    h = {}
    all.each {|lang| h[lang.id] = lang.code}
    return h
  end

  # 既定の言語のコードを返す。
  def self.default_code
    if lang = find(:first, :order => "id")
      return lang.code
    end
    raise LanguageNotFound
  end
end
