# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: items
#
#  id                             :integer       not null, primary key
#  domain_id                      :integer       not null
#  display_id                     :integer       not null
#  code                           :string(255)   not null
#  name_po                        :integer       not null
#  type                           :string(255)   not null
#  model_name                     :string(255)
#  column_name                    :string(255)
#  method_chain                   :text
#  adapter_name                   :string(255)
#  layout                         :float
#  width                          :string(255)
#  align                          :string(255)   default("left"), not null
#  decorator                      :string(255)   default("none"), not null
#  decorator_parameter            :string(255)
#  linked                         :boolean       not null
#  link_parameter                 :string(255)
#  position                       :integer
#  direction                      :string(255)
#  condition_value                :string(255)
#  condition_pattern              :string(255)   default("none"), not null
#  selected                       :boolean
#  ordered                        :boolean
#  search                         :boolean       default(TRUE), not null
#  control                        :string(255)   default("free"), not null
#  input_type                     :string(255)
#  field_size                     :string(255)
#  input_parameter                :string(255)
#  input_initializer              :string(255)
#  input_initial_value            :string(255)
#  write_protected                :boolean
#  validates_presence             :boolean
#  validates_non_negative_integer :boolean
#  validates_integer              :boolean
#  validates_non_negative_float   :boolean
#  validates_float                :boolean
#  validates_zero                 :boolean
#  validates_upper_case           :boolean
#  validates_lower_case           :boolean
#  validates_alphabetic           :boolean
#  validates_alphanumeric         :boolean
#  validates_halfwidth_katakana   :boolean
#  validates_fullwidth            :boolean
#  validates_fullwidth_katakana   :boolean
#  validates_inclusion_chars      :boolean
#  validates_minimum_length       :boolean
#  validates_maximum_length       :boolean
#  validates_integral_length      :boolean
#  validates_fractional_length    :boolean
#  validates_year                 :boolean
#  validates_year_month           :boolean
#  validates_year_month_day       :boolean
#  validates_hour                 :boolean
#  validates_hour_minute          :boolean
#  validates_postal_code          :boolean
#  validates_phone_number         :boolean
#  validates_email                :boolean
#  validates_url                  :boolean
#  validates_minimum_number       :boolean
#  validates_period               :boolean
#  validates_future_date          :boolean
#  validates_past_date            :boolean
#  validates_uniqueness           :boolean
#  validates_row                  :boolean
#  validates_isolated             :boolean
#  validates_inclusion_chars_1    :string(255)
#  validates_minimum_length_1     :string(255)
#  validates_maximum_length_1     :string(255)
#  validates_integral_length_1    :string(255)
#  validates_integral_length_2    :string(255)
#  validates_fractional_length_1  :string(255)
#  validates_fractional_length_2  :string(255)
#  validates_minimum_number_1     :string(255)
#  validates_period_1             :string(255)
#  validates_period_2             :string(255)
#  validates_row_1                :string(255)
#  validates_row_2                :string(255)
#  validates_isolated_1           :string(255)
#  created_at                     :string(14)
#  updated_at                     :string(14)
#  created_by                     :integer
#  updated_by                     :integer
#  created_in                     :integer
#  updated_in                     :integer
#  lock_version                   :integer       default(0), not null
#

# 擬似項目のモデル。
# 項目としての振舞いの委譲先としてアダプタを持つ。
class ItemPseudo < Item
  include Picker

  validates_presence_of :adapter_name

  delegate :to_data, :to => :adapter
  delegate :table_name, :to => :model_class

  # 種類の名前を返す。
  def type_name
    s_("rfw|Item|Pseudo")
  end

  # ユーザーの言語での名前を返す。
  def human_name
    name.blank? ? adapter_name : name
  end

  # インスタンスに属性を設定する。
  # NOTE: 疑似項目の場合は adapter に set_attributes があればそちらにに任せる。
  #       さもなくば何もしない。
  def set_attributes(x, attr)
    adapter.set_attributes(x, attr) if writable? && adapter.respond_to?(:set_attributes)
  end

  # 入力が必須かどうかを判定する。
  # NOTE: 疑似項目の場合の振舞いは未定のため、現在の実装では validates_presence を返す。
  def required?
    validates_presence
  end

  # アダプタを返す。
  def adapter
    @adapter ||= "ItemPseudo::#{adapter_name}".constantize.new(self)
  end

  # 条件を文字列として返す。
  # 指定されていない場合には false を返す。
  def extract
    false
  end

  def picker_field(it, name)
    detail? ? "#{picked_atom}#{id}_#{name}" : "#{picked_atom}#{id}"
  end

end
