# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: items
#
#  id                             :integer       not null, primary key
#  domain_id                      :integer       not null
#  display_id                     :integer       not null
#  code                           :string(255)   not null
#  name_po                        :integer       not null
#  type                           :string(255)   not null
#  model_name                     :string(255)
#  column_name                    :string(255)
#  method_chain                   :text
#  adapter_name                   :string(255)
#  layout                         :float
#  width                          :string(255)
#  align                          :string(255)   default("left"), not null
#  decorator                      :string(255)   default("none"), not null
#  decorator_parameter            :string(255)
#  linked                         :boolean       not null
#  link_parameter                 :string(255)
#  position                       :integer
#  direction                      :string(255)
#  condition_value                :string(255)
#  condition_pattern              :string(255)   default("none"), not null
#  selected                       :boolean
#  ordered                        :boolean
#  search                         :boolean       default(TRUE), not null
#  control                        :string(255)   default("free"), not null
#  input_type                     :string(255)
#  field_size                     :string(255)
#  input_parameter                :string(255)
#  input_initializer              :string(255)
#  input_initial_value            :string(255)
#  write_protected                :boolean
#  validates_presence             :boolean
#  validates_non_negative_integer :boolean
#  validates_integer              :boolean
#  validates_non_negative_float   :boolean
#  validates_float                :boolean
#  validates_zero                 :boolean
#  validates_upper_case           :boolean
#  validates_lower_case           :boolean
#  validates_alphabetic           :boolean
#  validates_alphanumeric         :boolean
#  validates_halfwidth_katakana   :boolean
#  validates_fullwidth            :boolean
#  validates_fullwidth_katakana   :boolean
#  validates_inclusion_chars      :boolean
#  validates_minimum_length       :boolean
#  validates_maximum_length       :boolean
#  validates_integral_length      :boolean
#  validates_fractional_length    :boolean
#  validates_year                 :boolean
#  validates_year_month           :boolean
#  validates_year_month_day       :boolean
#  validates_hour                 :boolean
#  validates_hour_minute          :boolean
#  validates_postal_code          :boolean
#  validates_phone_number         :boolean
#  validates_email                :boolean
#  validates_url                  :boolean
#  validates_minimum_number       :boolean
#  validates_period               :boolean
#  validates_future_date          :boolean
#  validates_past_date            :boolean
#  validates_uniqueness           :boolean
#  validates_row                  :boolean
#  validates_isolated             :boolean
#  validates_inclusion_chars_1    :string(255)
#  validates_minimum_length_1     :string(255)
#  validates_maximum_length_1     :string(255)
#  validates_integral_length_1    :string(255)
#  validates_integral_length_2    :string(255)
#  validates_fractional_length_1  :string(255)
#  validates_fractional_length_2  :string(255)
#  validates_minimum_number_1     :string(255)
#  validates_period_1             :string(255)
#  validates_period_2             :string(255)
#  validates_row_1                :string(255)
#  validates_row_2                :string(255)
#  validates_isolated_1           :string(255)
#  created_at                     :string(14)
#  updated_at                     :string(14)
#  created_by                     :integer
#  updated_by                     :integer
#  created_in                     :integer
#  updated_in                     :integer
#  lock_version                   :integer       default(0), not null
#

# テーブルのカラムに対応する項目のモデル。
class ItemProper < Item
  include Condition
  include Picker
  include NarrowingHelper::Item
  include Rfw::Calendar::Item
  include Rfw::Date::Item
  include Rfw::YearMonth::Item
  include ProjectCollaboration::PjInputOptionHelper

  PRIVATE_COLUMN = %w[id]
  HIDDEN_COLUMN  = %w[domain_id created_at updated_at created_by updated_by created_in updated_in]

  validates_presence_of :column_name
  validates_presence_of :input_initial_value, :if => Proc.new {|x| x.input_initializer == "custom"}
  validates_presence_of :link_parameter, :if => :linked?
  VALIDATES_COLUMN_PARAMETER_COUNT.each do |column_name, count|
    (1..count).each do |i|
      parameter_column_name = "#{column_name}_#{i}"
      validates_presence_of parameter_column_name.to_sym, :if => "#{column_name}?".to_sym
    end
  end

  FOREIGN_KEYS = %w|company organization person post group|

  delegate :table_name, :to => :model_class

  # 種類の名前を返す。
  def type_name
    s_("rfw|Item|Proper")
  end

  def picker_field(it, name)
    detail? ? "#{picked_atom}#{id}_#{name}" : "#{picked_atom}#{id}"
  end

  def rfw_picker_options(it, object_name)
    @rfw_picker_options ||= {
      :picker_field      => picker_field(it, object_name),
      :controller        => picking_record? ? "pick/record" : "pick/#{picked_atom}",
      :submit_text       => "rfw|submit_tag|Pick #{picked_atom.capitalize}",
      :return_field_id   => picking_record? ? "record_id" : "#{picked_atom}_id",
      :return_field_name => picking_record? ? "record_name" : "#{picked_atom}_name",
    }
  end

  # ユーザーの言語での名前を返す。
  def human_name
    column = model_class.columns_hash[column_name]
    unless column
      logger.warn "WARN:Item\#human_name: column not found: #{model_class}\##{column_name}"
      return name
    end
    if name.blank?
      logger.warn("WARN:Item\#human_name: name is blank: #{model_class}\##{column_name}")
      return column.human_name
    elsif name == column.name.humanize
      logger.warn("WARN:Item\#human_name: name is not translated: #{model_class}\##{column_name}")
      return column.human_name
    end
    return name
  end

  # 入力が必須かどうかを判定する。
  def required?
    return true if validates_presence?
    column = model_class.columns_hash[column_name]
    unless column
      logger.error("ERROR:Item\#required?: column not found: #{model_class}\##{column_name}")
      return false
    end
    return column.required?
  end

  # (権限が許せば)インスタンスに属性を設定する。
  def set_attributes(x, attr)
    if writable?
      v = attr[column_name.to_sym]
      if date?
        v = fit_into_internal_date_format(v)
      elsif year_month?
        v = fit_into_internal_year_month_format(v)
      end
      x.__send__("#{column_name}=", v)
    end
  end

  # 並び替えを指定する文字列または <tt>nil</tt> を返す。
  def order
    return nil if direction.blank? || direction =~ /none/i
    "#{column_name} #{direction}"
  end

  # 外部参照を行うカラムに対応している場合はそのクラスを返す。
  # さもなくば false を返す。
  def reference
    if input_type == "picker" && !input_parameter.blank? && !calendar?
      return picked_atom.classify.constantize
    end
    if /(?!:[a-z])([a-z0-9]+)_id\z/ =~ column_name
      name = $1
      if FOREIGN_KEYS.include?(name)
        return name.classify.constantize
      end
    end
    return false
  end

  # InputOption 参照を行う場合はその種類を文字列で返す。
  # さもなくば false を返す。
  def option_category
    return false unless %w|select radio|.include?(input_type)
    return false unless input_parameter =~ /\Ainput_option\(\s*(\S+)\s*\)\z/
    return $1
  end

  # 選択肢を返す、もしくは <em>block</em> に渡す。
  def split_into_input_options(it, session={}, &block)
    if c = option_category
      InputOption.options_for_select(c).map do |name, value|
        block_given? ? yield(name, value) : [name, value]
      end
    elsif pj_input_option?
      project_id = pj_input_option_project_id(it)
      project_id = default_project_id_with_narrowing(session) if project_id.blank?
      PjInputOption.options_for_select(pj_input_option_category, project_id).map do |name, value|
        block_given? ? yield(name, value) : [name, value]
      end
    elsif input_parameter =~ /,/
      input_parameter.split(",").map do |pair|
        value, text = pair.split(":", 2)
        block_given? ? yield(text, value) : [text, value]
      end
    elsif input_parameter =~ /#/
      model_name, method_name = input_parameter.split("#", 2)
      model_name.classify.constantize.find(:all).map do |x|
        name  = x.__send__(method_name)
        value = x.id
        block_given? ? yield(name, value) : [name, value]
      end
    else
      []
    end
  end

  # checkbox 形式を利用するかどうか判定する。
  def checkbox?
    input_type == "checkbox"
  end

  # 対象 <em>it</em> の表示に適したデータを返す。
  # 直接値を表示する以外に次のパターンが用意されている:
  # - input_type が 'checkbox' の場合
  # - input_parameter による指定1(特定のモデル経由)
  # - input_parameter による指定2(InputOptions経由)
  # - column_name の末尾による判定
  def to_data(it)
    value = it.__send__(column_name)
    unless method_chain.blank?
      value = resolve_method_chain(value)
    end
    case input_type
    when "checkbox"
      on, off = input_parameter.split(",")
      on  ||= "ON"
      off ||= ""
      case value.to_s
      when /\Atrue\z/i, /\At\z/i
        return on
      when /\Anil\z/i, /\Afalse\z/i, /\Af\z/i
        return off
      else
        if value.respond_to?(:to_i)
          return value.to_i == 0 ? off : on
        else
          return off
        end
      end
    end
    if c = option_category
      if name = InputOption.option_name(c, value)
        return name
      end
      logger.warn("WARNING: option not found: #{input_parameter}/#{value}")
    elsif pj_input_option?
      project_id = pj_input_option_project_id(it)
      if name = PjInputOption.option_name(pj_input_option_category, project_id, value)
        return name
      end
      logger.warn("WARNING: option not found: #{input_parameter}/#{value}")
    elsif method_chain.blank? && r = reference
      # FIXME: referenceをmethod_chainに統合出来たら消す。
      return refer(value, r)
    elsif date?
      return fit_into_external_date_format(value)
    elsif year_month?
      return fit_into_external_year_month_format(value)
    end
    return value
  end

  def type_cast(x)
    column = model_class.columns_hash[column_name]
    return x unless column_name
    column.type_cast(x)
  end

  private

  def refer(value, model_class)
    if value.blank?
      return ""
    elsif object = model_class.find_by_id(value)
      if picked_keys
        return picked_references(object).map do |x|
          x.respond_to?(:picked_name) ? x.picked_name : x.name
        end.join(" ")
      else
        return object.picked_name if object.respond_to?(:picked_name)
        return object.name
      end
    else
      logger.warn("WARNING: no such id as foreign value: #{value}")
      return value
    end
  end
end
