# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: input_options
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  category     :string(255)   not null
#  name_po      :integer       not null
#  value        :string(255)   not null
#  position     :integer
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 入力の選択肢のモデル。
class InputOption < ActiveRecord::Base
  extend InputOptionFactory
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_translated :name
  acts_as_list :scope => 'category = #{quote_value(category)}'
  validates_presence_of :category, :name_po, :value

  # <em>category</em> に属する選択肢を返す。
  def self.options_for_select(category, limit=nil)
    options = {:conditions => {:category => category}, :order => "position,id"}
    options[:limit] = limit if limit
    find(:all, options).map {|p| [p.name, p.value]}
  end

  # 対応する値を持つ選択肢の名前を返す。
  def self.option_name(category, value)
    (i = find(:first, :conditions => {:category => category, :value => value})) && i.name
  end

  def self.name_po_with_category(category, &block)
    options = find(:all, :conditions => {:category => category})
    (o = options.find(&block)) ? o.name_po : -1
  end

  def self.name_pos_with_category(category, &block)
    options = find(:all, :conditions => {:category => category})
    options.select(&block).map(&:name_po).compact
  end

  # 対応する値を持つ選択肢の name_po を返す。
  def self.name_po_with_category_and_name(category, name)
    name_po_with_category(category) {|o| o.name == name}
  end

  # 対応する値を持つ選択肢の name_po の配列を返す。
  def self.name_pos_with_category_and_head(category, head)
    name_pos_with_category(category) {|o| o.name.index(head) == 0}
  end

  # 対応する値を持つ選択肢の name_po の配列を返す。
  def self.name_pos_with_category_and_tail(category, tail)
    name_pos_with_category(category) {|o| o.name.rindex(tail) == o.name.length - tail.length}
  end

  # 対応する値を持つ選択肢の name_po の配列を返す。
  def self.name_pos_with_category_and_include(category, sub)
    name_pos_with_category(category) {|o| o.name.include?(sub)}
  end
end
