# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: document_edges
#
#  id              :integer       not null, primary key
#  domain_id       :integer       not null
#  from_id         :integer       not null
#  from_type       :string(255)   not null
#  from_product_id :integer       not null
#  to_id           :integer       not null
#  to_type         :string(255)   not null
#  to_product_id   :integer       not null
#  created_at      :string(14)
#  updated_at      :string(14)
#  created_by      :integer
#  updated_by      :integer
#  created_in      :integer
#  updated_in      :integer
#  lock_version    :integer       default(0), not null
#

# 関連文書の参照のためのモデル。
class DocumentEdge < ActiveRecord::Base
  untranslate_all

  belongs_to :domain
  belongs_to :from, :polymorphic => true
  belongs_to :from_product, :class_name => "Product", :foreign_key => "from_product_id"
  belongs_to :to, :polymorphic => true
  belongs_to :to_product, :class_name => "Product", :foreign_key => "to_product_id"
  has_many :document_paths
  has_many :documents, :through => :document_paths

  def self.all_from_but_not_to(x, y)
    find(:all, :conditions => {:from_id => x.id, :from_type => x.class.to_s}).reject {|edge| edge.to == y}
  end
end
