# -*- coding: utf-8 -*-
class DisplayNarrowing < ActiveRecord::Base
  untranslate_all
  belongs_to :domain
  belongs_to :display
  belongs_to :narrowing

  validates_presence_of :display_id, :narrowing_id, :column_name

  delegate :controller_path, :action_name, :value_keys, :narrow_to, :text, :name, :to => :narrowing

  def condition
    narrowing.condition(display.product.table_name, column_name)
  end

  # 個人利用のためのコピーを返す。
  def private_copy(display_id)
    copied = self.class.new(attributes)
    copied.display_id = display_id
    copied.save!
    return copied
  end

end
