# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: displays
#
#  id                    :integer       not null, primary key
#  domain_id             :integer       not null
#  product_id            :integer       not null
#  type                  :string(255)   not null
#  name_po               :integer       not null
#  code                  :string(255)   not null
#  position              :integer
#  enabled               :boolean
#  button_new            :boolean
#  button_edit           :boolean
#  button_delete         :boolean
#  button_copy           :boolean
#  logic_path            :string(255)
#  logic_pre             :boolean
#  logic_mid             :boolean
#  logic_post            :boolean
#  logic_before          :boolean
#  logic_after           :boolean
#  person_id             :integer
#  narrowing_model_name  :string(255)
#  narrowing_column_name :string(255)
#  created_at            :string(14)
#  updated_at            :string(14)
#  created_by            :integer
#  updated_by            :integer
#  created_in            :integer
#  updated_in            :integer
#  lock_version          :integer       default(0), not null
#

# 画面のモデル
class Display < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_translated :name
  acts_as_list :scope => :product
  belongs_to :product
  has_many :items, :order => "id", :dependent => :destroy
  has_one :screen, :as => :displayable
  has_many :default_lists, :dependent => :destroy
  has_many :search_conditions, :dependent => :destroy
  has_many :display_narrowings, :dependent => :destroy, :order => "position"

  delegate :model_class, :to => :product
  delegate :detail_model_class, :to => :product#追加
  delegate :csv?, :mail?, :document?, :attachment?, :to => :product
  delegate :workflow_enabled?, :workflow, :to => :product

  after_create :initialize_button_and_name_and_items

  validates_presence_of :code

  # 現在の画面を返す。
  def self.current
    ccache = CacheEachRequest.current
    ccache ? ccache[:display] : nil
  end

  # 現在の画面を設定する。
  def self.current=(d)
    CacheEachRequest.current[:display] = d
  end

  # 現在の画面の ID を返す。
  def self.current_id
    (current) ? current.id : nil
  end

  # 文字列に変換された場合に <tt>name</tt> を返す。
  def to_s
    name
  end

  # 権限にしたがって利用可能かどうかを判定する。
  # NOTE: 判定はサブクラスで実装する。
  def available?
    raise NotImplementedError, "available? is not implemented"
  end

  # 「閉じる」ボタンの有無を返す。
  # NOTE: 判定はサブクラスで実装する。既定値は false。
  def button_close?
    false
  end

  # 「戻る」ボタンの有無を返す。
  # NOTE: 判定はサブクラスで実装する。既定値は false。
  def button_back?
    false
  end

  # データを書き込むかどうかを判定する。
  # NOTE: 判定はサブクラスで実装する。既定値は false。
  def writable?
    false
  end

  # ビジネスロジックに定義された処理を行う。
  def inject_logic(position, x, action, pool={})
    return x unless __send__("logic_#{position}?")
    require(logic_path)
    logic_class = "#{x.class}Logic".constantize
    logic = logic_class.new
    raise ArgumentError, "#{logic_class} is not a subclass of BusinessLogic" unless logic.is_a?(BusinessLogic)
    name = "#{position}process"
    a = logic.method(name).arity
    if a < 0 || a > 3
      logic.__send__(name, action, User.current, x, pool)
    else
      logic.__send__(name, action, User.current, x)
    end
  end

  # テーブルのカラムに対応する項目のリストを返す。
  def proper_items
    items.select {|item| item.is_a?(ItemProper)}
  end

  private

  def initialize_name
    po = PoMessageSingular.create!(:msgctxt => "", :msgid => "Display|#{id}|name|")
    self.name_po_message = po
    name = code.humanize
    Language.all.each do |lang|
      self.__send__ "name_#{lang.code}=", self.name
    end
    self.save!
  end

  def initialize_button_and_name_and_items
    # Do not initialize in case of private use.
    return if person_id

    self.class::BUTTON_TYPE.each do |b|
      self.__send__ "button_#{b.last}=", true
    end

    initialize_name

    # Do not generate items in case of ProductDetailedForGrantData
    return if product.is_a?(ProductDetailedForGrantData)

    i = 1
       
    application_table = ApplicationTable.find(:first,:conditions => {:name => product.table_name},:order => "id")
    application_table_columns = TableColumn.find(:all , :conditions => {:table_id =>application_table.id}, :order => "id")
 
    #model_class.columns.each do |column|
    application_table_columns.each do |column|
      unless ItemProper::PRIVATE_COLUMN.include?(column.name)
        # An ItemProper has a po message whose msgid comes from its column name as below.
        mgsctxt = "#{model_class}|#{column.human_name_without_gettext}"
        column_po = PoMessageSingular.find_or_create_by_msgctxt_and_msgid("", mgsctxt)
        options = self.class::ITEM_DEFAULT_OPTIONS.merge({
          :display_id  => id,
          :code        => "#{product.table_name.upcase}_#{column.name.upcase}",
          :model_name  => product.model_name,
          :column_name => column.name,
          :model_name => product.model_name,#追加
          :name_po     => column_po.id,
        })
        if ItemProper::HIDDEN_COLUMN.include?(column.name)
          options[:layout] = 0
        else
          options[:layout] = i
          i += 1
        end
        case column.type
        when :integer
          options[:align] = "right" unless /_id\z/ =~ column.name
        when :boolean
          options[:input_type] = "checkbox" if writable?
        when :text
          options[:input_type] = "textarea" if writable?
          options[:decorator] = "nl2br"
        end
        if writable?
          case column.name
          when /\A(company|organization|person|post|group)_id\z/
            associated_table = $1
            options[:input_parameter] = associated_table
            options[:validates_row] = true
            options[:validates_row_1] = associated_table
            options[:validates_row_2] = "id"
            if /\A(?:person|company|organization)\z/ =~ associated_table
              options[:input_initializer] = associated_table
            end
          when /\A(?:inception|expiry)\z/
            options[:input_parameter] = "calendar"
            options[:input_initializer] = "today"
            options[:validates_year_month_day] = true
          end
        end
        ItemProper.create! options
      end
    end

   if self.product.is_a?(ProductDetailed)
    application_table = ApplicationTable.find(:first,:conditions => {:name => product.detail_table_name},:order => "id")
    application_table_columns = TableColumn.find(:all , :conditions => {:table_id =>application_table.id}, :order => "id")
    #detail_model_class.columns.each do |column|
    application_table_columns.each do |column|
      unless ItemProper::PRIVATE_COLUMN.include?(column.name)
        # An ItemProper has a po message whose msgid comes from its column name as below.
        column_po = PoMessageSingular.find_or_create_by_msgctxt_and_msgid("", "Item|#{product.detail_model_name}|#{column.name}")
        options = self.class::ITEM_DEFAULT_OPTIONS.merge({
          :display_id  => id,
          :code        => column.name.upcase,
          :column_name => column.name,
          :model_name => product.detail_model_name,#追加
          :name_po     => column_po.id,
        })
        if ItemProper::HIDDEN_COLUMN.include?(column.name)
          options[:layout] = 0
        else
          options[:layout] = i
          i += 1
        end
        case column.type
        when :integer
          options[:align] = "right" unless /_id\z/ =~ column.name
        when :boolean
          options[:input_type] = "checkbox" if writable?
        when :text
          options[:input_type] = "textarea" if writable?
          options[:decorator] = "nl2br"
        end
        if writable?
          case column.name
          when /\A(company|organization|person|post|group)_id\z/
            associated_table = $1
            options[:input_parameter] = associated_table
            options[:validates_row] = true
            options[:validates_row_1] = associated_table
            options[:validates_row_2] = "id"
            if /\A(?:person|company|organization)\z/ =~ associated_table
              options[:input_initializer] = associated_table
            end
          when /\A(?:inception|expiry)\z/
            options[:input_parameter] = "calendar"
            options[:input_initializer] = "today"
            options[:validates_year_month_day] = true
          end
        end
        ItemProper.create! options
      end
    end
   end#追加 
  end

  ITEM_DEFAULT_OPTIONS = {
  }.freeze
end
