# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: counters
#
#  id             :integer       not null, primary key
#  domain_id      :integer       not null
#  table_name     :string(255)   not null
#  current_number :integer       default(0), not null
#  created_at     :string(14)
#  updated_at     :string(14)
#  created_by     :integer
#  updated_by     :integer
#  created_in     :integer
#  updated_in     :integer
#  lock_version   :integer       default(0), not null
#

# ナンバリングのモデル
class Counter < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :domain

  # <em>args</em> を書式化して返す。
  def self.format(*args)
    result = ""
    args.each do |arg|
      case arg
      when /\Af=/
        result << CustomFormatTranslator::format_date(Date.today, $')
      when /\As=/
        raise ArgumentError, "invalid format: #{arg}" unless /\A(\w+)\.([0-9]+)\z/.match($')
        raise ArgumentError, "no such table: #{$1}" unless c = find(:first, :conditions => {:table_name => $1.tableize})
        result << c.format($2)
      else
        result << arg
      end
    end
    return result
  end

  # 現在の番号を <em>d</em> 桁に書式化して返す。
  def format(d)
    n = (self.current_number += 1)
    self.save!
    return sprintf("%0#{d}d", n)
  end
end
