# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: companies
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  code         :string(255)   not null
#  name         :string(255)   not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 企業のモデル
class Company < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :domain
  has_many :company_members, :dependent => :destroy
  has_many :posts, :dependent => :destroy
  has_many :organizations, :dependent => :destroy
  has_many :people, :through => :company_members
  has_many :grant_ons, :as => :roleable, :dependent => :destroy

  validates_presence_of :code, :name
  validates_uniqueness_of :code

  # <em>p</em> と <em>q</em> が同一の企業に所属しているかどうかを判定する。
  def self.exists_with_people?(p, q)
    return !((p.companies & q.companies).empty?)
  end

  def name_with_in
    name
  end
end
