# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: application_tables
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  name         :string(255)   not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# アプリケーションで利用するテーブルのクラス
class ApplicationTable < ActiveRecord::Base
  include CUI

  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :domain
  has_many :table_columns, :as => :table, :order => "id", :dependent => :destroy
  has_many :application_models#, :dependent => :destroy
  has_many :belongs_tos#, :dependent => :destroy

  after_destroy :drop_table

  def create_table
    script_generate = Pathname.new(RAILS_ROOT) + "script/generate"
    rest = table_columns.map(&:spec)
    rest |= ['--pretend'] if pretend?
    system(ruby, script_generate.to_s, "application_table", name, *rest)
  end

  def drop_table
    script_destroy = Pathname.new(RAILS_ROOT) + "script/destroy"
    rest = pretend? ? ['--pretend'] : []
    system(ruby, script_destroy.to_s, "application_table", name, *rest)
  end
end