module SearchHelper

  def select_box_with(item, column_name, values, default_value)
    if item.new_record?
      name = "newbie_\#{n}_#{column_name}"
    else
      name = "item_#{item.id}_#{column_name}"
    end
    value = item.__send__(column_name)
    select_tag name, options_for_select(values, value.blank? ? default_value : value)
  end

  def radio_box_with(item, column_name, values, default_value)
    values.map do |label, value|
      o = {}
      if item.new_record?
        o[:id] = "newbie_\#{n}_#{value}"
        b = radio_button_tag("newbie_\#{n}_#{column_name}", value, (value == default_value), o)
      else
        o[:id] = "item_#{item.id}_#{value}"
        b = radio_button_tag("item_#{item.id}_#{column_name}", value, (value == item.__send__(column_name)), o)
      end
      b + content_tag(:label, label, {:for => o[:id]})
    end.join("&nbsp;")
  end

  def select_box_condition_pattern(item)
    values = [
      [s_("rfw|SearchConditionItem|eq"),      "eq"],
      [s_("rfw|SearchConditionItem|neq"),     "neq"],
      [s_("rfw|SearchConditionItem|head"),    "head"],
      [s_("rfw|SearchConditionItem|tail"),    "tail"],
      [s_("rfw|SearchConditionItem|include"), "include"],
      [s_("rfw|SearchConditionItem|exclude"), "exclude"],
      [s_("rfw|SearchConditionItem|ge"),      "ge"],
      [s_("rfw|SearchConditionItem|le"),      "le"],
      [s_("rfw|SearchConditionItem|gt"),      "gt"],
      [s_("rfw|SearchConditionItem|lt"),      "lt"],
      [s_("rfw|SearchConditionItem|null"),    "null"],
      [s_("rfw|SearchConditionItem|not null"),"not-null"],
    ]
    select_box_with(item, 'condition_pattern', values, 'eq')
  end

  def select_box_order_by(item)
    values = [
     [s_("rfw|SearchConditionItem|None"), "none"],
     [s_("rfw|SearchConditionItem|Asc"),  "asc"],
     [s_("rfw|SearchConditionItem|Desc"), "desc"],
    ]
    select_box_with(item, 'order_by', values, 'none')
  end

  def button_box(suffix)
    template = escape_javascript(li_for_search_condition_item(SearchConditionItem.new))
    buttons = {
      :left   => link_to_close({"_" => suffix},
                               {:controller => "product", :product_id => @display.product_id, :action => "list"},
                               {:class => "button"}),
      :center => submit_tag(h(s_("rfw|Search|Execute")), :name => "submit", :class => "button"),
      :right => link_to_remote(h(s_("rfw|Search|Add")), {
                                 :before => "App.add_new_search_condition_item('#{template}');",
                                 :update => "space_condition",
                                 :url => {:action => "add_item", :display_id => @display.id, :id => @search_condition.id},
                               }, {
                                 :class => "button",
                               }),
    }
    return lcr_button_box(buttons)
  end

  def link_to_destroy(item)
    f = item.new_record? ? "App.remove_new_search_condition_item" : "App.remove_old_search_condition_item"
    n = item.new_record? ? "\#{n}" : item.id
    img = '<img src="/images/delete.png" width=16 height=16 class="iepngfix" alt="' + h(s_("rfw|button|Destroy")) + '" />'
    link_to_remote(img, {
                     :confirm => s_('rfw|confirm|Are you sure?'),
                     :before => "#{f}(#{n})",
                     :update => "space_condition",
                     :url => {:action => "add_item", :display_id => @display.id, :id => @search_condition.id},
                   })
  end

  def li_for_search_condition_item(item)
    prefix = item.new_record? ? "newbie_\#{n}" : "item_#{item.id}"
    o = options_for_select @display.proper_items.select(&:search?).map {|i| [i.name, i.id]}, item.item_id
    s = select_tag("#{prefix}_item_id", o)
    th = content_tag(:th, s, :class => "block")
    inputs = [ text_field_tag("#{prefix}_condition_value", item.condition_value),
               select_box_condition_pattern(item),
               select_box_order_by(item),
               link_to_destroy(item),
             ]
    tds = inputs.map {|input| content_tag(:td, input, :class => "block")}
    tds.unshift(th)
    tr = content_tag(:tr, tds)
    table = content_tag(:table, tr)
    content_tag(:li, table, :id => prefix, :class => "item draggable")
  end

  def sortable_search_condition
    sortable_element("search_condition",
                     :format => "/^(item_[0-9]+|newbie_[0-9]+)$/",
                     :update => "space_condition",
                     :complete => visual_effect(:highlight, "space_condition"),
                     :url => {:action => "order_item", :display_id => @display.id, :id => @search_condition.id})
  end
end
