module PjcTaskRecordHelper

  # (指定されていれば)CSV出力画面へのリンクを返す。
  def td_to_csv
    return "" unless @display.csv?
    link = link_to_view_motion(h(s_("rfw|link_to|CSV")),
                               "view_output",
                               "output",
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:id => "output", :class => "button"})
    content_tag(:td, link, :class => "right")
  end

  # 権限で許可されていないカラムの部品を返す。
  def not_permitted_column
      filtered_message = s_("rfw|not_permitted_column|[FILTERED]")
      return "<td class=\"not_permitted_column\">#{filtered_message}</td>"
  end

  # 項目 <em>i</em> からヘッダを返す。
  def item_to_th(i)
    content_tag(:th, h(i.human_name), {:style => i.style, :width =>"100",:nowrap =>"",:align =>"center"})
  end

  # 項目から td を返す。
  def item_to_td(i, it, t)
    return not_permitted_column unless i.readable?
    begin
      data = i.to_data(it)  
    rescue NoMethodError
      logger.error("ERROR: not found column: #{@model_class}\##{i.column_name}")
      return "<td class=\"formError\">#{s_("rfw|formError|column not found")}</td>"
    end

    case i.decorator
    when "front"
      content = h("#{i.decorator_parameter}#{data}")
    when "back"
      content = h("#{data}#{i.decorator_parameter}")
    when "currency"
      content = number_to_currency(data, :unit => "&yen;", :precision => 0)
    when "size" # for test
      content = h(number_to_human_size(data))
    when "nl2br"
      content = h(data).gsub(/\r?\n/) { "<br />" }
    else
      content = h(data)
    end
    if i.column_name =="person_in_charge_of_work_id" && content !=nil && content !=""
       if person =Person.find(:first,:conditions =>["id=?",content])
         content =person.name
       else
         content =""
       end  
    end
    if url = i.link_url(it)
      content = link_to(content, url)
    end

    options = {
      :align => "center",
      :class => "item",
    }
    options[:style] = i.style
    # itは今回の履歴情報、tは前回の履歴情報
    if t && i.column_name !="content_of_changed"
       unless h(i.to_data(it)) == h(i.to_data(t))
          options[:style] = "background-color:0FF"
       end
    end    
    content = content_tag(:div, content)
    return content_tag(:td, content, options)
  end
  
  # 画面上下に配置されるボタン群を返す。
  
  def link_to_precede_task(it,task_record)
      if task_record
        link_to_remote(image_tag("memo.png", :alt => s_("PjcTask|Task_title|precede_task")),
                         :update => "precede_task_table",
                         :url => {:action => :precede_task_record_date,
                                  :domain_id => it.domain_id,
                                  :task_record_id => it.id,
                                  :ahead_domain_id => task_record.domain_id, 
                                  :ahead_task_record_id => task_record.id}) 
      else
        link_to_remote(image_tag("memo.png", :alt => s_("PjcTask|Task_title|precede_task")),
                         :update => "precede_task_table",
                         :url => {:action => :precede_task_record_date,
                                  :domain_id => it.domain_id,
                                  :task_record_id => it.id}) 
      end
  end
  
  def link_to_task_milestone(it,task_record)
      if task_record 
         link_to_remote(image_tag("memo.png", :alt => s_("PjcTask|Task_title|task_milestone")),
                       {:update => "task_milestone_table",
                       :url => {:action => :task_milestone_record_date,
                                :domain_id => it.domain_id,
                                :task_record_id => it.id,
                                :ahead_domain_id => task_record.domain_id,
                                :ahead_task_record_id => task_record.id}})
      else
         link_to_remote(image_tag("memo.png", :alt => s_("PjcTask|Task_title|task_milestone")),
                       {:update => "task_milestone_table",
                       :url => {:action => :task_milestone_record_date,
                                :domain_id => it.domain_id,
                                :task_record_id => it.id}})
#                                {:class => "reloadable_link", :id=> "task_milestone_#{it.id}",:onclick => "Element.toggle('task_milestone_table')"})
      end  
  end
end


