# -*- coding: utf-8 -*-
module PjcAttachmentListHelper
  # 新規作成画面へのボタンを返す。
  def td_button_new
    if @display.button_new? && @product.modifiable?
      b = link_to_view_motion(h(s_("rfw|button|New")),
                              @sub_view, "create",
                              {"_" => "&suffix;"},
                              {:action => "new"},
                              :class => "button reloadable_link")
    else
      b = "&nbsp;"
    end
    content_tag(:td, b, :class => "button_new")
  end

  # (指定されていれば)CSV出力画面へのリンクを返す。
  def td_to_csv
    return "" unless @display.csv?
    link = link_to_view_motion(h(s_("rfw|link_to|CSV")),
                               "view_output",
                               "output",
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:id => "output", :class => "button"})
    content_tag(:td, link, :class => "right")
  end

  # (指定されていれば)絞り込みの窓を返す。
  def td_to_narrow
    return "" unless @display.narrowing?
    picker = rfw_picker([{:type => "text", :name => "narrowing", :value => session[@display.narrowing_key], :key => @display.narrowing_key},
                         {:type => "hidden", :name => "narrowing_id", :value => session[@display.narrowing_id_key], :key => @display.narrowing_id_key},
                        ],
                        {:controller => @display.narrowing_controller_name, :action => "narrow"}) do |id|
      javascript_tag("new Form.Element.Observer($('#{id}').previous(), 0.3, function(element, value) {element.form.onsubmit();});")
    end
    content_tag(:td, picker)
  end

  # 権限で許可されていないカラムの部品を返す。
  def not_permitted_column
      filtered_message = s_("rfw|not_permitted_column|[FILTERED]")
      return MergeableTag.new(:td, filtered_message, :class => "not_permitted_column")
  end

  include ItemTableLayout

  # 詳細画面および編集画面で詳細情報を表示するための table を返す。
  def with_table(&block)
    table = to_table_layout(@items) do |item|
      if item.is_a?(Item)
        yield item
      else
        nil
      end
    end

    rows = table.map do |row|
      if row[0].nil?
        content_tag(:tr, content_tag(:td, "", :class => "blank", :colspan => 4))
      else
        cols = row.map do |col|
          if col
            th = MergeableTag.new(:th, "")
            if row[1].nil?
              td = MergeableTag.new(:td, "", :colspan => 3)
            else
              td = MergeableTag.new(:td, "")
            end
            col.each do |c|
              th.merge(c[0])
              td.merge(c[1])
            end
            [th.to_s, td.to_s].join("")
          else
            [
              content_tag(:th, "", :class => "blank"),
              content_tag(:td, "", :class => "blank", :colspan => 3),
            ].join("")
          end
        end
        content_tag(:tr, cols.join(""))
      end
    end
    return content_tag(:table, rows.join(""), :class => "detail hoverable")
  end

  # 項目の一覧を含む table を返す。
  def items_to_table
    with_table do |item|
      [
        MergeableTag.new(:th, h(item.human_name)),
        item_to_td(item, @it)
      ]
    end
  end

  # 項目の一覧に対応する input の table を返す。
  def items_to_table_input
    table = with_table do |item|
      options = {}
      options[:class] = "required" if item.required?
      label = content_tag(:label, h(item.human_name), :for => "it_#{item.column_name}")
      [
        MergeableTag.new(:th, label, options),
        item_to_td_input(item, :it)
      ]
    end
    table + hidden_field(:it, "lock_version")
  end

  # 項目 <em>i</em> からヘッダを返す。
  def item_to_th(i)
    MergeableTag.new(:th, h(i.human_name), {:style => i.style})
  end

  # 項目から td を返す。
  def item_to_td(i, it)
    return not_permitted_column unless i.readable?
    begin
      data = i.to_data(it)
    rescue Item::Error => e
      logger.error("ERROR: Item::Error: #{e.inspect}")
      return MergeableTag.new(:td, h(e.to_s), :class => "formError")
    rescue NoMethodError => e
      logger.error("ERROR: column not found: #{@model_class}\##{i.column_name} #{e.inspect}\n#{e.backtrace.join("\n")}")
      message = s_("rfw|formError|column not found")
      return MergeableTag.new(:td, h(message), :class => "formError")
    end

    # input_type is not available in display_to_show and display_to_list
=begin
    case i.input_type
    when "text"
    when "textarea"
    when "radio", "select"
      data = data.to_s
      i.input_parameter.split(/,/).map do |pair|
        value, text = pair.split(/:/, 2)
        if value == data
          data = text
          break
        end
      end
    when "checkbox"
      data = i.input_parameter.to_s if data
    else
      logger.warn("WARN: invalid input type: #{i.input_type} (#{@model_class}\##{i.column_name})")
    end
=end

    case i.decorator
    when "front"
      content = h("#{i.decorator_parameter}#{data}")
    when "back"
      content = h("#{data}#{i.decorator_parameter}")
    when "currency"
      content = number_to_currency(data, :unit => "", :precision => 0)
    when "size" # for test
      content = h(number_to_human_size(data))
    when "nl2br"
      content = h(data).gsub(/\r?\n/) { "<br />" }
    else
      content = h(data)
    end

    if url = i.link_url(it)
      content = link_to(content, url)
    end

    options = {
      :align => i.align,
      :class => "item",
    }
    options[:style] = i.style
    content = content_tag(:div, content)
    return MergeableTag.new(:td, content, options)
  end

  # 項目から td にラップされた input を返す。
  def item_to_td_input(i, object_name)
    it = instance_variable_get("@#{object_name}")
    return item_to_td(i, it) if i.is_a?(ItemPseudo)
    begin
      data = it.__send__(i.column_name)
    rescue NoMethodError
      logger.error("ERROR: column not found: #{@model_class}\##{i.column_name}")
      message = s_("rfw|formError|column not found")
      return MergeableTag.new(:td, h(message), :class => "formError")
    end

    field_options = {}
    field_options[:readonly] = "readonly" unless i.writable?
    text_options = {
      :size  => i.size_for_input_field,
      :style => i.style_for_input_field,
    }
    text_options.update(field_options)
    case i.input_type
    when "picker"
      e = picker_tags(i, object_name, it)
    when "text"
      e = text_field object_name, i.column_name, text_options
    when "textarea"
      e = text_area object_name, i.column_name, text_options
    when "radio"
      choices = i.split_into_input_options(it) do |name, value|
        radio_button_with_label(object_name, i.column_name, value, h(name), field_options)
      end
      unless i.required?
        choices.unshift(radio_button_with_label(object_name, i.column_name, "", h(s_("rfw|InputOption|(blank)")), field_options))
      end
      e = choices.join
    when "checkbox"
      e = check_box(object_name, i.column_name, field_options) + i.input_parameter.to_s
    when "select"
      choices = i.split_into_input_options(it) do |name, value|
        [h(name), value]
      end
      unless i.required?
        choices.unshift([h(s_("rfw|InputOption|(blank)")), ""])
      end
      e = select(object_name, i.column_name, choices, field_options)
    else
      logger.error("ERROR: invalid input type: #{i.input_type} (#{@model_class}\##{i.column_name})")
      message = s_("rfw|formError|invalid input type")
      return MergeableTag.new(:td, h(message), :class => "formError")
    end

    return MergeableTag.new(:td, e, :class => "input_item", :style => i.style)
  end

  #
  def detail_to_tr(d, script=nil, options={}, &block)
    tds = @detail_items.map {|i| yield(i, d)}
    tds.unshift(content_tag(:td, "&nbsp;", :class => "handle"))
    if script
      link = link_to_function(h(s_("rfw|button|Destroy")), script, :class => "button")
      tds.push(content_tag(:td, link))
    end
    options.update({:class => cycle("even", "odd", :name => "details_to_table")})
    content_tag(:tr, tds, options)
  end

  #
  def with_details(tail=nil, &block)
    ths = @detail_items.map {|i| item_to_th(i)}
    ths.unshift(content_tag(:th, "&nbsp;"))
    ths.push(content_tag(:th, "&nbsp;")) if tail
    head = content_tag(:thead, content_tag(:tr, ths))
    foot = content_tag(:tfoot, "")
    body = content_tag(:tbody, yield, {:id => "details_table_body"})
    table = content_tag(:table, [head, foot, body],{:id => "details_table", :class => "detail hoverable"})
    return table + (tail || "")
  end

  # 
  def details_to_table
    return "" unless @product.is_a?(ProductDetailed)
    with_details do
      @details.map {|d| detail_to_tr(d) {|i,d| item_to_td(i,d)}}
    end
  end

  #
  def details_to_table_input
    return "" unless @product.is_a?(ProductDetailed)
    tail = sortable_details
    tail += hidden_field_tag("new_details", @new_details.to_json)
    tail += hidden_field_tag("old_details", @old_details.to_json)
    tail += hidden_field_tag("order_details", @details.map {|detail| "details_#{detail.id}"}.to_json)
    d = @product.detail_class.new
    @detail_items.each do |i|
      i.initialize_column_of(d)
    end
    temp = "new_details_#{rand(65536)}#{Time.now.to_i}"
    instance_variable_set("@#{temp}", d)
    tr = detail_to_tr(d, "App.remove_new_details(this,\#{n});", :id => temp) {|i,d| item_to_td_input(i, temp)}
    tr = tr.gsub(temp, "new_details_\#{n}")
    link = link_to_remote(h(s_("rfw|button|New")), {
                            :before => "App.add_new_details('#{escape_javascript(tr)}');",
                            :update => "space_details",
                            :url => {:action => "add_detail"},
                          }, {
                            :class => "button",
                          })
    tail += content_tag(:div, link, :class => "right")
    tail += content_tag(:div, "", :id => "space_details")
    with_details(tail) do
      rows = []
      @details.each do |d|
        unless @old_details.include?(d.id)
          html_id = "details_#{d.id}"
          rows << detail_to_tr(d, "App.remove_old_details(this,#{d.id});", :id => html_id) {|i,d| item_to_td_input(i, html_id)}
        end
      end
      rows += @new_details.map do |n|
        d = instance_variable_get("@new_details_#{n}")
        html_id = "new_details_#{n}"
        detail_to_tr(d, "App.remove_new_details(this,#{n});", :id => html_id) {|i,d| item_to_td_input(i, html_id)}
      end
      rows
    end
  end

  def sortable_details
    sortable_element("details_table_body",
                     :format => "/^(details_[0-9]+|new_details_[0-9]+)$/",
                     :complete => visual_effect(:highlight, "details_table"),
                     :url => {:action => "order_details"},
                     :constraint => false,
                     :ghosting => true,
                     :handle => "handle",
                     :tag => "tr")
  end

  # カレンダー選択部品による入力部品を返す。
  def calendar_picker_tags(i, object_name, it)
    picker_field = i.picker_field(it, object_name)

    if flash[:pick] && picker_field === flash[:pick][:field] && flash[:pick][:return_value]
      it[i.column_name] = flash[:pick][:return_value]
    end

    e = text_field object_name, i.column_name, :size => i.size_for_input_field
    e << " "
    e << submit_tag(s_("rfw|submit_tag|Pick Date"), :name => "picker[#{picker_field}]", :onclick => "$('#{object_name}_#{i.column_name}').addClassName('selected')", :disabled => !i.writable?)
    # hidden link for ajax
    e << link_to_view_motion("",
      @sub_view, picker_field, {},
      {
        :controller => "calendar",
        :action => "calendar",
        :return_field => picker_field,
        :view => @sub_view,
      }, :style => "display:none")
    return e
  end

  # 選択部品による入力部品を返す。
  def picker_tags(i, object_name, it)
    return calendar_picker_tags(i, object_name, it) if i.calendar?
    case i
    when ItemProper
      case i.picked_atom
      when "company"
        submit_text = s_("rfw|submit_tag|Pick Company")
      when "organization"
        submit_text = s_("rfw|submit_tag|Pick Organization")
      when "person"
        submit_text = s_("rfw|submit_tag|Pick Person")
      when "post"
        submit_text = s_("rfw|submit_tag|Pick Post")
      when "group"
        submit_text = s_("rfw|submit_tag|Pick Group")
      else
        raise ArgumentError, "invalid picked atom: #{i.picked_atom}"
      end
      picker_field = i.picker_field(it, object_name)
      picked_class = i.picked_atom.classify.constantize
      if flash[:pick] && picker_field == flash[:pick][:field]
        values = i.picked_values(flash[:pick])
        v = values.find {|x| x.is_a?(picked_class)}
        it[i.column_name] = v.id
      elsif v = picked_class.find_by_id(it[i.column_name])
        values = i.picked_references(v)
      else
        values = i.picked_keys.map {|k| k.classify.constantize.new}
      end
      e = ""
      i.picked_keys.each_with_index do |k,n|
        e << text_field_tag("picker_#{picker_field}_#{k}", values[n].name, :readonly => true, :size => i.size_for_input_field)
        e << " "
      end
      onclick = i.picked_keys.map do |k|
        "$('picker_#{picker_field}_#{k}').addClassName('selected');"
      end.join("")
      e << submit_tag(submit_text, :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
      unless error_message_on(object_name, i.column_name).blank?
        e = content_tag(:div, e, :class => "fieldWithErrors")
      end
      # hidden link for ajax
      e << link_to_view_motion("",
                               @sub_view, picker_field, {},
                               {
                                 :controller   => "picker",
                                 :action       => i.picked_atom,
                                 :return_field => picker_field,
                                 :view         => @sub_view,
                               }, :style       => "display:none")
      e << hidden_field(object_name, i.column_name)
      return e
    when ItemPolymorphic
      picker_field = i.picker_field(it, object_name)
      if flash[:pick] && picker_field == flash[:pick][:field]
        if k = flash[:pick][:lump_pick]
          v = k.classify.constantize.find(flash[:pick][k.to_sym])
          it.__send__("#{i.column_name}=", v)
        else
          v = nil
        end
      elsif v = it.__send__(i.column_name)
      else
        v = nil
      end
      e = ""
      e << text_field_tag("picker_#{picker_field}", v ? v.name : "", :readonly => true, :size => i.size_for_input_field)
      onclick = "$('picker_#{picker_field}').addClassName('selected');"
      e << submit_tag(s_("rfw|submit_tag|Pick"), :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
      unless error_message_on(object_name, i.column_name).blank?
        e = content_tag(:div, e, :class => "fieldWithErrors")
      end
      # hidden link for ajax
      e << link_to_view_motion("",
                               @sub_view, picker_field, {},
                               {
                                 :controller   => "picker",
                                 :action       => "lump",
                                 :return_field => picker_field,
                                 :view         => @sub_view,
                               }, :style       => "display:none")
      e << hidden_field(object_name, "#{i.column_name}_id")
      e << hidden_field(object_name, "#{i.column_name}_type")
      return e
    when ItemPlural
      picker_field = i.picker_field(it, object_name)
      if flash[:pick] && picker_field == flash[:pick][:field]
        if k = flash[:pick][:lump_pick]
          values = k.classify.constantize.find(flash[:pick][k.to_sym]).__send__(i.data_method_name)
          it[i.column_name] = values.map(&:id).join(",")
        else
          values = []
        end
      elsif v = it.__send__(i.column_name)
        values = v.split(",").map {|id| i.datum_class.find(id) rescue nil}.compact # FIXME
      else
        values = []
      end
      e = ""
      e << text_field_tag("picker_#{picker_field}", values.map(&:name).join(","), :readonly => true, :size => i.size_for_input_field)
      onclick = "$('picker_#{picker_field}').addClassName('selected');"
      e << submit_tag(s_("rfw|submit_tag|Pick"), :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
      unless error_message_on(object_name, i.column_name).blank?
        e = content_tag(:div, e, :class => "fieldWithErrors")
      end
      # hidden link for ajax
      e << link_to_view_motion("",
                               @sub_view, picker_field, {},
                               {
                                 :controller   => "picker",
                                 :action       => "lump",
                                 :return_field => picker_field,
                                 :view         => @sub_view,
                               }, :style       => "display:none")
      e << hidden_field(object_name, i.column_name)
      return e
    else
      raise ArgumentError, "invalid item type: #{i.class}"
    end
  end

  # メール送信部品による選択の情報を返す。
  def mailto_info
    mail = params[:mail] || {}
    if mail[:recipients]
      if mail[:recipients].is_a?(String)
        mail[:recipients] = mail[:recipients].split(/,/).map(&:to_i)
      end
      recipients = Person.find(mail[:recipients])
      info = select_tag "_mail_info", options_from_collection_for_select(recipients, "id", "name_with_in", 0)
      mail[:recipients] = mail[:recipients].join(",")
    else
      recipients = []
      info = ""
    end
    num = text_field_tag "_mail_num", recipients.size, :readonly => true, :size => 2, :class => "mail_num", :id => nil
    info << ns_("rfw|mailto_info|%{num} person", "%{num} people", recipients.size) % { :num => num }
    mail.keys.each do |key|
      info << hidden_field_tag("mail[#{key}]", mail[key], :id => nil)
    end
    return info
  end

  # 詳細画面へのリンクを返す。
  def display_aspect(controller, view)
    url = {:controller => controller, :action => "show", :id => @it.id, :type => @model_class, :product_id => @product.id}
    if /\Ashow/ =~ params[:action] || request.xhr?
      javascript_tag(remote_function(:update => view, :url => url))
    else
      link = link_to_view_motion(s_(controller), view, "show", {}, url, :class => "autoload button")
      content_tag(:div, link, :class => "left_buttons")
    end
  end

  # タブとして表示する詳細画面へのリンクを返す。
  def display_aspect_as_tab(controller, view)
    url = {:controller => controller, :action => "show_as_tab", :id => @it.id, :type => @model_class, :product_id => @product.id}
    if /\Ashow/ =~ params[:action] || request.xhr?
      javascript_tag(remote_function(:update => view, :url => url))
    else
      link = link_to_view_motion(s_(controller), view, "show_as_tab", {}, url, :class => "autoload button")
      content_tag(:div, link, :class => "left_buttons")
    end
  end

  # サマリへのリンクを返す。
  def summary_aspect(controller)
    url = {:controller => controller, :action => "summary", :id => @it.id, :type => @model_class, :product_id => @product.id}
    javascript_tag(remote_function(:update => "summary_#{controller.pluralize}", :url => url))
  end

  # 関連文書を選択するためのリンクを返す。
  def link_to_select_document(it)
    return "" if @relatable && (it == @relatable || @product.document_nodes_for(@relatable).include?(it))
    link_to_remote(tree_icon_open,
                   :update => "document_table_base",
                   :complete => visual_effect(:highlight, "document_table", :queue => {:scope => "document", :limit => 2, :position => "end"}),
                   :url => {:controller => "document", :action => "select", :id => params[:id], :type => params[:type], :product_id => params[:relatable_product_id], :target_id => it.id, :target_type => it.class.to_s, :target_product_id => @product.id})
  end

  # 一覧検索(汎用検索)の設定画面へのリンクを返す。
  def link_to_search
    return "" unless @product.search?
    link_to_remote(h(s_("rfw|Product|Search")),
                   { :update => "view_search",
                     :url => {:controller => "search", :action => "index"},
                     :with => "'display_id=' + $F('list')",
                   },
                   {:class => "button"})
  end

  # 一覧の設定画面へのリンクを返す。
  def link_to_list
    link_to_view_motion(h(s_("rfw|Product|List")), "view_list", @product.id,
                        {},
                        {:controller => "list", :action => "index", :id => @product.id},
                        {:class => "button reloadable_link"})
  end

  # 画面上下に配置されるボタン群を返す。
  def button_box(suffix)
    buttons = {}
    if params[:id] && @display.button_back?
      buttons[:left] = link_to_view_motion(h(s_("rfw|button|Back")),
                                           @current_view, "show",
                                           {:id => params[:id], "_" => suffix},
                                           {:action => "show", :id => params[:id]},
                                           :class => "button reloadable_link")
    elsif @display.button_close?
      buttons[:left] = link_to_close({:id => nil, "_" => suffix}, {:action => "list", :id => nil}, :class => "button")
    end
    buttons[:center] = ""
    if @display.button_edit? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("rfw|button|Edit")),
                                              @current_view, "edit",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "edit", :id => @it },
                                              :class => "button reloadable_link")
    end
    if @display.button_copy? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("rfw|button|Copy")),
                                              @current_view, "copy",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "new", :id => @it },
                                              :class => "button reloadable_link")
    end
    if @submit_tag
      buttons[:center] += @submit_tag
    end
    if @display.button_delete? && @product.modifiable?
      url = {:action => "destroy", :id => @it }
      if display_workflow? && @wf_config.issue_id
        if User.current.admin?
          # keep url
        elsif @wf_config.issueable? # TODO: issueable? is neither neccesary nor sufficient
          url = url.merge(:workflow => {:issue_id => @wf_config.issue_id})
        else
          url = nil
        end
      end
      if url
        buttons[:right] = link_to_view_motion(h(s_("rfw|button|Destroy")),
                                              @current_view, "destroy",
                                              {:id => @it.id, "_" => suffix},
                                              url,
                                              :confirm => s_('rfw|confirm|Are you sure?'),
                                              :method => :post,
                                              :class => "button reloadable_link")
      end
    end
    return lcr_button_box(buttons)
  end

  def display_workflow?
    return false if %w[new create_document].include?(params[:action])
    return @display.workflow_enabled?
  end

  # ワークフローで使用するボタン群を返す
  def workflow_buttons(config, dom_id)
    html_buttons = []
    buttons = config.buttons || []
    if config.issueable?
      buttons.each do |v|
        action, label = v.key, v.value
        html_buttons << workflow_button(label, "wf_#{action}", dom_id)
      end
    else
      possible_responses = config.possible_responses
      buttons.each do |v|
        action, label = v.key, v.value
        if config.configurable? && action == 'configure'
          html_buttons << workflow_button(label, "wf_#{action}", dom_id)
        else
          # config 以外
          if possible_responses && possible_responses.include?(action)
            html_buttons << workflow_button(label, "wf_#{action}", dom_id)
          else
            html_buttons << workflow_button(label, "wf_#{action}", dom_id, { :disabled => 'true', :onclick => 'return false' })
          end
        end
      end
    end
    html_buttons.join("\n")
  end

  # ワークフローで使用するボタン(リンク)を一つ返す
  def workflow_button(label, action, dom_id, options = {})
    html_options = { :class => 'button' }
    html_options.merge!(options)
    link_to_remote(label,
                   { :update => dom_id,
                     :url => {
                       :id => @it.id,
                       :product_id => @product.id,
                       :workflow_dom_id => dom_id,
                       :action => action,
                       :method => :post } },
                   html_options)
  end

  # ワークフローの編集画面で使用するラジオボタン群を返す
  def workflow_actions(config)
    checked_value = params[:workflow][:action]
    html_actions = []
    buttons = config.buttons || []
    checked = nil
    if config.issueable?
      buttons.each do |v|
        action, label = v.key, v.value
        next if /config/ =~ action
        checked ||= (action == checked_value)
        html_actions << workflow_action(label, action, (action == checked_value))
      end
    else
      possible_responses = config.possible_responses
      buttons.each do |v|
        action, label = v.key, v.value
        next if /config/ =~ action
        checked ||= (action == checked_value)
        if possible_responses && possible_responses.include?(action)
          html_actions << workflow_action(label, action, (action == checked_value))
        else
          html_actions << workflow_action(label, action, (action == checked_value), { :disabled => 'true'})
        end
      end
    end
    html_actions << workflow_action(_('Do Nothing'), 'do_nothing', !checked)
    html_actions.join("\n")
  end

  # ワークフローで使用するラジオボタンを一つ返す
  def workflow_action(label, action, checked = false, options = {})
    tag =  radio_button_tag("workflow[action]", action, checked, options)
    tag << label_tag("workflow_action_#{action}", label)
  end

  # ワークフローで使用するコンボボックスの選択肢を返す
  def workflow_options(container, key = :id, option_name = nil, selected = nil)
    return nil unless container
    option_values = { }
    container.each do |d|
      option_values[d.name] = d.__send__(key).to_s
    end
    if option_name
      options_for_select(option_values, params[:workflow][option_name][selected])
    else
      options_for_select(option_values, params[:workflow][selected])
    end
  end

  # ワークフローで使用するラジオボタンを返す
  # FIXME: ラベルと値を分ける
  def workflow_radio_buttons(labels)
    checked_value = params[:workflow][:option][:cache] || labels.last
    html = []
    labels.each do |label|
      html << radio_button_tag("workflow[option][cache]", label, (label == checked_value))
      html << label_tag("workflow_option_cache_#{label}", _(label))
    end
    html.join("\n")
  end

  include RandomId

  # ワークフローで使用する picker を返す
  def workflow_picker_tags(i, object_name, it, assignment_id, index)
    submit_text = s_("rfw|submit_tag|Pick Person")
    option = params[:workflow][:option]
    stored_value = option[object_name.to_sym] ? option[object_name.to_sym][assignment_id.to_s].values[index] : nil
    picker_field = "workflow_person_#{object_name}_#{assignment_id}_#{index}"
    picked_class = Person
    if flash[:pick] && picker_field == flash[:pick][:field]
      values = i.picked_values(flash[:pick])
      stored_value = flash[:pick][:person]
    elsif v = picked_class.find_by_id(it[i.column_name])
      values = i.picked_references(v)
    else
      values = i.picked_keys.map {|k| k.classify.constantize.new}
    end
    e = ""
    i.picked_keys.each_with_index do |k,n|
      name = nil
      if stored_value.blank?
        stored_value = values[n].id
        name = values[n].name
      else
        name = picked_class.find(stored_value.to_i).name
      end
      e << text_field_tag("picker_#{picker_field}_#{k}", name, :readonly => true, :size => i.size_for_input_field)
      e << " "
    end
    onclick = i.picked_keys.map do |k|
      "$('picker_#{picker_field}_#{k}').addClassName('selected');"
    end.join("")
    e << submit_tag(submit_text, :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
    unless error_message_on(object_name, i.column_name).blank?
      e = content_tag(:div, e, :class => "fieldWithErrors")
    end
    # hidden link for ajax
    e << link_to_view_motion("",
                             @sub_view, picker_field, {},
                             {
                               :controller   => "picker",
                               :action       => i.picked_atom,
                               :return_field => picker_field,
                               :view         => @sub_view,
                             }, :style       => "display:none")
    e << hidden_field_tag("workflow[option][#{object_name}][#{assignment_id}][#{index}]", stored_value)
    return e
  end

  # ワークフローで使用する picker を複数出力する
  # item_options = :input_parameter => 'person', :model_name => 'MatterReport'
  def workflow_picker_lines(config, object_name, it, item_options = { })
    lines = []
    item = ItemPseudo.new(item_options)
    case object_name
    when 'assignment'
      return if config.assignments.blank?
      max = workflow_assignee_maximum(config.assignments)
      c = config.assignments.first
      max.times do |n|
        lines << content_tag(:tr) do
          content_tag(:th, "#{object_name.capitalize} #{c.name}") +
            content_tag(:td, workflow_picker_tags(item, object_name, it, c.id, n))
        end
      end
    when 'candidates'
      return if config.candidateable.blank?
      config.candidateable.each do |c|
        c.assignee_maximum.times do |n|
          lines << content_tag(:tr) do
            content_tag(:th, "#{object_name.capitalize} #{c.name}") +
              content_tag(:td, workflow_picker_tags(item, object_name, it, c.id, n))
          end
        end
      end
    else
      raise "must not happen. object_name = #{object_name}"
    end
    lines.join("\n")
  end

  def workflow_assignee_maximum(assignments)
    return 0 if assignments.blank?
    assignments.map{|a| a.assignee_maximum }.max
  end

  def workflow_error_messages_for(response, *params)
    if @workflow_error
      # FIXME correct message
      message = [ content_tag(:h4, s_("rfw|message|workflow web service returns an error")),
                  content_tag(:p, response.information),
                ]
      return content_tag(:div, message.join, :class => "errorExplanation")
    end
  end
  
  # 日付の選択
  def link_to_calendar_picker_tags(d)
    if d == "start_day"
      #picker_field = i.picker_field(it, object_name)
      picker_field = "calendar100"
        if flash[:pick] && picker_field === flash[:pick][:field] && flash[:pick][:return_value]
          @headline_start_day = flash[:pick][:return_value]
        end

      html = text_field "it", "headline_start_day",:value => @headline_start_day,:size => "12" ,:readonly => true
      html << " "
      html << submit_tag(s_("rfw|submit_tag|Pick Date"), :name => "picker[#{picker_field}]", :onclick => "$('it_headline_start_day').addClassName('selected')")
      # hidden link for ajax
      html << link_to_view_motion("",
        @sub_view, picker_field, {},
        {
          :controller =>"calendar",
          :action =>"calendar",
          :return_field => picker_field,
          :view => "view_picker"
        }, :style => "display:none")
    elsif d == "end_day"
      #picker_field = i.picker_field(it, object_name)
      picker_field = "calendar101"
        if flash[:pick] && picker_field === flash[:pick][:field] && flash[:pick][:return_value]
          @headline_end_day = flash[:pick][:return_value]
        end

      html = text_field "it", "headline_end_day",:value => @headline_end_day,:size => "12" ,:readonly => true
      html << " "
      html << submit_tag(s_("rfw|submit_tag|Pick Date"), :name => "picker[#{picker_field}]", :onclick => "$('it_headline_end_day').addClassName('selected')")
      # hidden link for ajax
      html << link_to_view_motion("",
        @sub_view, picker_field, {},
        {
          :controller => "calendar",
          :action => "calendar",
          :return_field => picker_field,
          :view => "view_picker"
        }, :style => "display:none")
      if @check_date==false && (@headline_start_day && @headline_start_day !="") && 
         (@headline_end_day && @headline_end_day !="") && 
         (@headline_start_day.gsub("/","").to_i >@headline_end_day.gsub("/","").to_i)
         @attachment_list_error =content_tag(:div, s_("rfw|message|error|%{fn} is not included in the period") % {:fn=>s_("PjcAttachmentList|Attachment_list_title|create_at")}, :class => "formError")
      end
    else
    end
    return html
  end

  def rfw_link_to_calendar_picker_tags(d)
    if params[:headline_start_day]
      @headline_start_day =params[:headline_start_day]
    elsif params[:it]&&params[:it][:headline_end_day]
      @headline_end_day =params[:it][:headline_end_day]
    else
      @headline_start_day =""
      @headline_end_day =""
    end
    value =""
    if d =="start_day"
      value =@headline_start_day
    elsif d =="end_day"
      value =@headline_end_day
    end
    html = Array.new
    html << rfw_picker([{
                  :type => "text",
                  :name => "headline_start_day",
                  :value => value,
                  :key => "return_value",
                  :html => {:size =>"12"}
                }],
               {
                 :controller => 'pick/calendar',
                 :action => "search",
                 :return_format => "yyyy/mm/dd",
                 :alert_holiday => false,
                 :escape => false,
               },
               s_('rfw|submit_tag|Pick Date'))
    return html
  end

  # クリアボタン
  def link_to_clear_button
       content_tag(:input,"",{:value=>s_("PjcAttachmentList|Attachment_list_button|clear"),
                     :onclick=>"document.getElementById('selected_product_id').value ='(no_selected)';
                                document.getElementById('inputed_code').value ='';
                                document.getElementById('inputed_project_name').value ='';
                                document.getElementById('inputed_title_name').value ='';
                                document.getElementById('inputed_file_name').value ='';
                                document.getElementById('inputed_description').value ='';
                                document.getElementById('inputed_created_by').value ='';
                                document.getElementById('it_headline_start_day').value ='';
                                document.getElementById('it_headline_end_day').value ='';",
                                :type => "button",
                                :class =>"button"})
  end
  
  # 検索ボタン
  def link_to_attachment_search
      e =""
      e << submit_tag(s_("PjcAttachmentList|Attachment_list_button|search"), :class =>"button", :name =>"search_for_list")
      return e                          
  end
  
  # 一覧の並び替え
  # 昇順並び
  def link_to_order_by_asc(name)
      m =Menu.find(:first,:conditions =>["product_id =?",@menu_select_product_id]).id
      if session[:attachment_order_by_asc] && session[:attachment_order_by_asc].to_s == name
         style_color ="color:red"
      else
         style_color =""        
      end
      link_to_view_motion("▲",
                            @current_view, m,
                            {"_"=>"_order_by_asc_#{name}"},
                            {:controller => "pjc_attachment_list",
                            :action => "list",
                            :attachment_order_by_asc =>name,
                            :product_id => @menu_select_product_id},
                            :style=> style_color,
                            :class => "reloadable_link") 
  end
  
  # 降順並び
  def link_to_order_by_desc(name)
      m =Menu.find(:first,:conditions =>["product_id =?",@menu_select_product_id]).id
      if session[:attachment_order_by_desc] && session[:attachment_order_by_desc].to_s == name
         style_color ="color:red"
      else
         style_color =""        
      end
      link_to_view_motion("▼",
                            @current_view, m,
                            {"_"=>"_order_by_desc_#{name}"},
                            {:controller => "pjc_attachment_list",
                            :action => "list",
                            :attachment_order_by_desc =>name,
                            :product_id => @menu_select_product_id},
                            :style=> style_color,
                            :class => "reloadable_link") 
  end
  
  def link_to_sort_clear_button
      m =Menu.find(:first,:conditions =>["product_id =?",@menu_select_product_id]).id
      link_to_view_motion(s_("PjcAttachmentList|Attachment_list_button|clear"),
                            @current_view, m,
                            {"_"=>"_sort_clear"},
                            {:controller => "pjc_attachment_list",
                            :action => "list",
                            :sort_clear =>true,
                            :product_id => @menu_select_product_id},
                            :class => "button reloadable_link")
  end
  
  # 添付ファイルをダウンロードするための URL を返す。
  def url_to_download(attachment)
    if attachment.file_type == "StorageObject"
      attachment.file.uri
    elsif attachment.new_record?
      url_for(:controller => attachment.file_type.underscore, :action => "download", :id => attachment.file_id)
    else
      url_for(:action => "download", :id => attachment.id)
    end
  end
  
  # 添付ファイルの登録日時を返す。
  def created_at(attachment)
    (t = (attachment.created_at || attachment.file.created_at)) ? t.strftime("%Y/%m/%d") : ""
  end
  
  # 添付ファイルの登録者を返す。
  def created_by(attachment)
      created_name =""
      created_name = attachment.created_by.person.name unless attachment.created_by.blank?
      return created_name
  end
  
  # 添付ファイルの機能名を返す。
  def product_name(attachment)
      product =Product.find(:first,:conditions =>["model_name =?",attachment.attachable_type ])
      if product && product.model_name !=""
         product_name =product.name
      else
         product_name =""
      end
      return product_name
  end
  
  # 添付ファイルの件名、タイトルを返す。
  def title_name(attachment)
      product =Product.find(:first,:conditions =>["model_name =?",attachment.attachable_type ])
      title_name =""
      if product && product.model_name !=""
         attachment_list =PjcAttachmentList.find(:first,:conditions =>["table_name =?",product.table_name])
         if attachment_list
            subject_column=attachment_list.subject_column
            model_class =product.model_name.constantize.find(:first,:conditions =>["id =?",attachment.attachable_id])
            if model_class && subject_column && subject_column !=""
               title_name =model_class.__send__(subject_column)
            end
         end 
      end
      return title_name
  end
  
  # 添付ファイルの管理番号を返す。
  def code(attachment)
      product =Product.find(:first,:conditions =>["model_name =?",attachment.attachable_type ])
      code =""
      if product && product.model_name !=""
         attachment_list =PjcAttachmentList.find(:first,:conditions =>["table_name =?",product.table_name])
         if attachment_list
            document_number_column=attachment_list.document_number_column
            model_class =product.model_name.constantize.find(:first,:conditions =>["id =?",attachment.attachable_id])
            if model_class && document_number_column && document_number_column !=""
               code =model_class.__send__(document_number_column)
            end
         end 
      end
      return code
  end
  
  # 添付ファイルの案件・プロジェクト-業務を返す。
  def project_name(attachment)
      product =Product.find(:first,:conditions =>["model_name =?",attachment.attachable_type ])
      project_name =""
      if product && product.model_name !=""
         attachment_list =PjcAttachmentList.find(:first,:conditions =>["table_name =?",product.table_name])
         if attachment_list
            model_class =product.model_name.constantize.find(:first,:conditions =>["id =?",attachment.attachable_id])
            if model_class
               narrowing_column=attachment_list.join_tables
               case narrowing_column
                 when "project_segments"
                    if attachment_list.table_name =="projects"
                      project=Project.find(:first,:conditions =>["id =?",model_class.id.to_i])
                      project_name =project.name unless (project ==nil)
                    elsif attachment_list.table_name =="project_segments"
                      project_segment=ProjectSegment.find(:first,:conditions =>["id =?",model_class.id.to_i])
                      project_name =project_segment.name unless (project_segment ==nil)
                    else
                      project=Project.find(:first,:conditions =>["id =?",model_class.project_id.to_i])
                      project_segment=ProjectSegment.find(:first,:conditions =>["id =?",model_class.segment_id.to_i])
                      project_name =project.code+" "+project.name+"-"+project_segment.name unless (project ==nil ||project_segment ==nil)
                    end
                 when "matters"
                    if attachment_list.table_name =="matters"
                      matter=Matter.find(:first,:conditions =>["id =?",model_class.id.to_i])
                    else
                      matter=Matter.find(:first,:conditions =>["id =?",model_class.matter_id.to_i])
                    end
                    project_name =matter.name unless matter ==nil
               else
                 begin
                    project_name =model_class.project_name
                 rescue
                    project_name =""
                 end
               end  
            end
         end 
      end
      return project_name
  end
end
