# -*- coding: utf-8 -*-
module PjcAttachmentHelper
  # (指定されていれば)CSV出力画面へのリンクを返す。
  def td_to_csv
    return "" unless @display.csv?
    link = link_to_view_motion(h(s_("rfw|link_to|CSV")),
                               "view_output",
                               "output",
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:id => "output", :class => "button"})
    content_tag(:td, link, :class => "right")
  end

  # (指定されていれば)絞り込みの窓を返す。
  def td_to_narrow
    return "" unless @display.narrowing?
    inputs = @display.narrowing_value_keys.map do |key|
      {:type => "hidden", :name => "narrowing_value_#{key}", :value => session[key], :key => key}
    end
    inputs.unshift({:type => "hidden", :name => "display_id", :value => @display.id, :key => "display_id"})
    inputs.unshift({
                     :type => "hidden",
                     :name => "display_narrowing_id",
                     :value => [:display_narrowing, @display.id, :id].trav(session),
                     :key => "display_narrowing_id"
                   })
    inputs.push({
                  :type => "text",
                  :name => "narrowing_text",
                  :value => narrowing_text,
                  :key => "narrowing_text",
                  :html => {:readonly => true,:size =>"45"},
                })
    title = s_("rfw|submit_tag|Pick #{@display.active_display_narrowing(session).name}")
    picker = rfw_picker(inputs, {:controller => @display.narrowing_controller_path(session), :action => @display.narrowing_action_name(session)}, title) do |id|
      "function() {new Form.Element.Observer($('#{id}').previous(), 0.3, function(element, value) {element.form.onsubmit();});}"
    end
    content_tag(:td, picker)
  end

  # 権限で許可されていないカラムの部品を返す。
  def not_permitted_column
      filtered_message = s_("rfw|not_permitted_column|[FILTERED]")
      return MergeableTag.new(:td, filtered_message, :class => "not_permitted_column")
  end

  include ItemTableLayout
  
  # プロジェクト名と業務名の表示
  def segment_folder_title
      content = []
      # 編集する場合
      begin
        if @it && @it.id !=nil
           project_name = Project.find(@it.project_id).name
           segment_name = ProjectSegment.find(@it.segment_id).name
        # 新規登録する場合   
        elsif @it_parent
           project_name = Project.find(@it_parent.project_id).name
           segment_name = ProjectSegment.find(@it_parent.segment_id).name
        else
           project_name =""
           project_name =""
        end
      rescue ActiveRecord::RecordNotFound
        logger.error("ERROR: Model not found:")
        message = s_("rfw|formError|Model not found")
        return MergeableTag.new(:td, h(message), :class => "formError")
      end      
      options ={}
      options[:readonly] ="true"
      row_project = content_tag(:th, s_("PjcAttachment|Project_title|project_name"),:width =>"20%") + content_tag(:td, text_field_tag("project_name", project_name,options))
      row_segment = content_tag(:th, s_("PjcAttachment|Segment_title|segment_name"),:width =>"20%") + content_tag(:td, text_field_tag("segment_name", segment_name,options))
      content.push(content_tag(:tr, (row_project+row_segment)))
      return content_tag(:table, content, :class => "header w_detail")
  end
  
  def item_to_folder_edit
     content =[]
     options ={}
     if @it
       segment_folder_name =[]
       path = @it.parent_of_segment_folder(@it,segment_folder_name).reverse.join("/").to_s
     else 
       path =""       
     end  
     options[:colspan] ="3"
     folder_path = content_tag(:th, s_("PjcAttachment|Folder_title|folder_path"), :width =>"20%") + content_tag(:td, path, options)
     folder_name_a = content_tag(:th, s_("PjcAttachment|Folder_title|folder_name"), {:width =>"20%",:class =>"required"}) 
     folder_name_b = text_field_tag("folder_add_name",@it.name.to_s,{:size =>"137"})
     folder_explanation_a = content_tag(:th, s_("PjcAttachment|Folder_title|folder_explanation"), :width =>"20%")
     folder_explanation_b = text_area_tag("folder_add_explanation",@it.explanation.to_s,{:cols=>"87",:rows =>"5"})
     if @it
        if @it.name == nil || @it.name ==""||@it.name.length >255
           folder_name_b = content_tag(:div, folder_name_b, :class => "fieldWithErrors")
           folder_name_b +=content_tag(:div, s_("PjcAttachment|error_message|enter_the_date{%date}") % {:date=>s_("PjcAttachment|Folder_title|folder_name")}, :class => "formError")
        end
        if @it.explanation && @it.explanation !=""&&@it.explanation.length >4000
           folder_explanation_b = content_tag(:div, folder_explanation_b, :class => "fieldWithErrors")
           folder_explanation_b +=content_tag(:div, s_("PjcAttachment|error_message|enter_the_date{%date}") % {:date=>s_("PjcAttachment|Folder_title|folder_explanation")}, :class => "formError")
        end
     end
     folder_name_b =content_tag(:td, folder_name_b, options)
     folder_explanation_b =content_tag(:td, folder_explanation_b, options)     
     folder_name =(folder_name_a + folder_name_b)
     folder_explanation =(folder_explanation_a + folder_explanation_b)    
     content.push(content_tag(:tr, folder_path))
     content.push(content_tag(:tr, folder_name))
     content.push(content_tag(:tr, folder_explanation, :height=>"80"))
     return content
  end
  
  def item_to_folder_show
     content =[]
     options ={}
     if @it
       segment_folder_name =[]
       path = @it.parent_of_segment_folder(@it,segment_folder_name).reverse.join("/").to_s
     else 
       path =""       
     end  
     options[:colspan] ="3"
     folder_path = content_tag(:th, s_("PjcAttachment|Folder_title|folder_path"), :width =>"20%") + content_tag(:td, path, options)
     folder_name = content_tag(:th, s_("PjcAttachment|Folder_title|folder_name"), :width =>"20%") + content_tag(:td, @it.name, options)
     folder_explanation = content_tag(:th, s_("PjcAttachment|Folder_title|folder_explanation"), :width =>"20%") + content_tag(:td, @it.explanation, options)
     content.push(content_tag(:tr, folder_path))
     content.push(content_tag(:tr, folder_name))
     content.push(content_tag(:tr, folder_explanation, :height=>"80"))
     return content_tag(:table, content, :class => "header w_detail")
  end
  
  def item_to_folder_add
     it = instance_variable_get("@#{:it}")
     content =[]
     options ={}
     if @it_parent
       segment_folder_name =[]
       path = @it_parent.parent_of_segment_folder(@it_parent,segment_folder_name).reverse.join("/").to_s + "/#{@it_parent.name}"
     else 
       path =""       
     end  
     options[:colspan] ="3"
 
     folder_path = content_tag(:th, s_("PjcAttachment|Folder_title|folder_path"), :width =>"20%") + content_tag(:td, path, options)
     folder_name_a = content_tag(:th, s_("PjcAttachment|Folder_title|folder_name"), {:width =>"20%",:class =>"required"})
     folder_name_b = text_field_tag("folder_add_name","",{:size =>"137"})
     folder_explanation_a = content_tag(:th, s_("PjcAttachment|Folder_title|folder_explanation"), :width =>"20%")
     folder_explanation_b = text_area_tag("folder_add_explanation","",{:cols=>"87",:rows =>"5"})
     if it
        if it.name ==""||it.name.length >255
           folder_name_b = content_tag(:div, folder_name_b, :class => "fieldWithErrors")
           folder_name_b +=content_tag(:div, s_("PjcAttachment|error_message|enter_the_date{%date}") % {:date=>s_("PjcAttachment|Folder_title|folder_name")}, :class => "formError")
        end
        if it.explanation !=""&&it.explanation.length >4000
           folder_explanation_b = content_tag(:div, folder_explanation_b, :class => "fieldWithErrors")
           folder_explanation_b +=content_tag(:div, s_("PjcAttachment|error_message|enter_the_date{%date}") % {:date=>s_("PjcAttachment|Folder_title|folder_explanation")}, :class => "formError")
        end
     end
     folder_name_b =content_tag(:td, folder_name_b, options)
     folder_explanation_b =content_tag(:td, folder_explanation_b, options)
     folder_name =(folder_name_a + folder_name_b)
     folder_explanation =(folder_explanation_a + folder_explanation_b)
     content.push(content_tag(:tr, folder_path))
     content.push(content_tag(:tr, folder_name, :rowspan => "4"))
     content.push(content_tag(:tr, folder_explanation, :height=>"80"))
     return content_tag(:table, content, :class => "header w_detail")
  end
  
  # 一覧画面のファルタ名の表示
  def folder_name
      content = []
      if @folder_name
         name = @folder_name.name
      else  
         name =""
      end
      options ={}
      options[:readonly] ="true" 
      content.push(text_field_tag("project_name", name,options))      
  end
  
  # 添付フェイルのプロジェクト名と業務名を表示する
  def segment_file_title
      content = []
      # 編集する場合
      begin
          if @it
             segment_folder =PjcSegmentFolder.find(@it.attachable_id)
             project_name = Project.find(segment_folder.project_id).name
             segment_name = ProjectSegment.find(segment_folder.segment_id).name
          else
             project_name =""
             project_name =""
          end
      rescue ActiveRecord::RecordNotFound
        logger.error("ERROR: Model not found:")
        message = s_("rfw|formError|Model not found")
        return MergeableTag.new(:td, h(message), :class => "formError")
      end           
      options ={}
      options[:readonly] ="true"
      row_project = content_tag(:th, s_("PjcAttachment|Project_title|project_name")) + content_tag(:td, text_field_tag("project_name", project_name,options)) 
      row_segment = content_tag(:th, s_("PjcAttachment|Segment_title|segment_name")) + content_tag(:td, text_field_tag("segment_name", segment_name,options))
      content.push(content_tag(:tr, (row_project+row_segment)))
      return content_tag(:table, content, :class => "header w_detail")
  end
  
  # ファイルの詳細情報
  def item_to_file_show
     content =[]
     options ={}
     begin
       if segmentfolder =@it.attachable_type.constantize.find(@it.attachable_id)
         if segmentfolder !=nil
            file_name =[]
            path = segmentfolder.parent_of_segment_folder(segmentfolder,file_name).reverse.join("/").to_s + "/#{segmentfolder.name}" +"/#{@it.name}"
         else
            path =""
         end  
       else 
         path =""       
       end  
       options[:colspan] ="3"
       file_name =content_tag(:th, s_("rfw|Attachment|File Name"), :width =>"20%") + content_tag(:td, @it.name, options)
       file_description =content_tag(:th, s_("rfw|Attachment|Description"), :width =>"20%") + content_tag(:td, @it.description, options)
       file_size =content_tag(:th, s_("rfw|Attachment|File Size"), :width =>"20%") + content_tag(:td, number_to_human_size(@it.length), options)
       file_location =content_tag(:th, s_("rfw|Attachment|Location"), :width =>"20%") + content_tag(:td, @it.location, options)
       file_path =content_tag(:th, s_("PjcAttachment|Folder_title|folder_path"), :width =>"20%") + content_tag(:td, path, options)    
       content.push(content_tag(:tr, file_name))
       content.push(content_tag(:tr, file_description))
       content.push(content_tag(:tr, file_size))
       content.push(content_tag(:tr, file_location))
       content.push(content_tag(:tr, file_path))
     rescue ActiveRecord::RecordNotFound
       logger.error("ERROR: Model not found:")
       message = s_("rfw|formError|column not found")
       return MergeableTag.new(:td, h(message), :class => "formError")
     end     
     return content_tag(:table, content, :class => "header w_detail")
  end
  
  # ファイルの編集情報
  def item_to_file_edit
     content =[]
     options ={}
     begin
       if segmentfolder =@it.attachable_type.constantize.find(@it.attachable_id)
         if segmentfolder !=nil
            file_name =[]
            path = segmentfolder.parent_of_segment_folder(segmentfolder,file_name).reverse.join("/").to_s + "/#{segmentfolder.name}" +"/#{@it.name}"
         else
            path =""
         end  
       else 
         path =""       
       end  
       options[:colspan] ="3"
       file_name_a =content_tag(:th, s_("rfw|Attachment|File Name"), {:width =>"20%",:class =>"required"})
       file_name_b =text_field_tag("file_name",@it.name,{:size =>"137"})
       file_description_a =content_tag(:th, s_("rfw|Attachment|Description"), :width =>"20%")
       file_description_b =text_field_tag("file_description",@it.description,{:size =>"137"})
       if @file_date
          if @file_date.name == nil || @file_date.name ==""||@file_date.name.length >255
             file_name_b = content_tag(:div, file_name_b, :class => "fieldWithErrors")
             file_name_b +=content_tag(:div, s_("PjcAttachment|error_message|enter_the_date{%date}") % {:date=>s_("rfw|Attachment|File Name")}, :class => "formError")
          end 
       end
       if @it
          if @it.description && @it.description !=""&&@it.description.length >4000
             file_description_b = content_tag(:div, file_description_b, :class => "fieldWithErrors")
             file_description_b +=content_tag(:div, s_("PjcAttachment|error_message|enter_the_date{%date}") % {:date=>s_("rfw|Attachment|Description")}, :class => "formError")
          end
       end
       file_name_b =content_tag(:td, file_name_b, options)
       file_description_b =content_tag(:td, file_description_b, options)
       file_name =(file_name_a + file_name_b)
       file_description =(file_description_a + file_description_b)             
       file_size =content_tag(:th, s_("rfw|Attachment|File Size"), :width =>"20%") + content_tag(:td, number_to_human_size(@it.length), options)
       file_location =content_tag(:th, s_("rfw|Attachment|Location"), :width =>"20%") + content_tag(:td, @it.location, options)
       file_path =content_tag(:th, s_("PjcAttachment|Folder_title|folder_path"), :width =>"20%") + content_tag(:td, path, options)    
       content.push(content_tag(:tr, file_name))
       content.push(content_tag(:tr, file_description))
       content.push(content_tag(:tr, file_size))
       content.push(content_tag(:tr, file_location))
       content.push(content_tag(:tr, file_path))
     rescue ActiveRecord::RecordNotFound
       logger.error("ERROR: Model not found:")
       message = s_("rfw|formError|column not found")
       return MergeableTag.new(:td, h(message), :class => "formError")
     end     
     return content
  end

  def sortable_details
    sortable_element("details_table_body",
                     :format => "/^(details_[0-9]+|new_details_[0-9]+)$/",
                     :complete => visual_effect(:highlight, "details_table"),
                     :url => {:action => "order_details"},
                     :constraint => false,
                     :ghosting => true,
                     :handle => "handle",
                     :tag => "tr")
  end

  # メール送信部品による選択の情報を返す。
  def mailto_info
    mail = params[:mail] || {}
    if mail[:recipients]
      if mail[:recipients].is_a?(String)
        mail[:recipients] = mail[:recipients].split(/,/).map(&:to_i)
      end
      recipients = Person.find(mail[:recipients])
      info = select_tag "_mail_info", options_from_collection_for_select(recipients, "id", "name_with_in", 0)
      mail[:recipients] = mail[:recipients].join(",")
    else
      recipients = []
      info = ""
    end
    num = text_field_tag "_mail_num", recipients.size, :readonly => true, :size => 2, :class => "mail_num", :id => nil
    info << ns_("rfw|mailto_info|%{num} person", "%{num} people", recipients.size) % { :num => num }
    mail.keys.each do |key|
      info << hidden_field_tag("mail[#{key}]", mail[key], :id => nil)
    end
    return info
  end

  # 詳細画面へのリンクを返す。
  def display_aspect(controller, view)
    url = {:controller => controller, :action => "show", :id => @it.id, :type => @model_class, :product_id => @product.id}
    if /\Ashow/ =~ params[:action] || request.xhr?
      javascript_tag(remote_function(:update => view, :url => url))
    else
      link = link_to_view_motion(s_(controller), view, "show", {}, url, :class => "autoload button")
      content_tag(:div, link, :class => "left_buttons")
    end
  end

  # タブとして表示する詳細画面へのリンクを返す。
  def display_aspect_as_tab(controller, view)
    url = {:controller => controller, :action => "show_as_tab", :id => @it.id, :type => @model_class, :product_id => @product.id}
    if /\Ashow/ =~ params[:action] || request.xhr?
      javascript_tag(remote_function(:update => view, :url => url))
    else
      link = link_to_view_motion(s_(controller), view, "show_as_tab", {}, url, :class => "autoload button")
      content_tag(:div, link, :class => "left_buttons")
    end
  end

  # サマリへのリンクを返す。
  def summary_aspect(controller)
    url = {:controller => controller, :action => "summary", :id => @it.id, :type => @model, :product_id => @product.id}
    javascript_tag(remote_function(:update => "summary_#{controller.pluralize}", :url => url))
  end

  # 関連文書を選択するためのリンクを返す。
  def link_to_select_document(it)
    return "" if @relatable && (it == @relatable || @product.document_nodes_for(@relatable).include?(it))
    link_to_remote(tree_icon_open,
                   :update => "document_table_base",
                   :complete => visual_effect(:highlight, "document_table", :queue => {:scope => "document", :limit => 2, :position => "end"}),
                   :url => {:controller => "document", :action => "select", :id => params[:id], :type => params[:type], :product_id => params[:relatable_product_id], :target_id => it.id, :target_type => it.class.to_s, :target_product_id => @product.id})
  end

  # 一覧検索(汎用検索)の設定画面へのリンクを返す。
  def link_to_search
    return "" unless @product.search?
    link_to_remote(h(s_("rfw|Product|Search")),
                   { :update => "view_search",
                     :url => {:controller => "search", :action => "index"},
                     :with => "'display_id=' + $F('list')",
                   },
                   {:class => "button"})
  end

  # 一覧の設定画面へのリンクを返す。
  def link_to_list
    link_to_view_motion(h(s_("rfw|Product|List")), "view_list", @product.id,
                        {},
                        {:controller => "list", :action => "index", :id => @product.id},
                        {:class => "button reloadable_link"})
  end

  # フォルダの画面上下に配置されるボタン群を返す。
  def button_box_folder(suffix)
    buttons = {}
    if params[:id] && @display.button_back?
      buttons[:left] = link_to_view_motion(h(s_("rfw|button|Back")),
                                           @current_view, "show",
                                           {:id => params[:id], "_" => suffix},
                                           {:action => "show", :id => params[:id]},
                                           :class => "button reloadable_link")
    elsif @display.button_close?
      buttons[:left] = link_to_close({:id => nil, "_" => suffix}, {:action => "list", :id => nil}, :class => "button")
    end
    buttons[:center] = ""
    if @display.button_edit? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("rfw|button|Edit")),
                                              @current_view, "edit",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "form_folder_edit", :id => @it, :product_id => 19},
                                              :class => "button reloadable_link")
    end
    if @display.button_copy? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("rfw|button|Copy")),
                                              @current_view, "copy",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "new", :id => @it },
                                              :class => "button reloadable_link")
    end
    if @submit_tag
      buttons[:left] = link_to_close({:id => nil, "_" => suffix}, {:action => "list", :id => nil}, :class => "button")
      buttons[:center] += @submit_tag
    end
    if @display.button_delete? && @product.modifiable?
      url = {:action => "folder_destroy", :id => @it }
      if display_workflow? && @wf_config.issue_id
        if User.current.admin?
          # keep url
        elsif @wf_config.issueable? # TODO: issueable? is neither neccesary nor sufficient
          url = url.merge(:workflow => {:issue_id => @wf_config.issue_id})
        else
          url = nil
        end
      end
      if url
        buttons[:right] = link_to_view_motion(h(s_("rfw|button|Destroy")),
                                              @current_view, "destroy",
                                              {:id => @it.id, "_" => suffix},
                                              url,
                                              :confirm => s_('rfw|confirm|Are you sure?'),
                                              :method => :post,
                                              :class => "button reloadable_link")
      end
    end
    return lcr_button_box(buttons)
  end
  
  # 画面上下に配置されるボタン群を返す。
  def button_box(suffix)
    buttons = {}
    buttons[:left] = link_to_close({:id => nil, "_" => suffix}, {:action => "list", :id => nil}, :class => "button")
    buttons[:center] = ""
    if @display.button_edit? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("rfw|button|Edit")),
                                              @current_view, "edit",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "edit", :id => @it },
                                              :class => "button reloadable_link")
    end
    if @display.button_copy? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("rfw|button|Copy")),
                                              @current_view, "copy",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "new", :id => @it },
                                              :class => "button reloadable_link")
    end
    if @submit_tag
      buttons[:center] += @submit_tag
    end
    if @display.button_delete? && @product.modifiable?
      url = {:action => "destroy", :id => @it }
      if display_workflow? && @wf_config.issue_id
        if User.current.admin?
          # keep url
        elsif @wf_config.issueable? # TODO: issueable? is neither neccesary nor sufficient
          url = url.merge(:workflow => {:issue_id => @wf_config.issue_id})
        else
          url = nil
        end
      end
      if url
        buttons[:right] = link_to_view_motion(h(s_("rfw|button|Destroy")),
                                              @current_view, "destroy",
                                              {:id => @it.id, "_" => suffix},
                                              url,
                                              :confirm => s_('rfw|confirm|Are you sure?'),
                                              :method => :post,
                                              :class => "button reloadable_link")
      end
    end
    return lcr_button_box(buttons)
  end

  def display_workflow?
    return false if %w[new create_document].include?(params[:action])
    return @display.workflow_enabled?
  end
  
  # 一覧画面の開閉ボタン
  def item_of_folder_content(it)
      options ={}
      content = it.name
      level=it.level_type(it).to_i
      m =Menu.find(:first,:conditions =>["product_id =?",@menu_select_product_id]).id
      if it.parent_id !=nil && @model.find(:first,:conditions =>["domain_id =? and parent_id =?",it.domain_id,it.id])
         segment_folder =@model.find(:all,:conditions =>["domain_id =? and parent_id =?",it.domain_id,it.id])
            # データ追加処理
            if @project_folder.index(segment_folder[0]) ==nil && session[:project_open_and_shut].index(it.id) ==nil
               content =link_to_view_motion(h("[+]"),
                                               @current_view, m,
                                               {"_"=>"_#{it.id}"},
                                               {:controller => "pjc_attachment",
                                               :action => "list",
                                               :folder_id =>it.id,
                                               :folder_id_for_show =>it.id,  # 右側の表示
                                               :link_type =>"plus",
                                               :product_id => @menu_select_product_id},
                                               :class => "reloadable_link") + content
            else
               content =link_to_view_motion(h("[-]"),
                                               @current_view, m,
                                               {"_"=>"_#{it.id}"},
                                               {:controller => "pjc_attachment",
                                               :action => "list",
                                               :folder_id =>it.id,
                                               :folder_id_for_show =>it.id,  # 右側の表示
                                               :link_type =>"minus",
                                               :product_id => @menu_select_product_id},
                                               :class => "reloadable_link") + content
            end
      elsif level.to_i !=0  
          content = "&nbsp;&nbsp;&nbsp;&nbsp;" + content               
      end      
      content =content_tag(:div, ("&nbsp;" * 4 * level) + content) 
      content_tag(:td, content, options)
  end
  
  # プロジェクトフォルダ表示ボタン
  def link_to_project_folder_for_show
      m =Menu.find(:first,:conditions =>["product_id =?",@menu_select_product_id]).id
      link_to_view_motion(s_("PjcAttachment|project_folder_for_show"),
                            @current_view, m,
                            {"_"=>"_project_folder_for_show"},
                            {:controller => "pjc_attachment",
                            :action => "list",
                            :product_id => @menu_select_product_id,
                            :folder_botton_type =>"PjcSegmentFolder",
                            :folder_id_for_show_clear => "true"},
                            :class => "button reloadable_link")  
  end
  
  # 共有フォルダ表示ボタン
  def link_to_sharing_folder_for_show
      m =Menu.find(:first,:conditions =>["product_id =?",@menu_select_product_id]).id
      link_to_view_motion(s_("PjcAttachment|sharing_folder_for_show"),
                            @current_view, m,
                            {"_"=>"_sharing_folder_for_show"},
                            {:controller => "pjc_attachment",
                            :action => "list",
                            :product_id => @menu_select_product_id,
                            :folder_botton_type =>"PjcSharingFolder",
                            :folder_id_for_show_clear => "true"},
                            :class => "button reloadable_link")  
  end
  
  # 添付ファイル表示ボタン
  def link_to_content_of_attachment_for_show
      m =Menu.find(:first,:conditions =>["product_id =?",@menu_select_product_id]).id
      link_to_view_motion(s_("PjcAttachment|content_of_attachment_for_show"),
                            @current_view, m,
                            {"_"=>"_content_of_attachment_for_show"},
                            {:controller => "pjc_attachment",
                            :action => "list",
                            :product_id => @menu_select_product_id,
                            :file_all => "true"},
                            :class => "button reloadable_link")  
  end
  
  # 添付ファイルをダウンロードするための URL を返す。
  def url_to_download(attachment)
    if attachment.file_type == "StorageObject"
      attachment.file.uri
    elsif attachment.new_record?
      url_for(:controller => attachment.file_type.underscore, :action => "download", :id => attachment.file_id)
    else
      url_for(:action => "download", :id => attachment.id)
    end
  end
  
  # 添付ファイルの更新日時を返す。
  def created_at(attachment)
    (t = (attachment.created_at || attachment.file.created_at)) ? t.strftime("%Y/%m/%d") : ""
  end
  
  # 添付ファイルの登録者を返す。
  def created_by(attachment)
    person_name =""
    created_by =Attachment.find(:first,:conditions =>["id =?",attachment.id]).created_by
    if created_by
      person =PjcPerson.find(:first,:conditions =>["id =?",created_by.person_id])
      if person
        person_name =person.name
      end
    end
    return person_name
  end
  
  # ファイルアップロード画面へ
  def link_to_folder_upload(it)
    if it && it.parent_id != nil && it.parent_id !=""
       link_to_view_motion(image_tag("memo.png", :alt => _("UL")),
                              @sub_view, "upload",
                              {"_" => "_upload_#{it.id}"},
                              {:action => "upload_segment_folder",
                               :product_id => @menu_select_product_id,
                               :folder_id => it.id},
                               :class => "reloadable_link")
    end
  end
  
  # フォルダ追加画面へ
  def link_to_folder_add(it)
      link_to_view_motion(image_tag("memo.png", :alt => s_("PjcAttachment|folder_list|add")),
                              @sub_view, "add", 
                              {"_" => "_add_#{it.id}"},
                              {:action => "create_segment_folder",
                               :product_id => @menu_select_product_id,                                        
                               :folder_id => it.id}, 
                               :class => "reloadable_link")       
  end
  
  # フォルダ詳細画面へ
  def link_to_folder_show(it)
    if it && it.parent_id != nil && it.parent_id !=""
       link_to_view_motion(image_tag("memo.png", :alt => s_("PjcAttachment|folder_list|show")),
                              @sub_view, "show",
                              {"_" => "_folder_show_#{it.id}"},
                              {:action => "form_folder_show",
                               :product_id => @menu_select_product_id,
                               :folder_id => it.id},
                               :class => "reloadable_link")
    end  
  end
  
  # フォルダの詳細情報
  def link_to_folder_detail(it)
    if it && it.parent_id != nil && it.parent_id !=""
       m =Menu.find(:first,:conditions =>["product_id =?",@menu_select_product_id]).id
       link_to_view_motion(image_tag("memo.png", :alt => s_("PjcAttachment|folder_list|list")),
                              @current_view, m,
                              {"_"=>"_#{it.id}_folder_detail"},
                              {:controller => "pjc_attachment",
                              :action => "list",
                              :product_id => @menu_select_product_id,
                              :folder_id_for_show =>it.id},                  # 右側の表示
                              :class => "reloadable_link")
    end
  end
  
  # フォルダ移動先のコピー処理
  def link_to_destination_copy(it)
    if it && it.parent_id != nil && it.parent_id !=""
       link_to_remote("◆",
                              :update =>"folder_destination_copy",
                              :url =>{:action => :folder_destination_copy,
                              :selected_folder_id =>it.id,
                              :selected_folder_name =>it.name})
    end
  end
  
  # ファイルの移動先のコピー処理
  def link_to_file_destination_copy(it)
    if it && it.parent_id != nil && it.parent_id !=""
       link_to_remote("◆",
                              :update =>"folder_destination_copy",
                              :url =>{:action => :file_destination_copy,
                              :selected_folder_id =>it.id,
                              :selected_folder_name =>it.name,
                              :selected_folder_type =>it.class.to_s})
    end
  end  
  
  # ファイルの詳細画面へ 
  def link_to_file_show(it)
      link_to_view_motion(image_tag("memo.png", :alt => s_("PjcAttachment|folder_list|show")),
                                  @sub_view, "show", 
                                  {"_" => "_show_#{it.id}"},
                                  {:action => "show",
                                   :product_id => @menu_select_product_id,                                        
                                   :folder_id => it.id}, 
                                   :class => "reloadable_link")      
  end
  
end
