# -*- coding: utf-8 -*-
module Pick::ProjectSegmentHelper
  include ProjectCollaboration::ProjectHelper::Helper

  def hidden_fields_to_pick
    f = hidden_field_tag("display_id", params[:display_id])
    f += hidden_field_tag("rfw[display_id]", params[:rfw][:display_id])
    f += hidden_field_tag("rfw[narrowing_text]", params[:rfw][:narrowing_text])
    f += hidden_field_tag("rfw[display_narrowing_id]", params[:rfw][:display_narrowing_id])
    f += hidden_field_tag("rfw[project_segment_id]", params[:rfw][:project_segment_id])
    f
  end

  def link_to_clear
    rfw_link_to_pick(s_("rfw|button|Clear"), {
                       :display_narrowing_id => display_narrowing_id,
                       :narrowing_text => '',
                       :project_segment_id => '',
                       :project_segment_name => '',
                     }, {
                       :class => 'button',
                     })
  end

  def link_to_select_segments(project, action)
    url = url_for(:action => action)
    data = {
      :project_id => project.id,
      :display_id => params[:display_id],
      "rfw[project_id]"         => params[:rfw][:project_id],
      "rfw[project_segment_id]" => params[:rfw][:project_segment_id],
      "rfw[project_segment_name]" => params[:rfw][:project_segment_name],
      "rfw[narrowing_text]"     => params[:rfw][:narrowing_text],
    }.to_json
    id = "link_to_select_segments_#{random_id}"
    link = link_to_function ">>", "", :id => id
    link += javascript_tag(<<-JS)
      $('#{id}').observe('click', function(e) {
        var x = Event.element(e).ancestors().detect(function(x) {return x.nodeName == 'TABLE';});
        if (x) {
          var y = x.next().descendants().detect(function(y) {return y.nodeName == 'TBODY'});
          new Ajax.Updater(y, '#{url}', {parameters: #{data}});
        }
      });
    JS
    link
  end

end
