module Pick::LumpHelper
  include Picker::Helper

  # group, personal_group
  def build_tree2(method_name = :link_to_pick_model)
    mode = params[:mode]
    groups = instance_variable_get("@#{mode}s")
    scope = "#{mode}_members".classify.constantize
    groups.map{|g|
      h = {}
      h[:id] = "#{mode}_id_#{g.id}_#{@random_id}"
      h[:text] = __send__(method_name, g)
      if group_expanded?
        h[:expanded] = true
        h[:children] = @people.select{|person|
          scope.exists?("#{mode}_id".to_sym => g.id, :person_id => person.id)
        }.map{|person|
          {
            :id => "person_id_#{person.id}_#{@random_id}",
            :text => __send__(method_name, person),
          }
        }
      else
        h[:expanded] = false
        h[:hasChildren] = !g.people.empty? && !g.__send__("#{mode}_members").empty?
#        h[:hasChildren] = !g.people.empty?
      end
      h
    }
  end

  # company
  def build_tree3(method_name = :link_to_pick_model)
    @companies.map{|c|
      h = {}
      h[:id] = "company_id_#{c.id}_#{@random_id}"
      h[:text] = __send__(method_name, c)
      if company_expanded?
        h[:expanded] = true
        h[:children] = @organizations.select{|o|
          o.company_id == c.id
        }.map{|o|
          h2 = {}
          h2[:id] = "organization_id_#{o.id}_#{@random_id}"
          h2[:text] = __send__(method_name, o)
           if organization_expanded?
            h2[:expanded] = true
            h2[:children] = @people.select{|person|
              c.id == o.company_id &&
              OrganizationMember.exists?(:organization_id => o.id, :person_id => person.id)
            }.map{|person|
              {
                :id => "person_id_#{person.id}_#{@random_id}",
                :text => __send__(method_name, person),
              }
            }
          else
            h2[:expanded] = false
            h2[:hasChildren] = !o.organization_members.empty? && !c.company_members.empty?
          end
          h2
        }
      else
        h[:expanded] = false
        h[:hasChildren] = !c.organizations.empty?
      end
      h
    }
  end

  def organization_tree(company_id, method_name = :link_to_pick_model)
    @organizations.select{|o|
      o.company_id == company_id.to_i
    }.map{|o|
      h = {}
      h[:id] = "organization_id_#{o.id}_#{@random_id}"
      h[:text] = __send__(method_name, o)
      h[:hasChildren] = !o.people.empty? && !o.company.company_members.empty?
      h
    }
  end

  def person_tree(organization_id, method_name = :link_to_pick_model)
    @people.select{|person|
      OrganizationMember.exists?(:organization_id => organization_id, :person_id => person.id)
    }.map{|person|
      {
        :id => "person_id_#{person.id}_#{@random_id}",
        :text => __send__(method_name, person),
      }
    }
  end

  def company_expanded?
    !@organization_name.blank? || !@person_name.blank?
  end

  def organization_expanded?
    !@person_name.blank?
  end

  def group_expanded?
    !@person_name.blank?
  end

  def link_to_pick_model(record)
    rfw_link_to_pick(h(record.name),
                     {
                       :model_value => record.name,
                       :model_name => record.class.name,
                       :model_id => record.id,
                     })
  end

  def link_to_pick_people(record)
    case record
    when picker_model_class("lump", "Person")
      link_to_pick_person(record)
    else
      link_to_pick_group_members(record)
    end
  end

  def link_to_pick_group_members(group)
    case group
    when picker_model_class("lump", "Company")
      t = "company_members"
    when picker_model_class("lump", "Organization")
      t = "organization_members"
    when picker_model_class("lump", "Group")
      t = "group_members"
    when picker_model_class("lump", "PersonalGroup")
      t = "personal_group_members"
    else
    end
    g_ms = Array.new
    group.__send__("#{t}").each do |g_m|
     g_ms << picker_model_class("lump", "Person").find(g_m.person_id)
    end
    values = group.people
    values = values & g_ms
    people = values.sort_by(&:id)

    rfw_link_to_pick(h(group.name),
                     {
                       :people_ids => people.map(&:id).join(','),
                       :people_names=> people.map(&:name).join(',')
                     })
  end

  def link_to_pick_person(person)
    rfw_link_to_pick(h(person.name),
                     {
                       :people_ids => person.id,
                       :people_names => person.name
                     })
  end

end
