module Pick::CalendarHelper

  def calendar(id, options = {}, &block)

    defaults = {
      :table_class      => 'calendar',
      :day_name_class   => 'dayName',
      :normal_day_class => 'normalDay',
      :holiday_class    => 'holiday',
      :empty_day_class  => 'emptyDay'
    }
    options = defaults.merge options

    day_names = [s_("rfw|Calendar|Sun"),
                 s_("rfw|Calendar|Mon"),
                 s_("rfw|Calendar|Tue"),
                 s_("rfw|Calendar|Wed"),
                 s_("rfw|Calendar|Thu"),
                 s_("rfw|Calendar|Fri"),
                 s_("rfw|Calendar|Sat")]

    cal = %Q!<table id="#{id}" class="#{options[:table_class]}" border="0">\n!

    # week names
    cal << "<thead>\n"
    cal << "<tr>\n"
    cal << day_names.map{|day_name|
      %Q!<th class="#{options[:day_name_class]}" >#{day_name}</th>!
    }.join("\n")
    cal << "</tr>\n"
    cal << "</thead>\n"

    # days
    cal << "<tbody>\n"
    day = Date.civil(@year, @month, 1)
    cal << "<tr>\n"
    day.wday.times{
      cal << %Q!<td class="#{options[:empty_day_class]}"> </td>\n!
    }
    while day.month == @month
      cal << "<tr>\n" if day.wday == 0 && day.mday != 1
      if block_given?
        cell_text, cell_attrs = block.call(day)
        day_class = if cell_attrs.kind_of?(Hash) && cell_attrs[:class]
                      cell_attrs[:class]
                    else
                      options[:normal_day_class]
                    end
        day_text = cell_text ? cell_text : day.mday.to_s
      else
        day_class = options[:normal_day_class]
        day_class = options[:holiday_class] if day.wday == 0 || day.wday == 6
        day_text = day.mday.to_s
      end
      cal << %Q!<td class="#{day_class}">#{day_text}</td>\n!
      cal << "</tr>\n" if day.wday == 6
      day += 1
    end
    if day.wday != 0
      (7 - day.wday).times{
        cal << %Q!<td class="#{options[:empty_day_class]}"> </td>\n!
      }
      cal << "</tr>\n"
    end
    cal << "</tbody>\n"
    cal << "</table>\n"
  end

  def date_link(date, return_format, options, html_options = {})
    rfw_link_to_pick(h(date.day),
                     { :return_value => CustomFormatTranslator::format_date(date, return_format)},
                     html_options)
  end

  def calendar_button_tag(label, name)
    rfw_button_to_submit(label,
                         { :name => name },
                         nil,
                         'ancestor',
                         0,
                         nil,
                         { :name => name, :didable_with => '&hearts;', :class => 'button calendar' })
  end

  def year_month_select_tag(seed, suffix)
    result = ''
    result << calendar_button_tag('<<', 'previous_year')
    result << calendar_button_tag('<', 'previous_month')
    result << year_select_tag(@year, seed, suffix)
    result << month_select_tag(@month, seed, suffix)
    if suffix == 'top'
      result << hidden_field_tag('year', @year, :id => "year_#{seed}")
      result << hidden_field_tag('month', @month, :id => "month_#{seed}")
    end
    result << calendar_button_tag('>', 'next_month')
    result << calendar_button_tag('>>', 'next_year')
    result
  end

  def selector(mode, options, selected_value, seed, suffix)
    id = "rfw_select_#{mode}_#{seed}_#{suffix}"
    target_id = "rfw_select_#{mode}_#{seed}_#{suffix == 'top' ? 'bottom' : 'top'}"
    url = url_for(:controller => 'pick/calendar', :action => 'search')
    result = ''
    result << select_tag("#{mode}_#{suffix}",
                         options_for_select(options, selected_value.to_s),
                         :id => id, :class => "calendar_#{mode}")
    result << javascript_tag(<<-JS)
    if ($('#{id}')) {
      $('#{id}').observe('change', function(e){
        $('#{mode}_#{seed}').value = $('#{id}').value;
        $('#{target_id}').value = $('#{id}').value;
        Rfw.submit.bind(e.element())('#{id}', '#{url}');
      });
    }
    JS
    result
  end

  def year_select_tag(selected_year, seed, suffix)
    options = ((selected_year - 2)..(selected_year + 2)).map{|year|
      [year.to_s, year.to_s]
    }
    selector(:year, options, selected_year, seed, suffix)
  end

  def month_select_tag(selected_month, seed, suffix)
    options = (1..12).map{|month| [month.to_s, month.to_s] }
    selector(:month, options, selected_month, seed, suffix)
  end
end
