module MenuHelper
  # メニューにともなう機能へのリンクを返す。
  def link_menu_to(menu, options={})
    unless menu.motion
      return h(s_(menu.name))
    end
    html_options = {
      :class => "link_m reloadable_link",
    }
    if menu.with_ajax?
      html_options[:onclick] = "return onMenu(#{menu.id})"
    end
    html_options.update(options)
    link = link_to(h(s_(menu.name)), menu.url_options, html_options)
    if options[:id]
      product = menu.product
      if product.is_a?(ProductDetailed) && product.model_name == "Product" && product.detail_model_name == "GrantOnWithoutPeriodic"
        hidden_product = ProductDetailed.find(:first, :conditions => {:model_name => "Item", :detail_model_name => "GrantOnWithoutPeriodic"})
        if hidden_product
          hidden_menu = Menu.find(:first, :conditions => {:product_id => hidden_product.id})
          if hidden_menu
            link += link_menu_to(hidden_menu, :id => "link_m_#{hidden_menu.id}", :style => "display:none;")
          end
        end
      end
    end
    return link
  end

  def img_link_menu_to(img, menu, options={})
    unless menu.motion
      return h(s_(menu.name))
    end
    html_options = {
      :class => "link_m reloadable_link",
    }
    if menu.with_ajax?
      html_options[:onclick] = "return onMenu(#{menu.id})"
    end
    html_options.update(options)
    link = link_to(img+"&nbsp;"+h(s_(menu.name)), menu.url_options, html_options)
    if options[:id]
      product = menu.product
      if product.is_a?(ProductDetailed) && product.model_name == "Product" && product.detail_model_name == "GrantOnWithoutPeriodic"
        hidden_product = ProductDetailed.find(:first, :conditions => {:model_name => "Item", :detail_model_name => "GrantOnWithoutPeriodic"})
        if hidden_product
          hidden_menu = Menu.find(:first, :conditions => {:product_id => hidden_product.id})
          if hidden_menu
            link += link_menu_to(hidden_menu, :id => "link_m_#{hidden_menu.id}", :style => "display:none;")
          end
        end
      end
    end
    return link
  end
end
