# -*- coding: utf-8 -*-
module AttachmentHelper
  # 添付対象の情報を埋め込むためのタグを返す。
  def hidden_attachable(name, x)
    hidden_field_tag name, @attachment.attributes["attachable_#{name}"], {:id => "attachable_#{name}_#{x}"}
  end

  # 添付ファイルを削除するための check box を返す。
  def check_box_to_delete(attachment)
    if attachment.new_record?
      file_id = attachment.file_id
      name = attachment.file_type.underscore
      check_box_tag("#{name}[]", file_id, false, :id => "#{name}_#{file_id}")
    else
      check_box_tag("attachment[]", attachment.id, false, :id => "attachment_#{attachment.id}")
    end
  end

  # 添付ファイルをダウンロードするための URL を返す。
  def url_to_download(attachment)
    if attachment.file_type == "StorageObject"
      if internet_explorer?
        URI.decode(attachment.file.uri)
      else
        attachment.file.uri
      end
    elsif attachment.new_record?
      url_for(:controller => attachment.file_type.underscore, :action => "download", :id => attachment.file_id)
    else
      url_for(:action => "download", :id => attachment.id)
    end
  end

  # 添付ファイルの更新日時を返す。
  def updated_at(attachment)
    (t = (attachment.updated_at || attachment.created_at || attachment.file.updated_at || attachment.file.created_at)) ? t.strftime("%Y/%m/%d %H:%M:%S") : ""
  end

  # 添付ファイルのサマリを返す。
  def summary
    result = []
    if (count = @attachments.size) > 0
      result << ns_("rfw|Attachment|%{count} file attached", "%{count} files attached", count) % {:count => count}
    else
      result << s_("rfw|Attachment|no file attached")
    end
    if session[:uploaded_attachments]
      if @attachable
        uploaded_attachments = session[:uploaded_attachments].select {|a| a.attachable == @attachable}
      else
        uploaded_attachments = session[:uploaded_attachments].select {|a| a.attachable_type == params[:type] && !a.attachable_id}
      end
      if (count = uploaded_attachments.size) > 0
        result << ns_("rfw|Attachment|%{count} file uploaded", "%{count} files uploaded", count) % {:count => count}
      end
    end
    if @attachable
      if session[:deleted_attachments] && (count = session[:deleted_attachments].select {|a| a.attachable == @attachable}.size) > 0
        result << ns_("rfw|Attachment|%{count} file will be deleted", "%{count} files will be deleted", count) % {:count => count}
      end
    end
    s_("rfw|Attachment|Attachments: ") + result.join(" / ")
  end
end
