class SearchController < ApplicationController
  before_filter :verify_display_id

  def index
    @search_condition = SearchCondition.find_or_create_by_person_id_and_display_id(User.current.person_id, @display.id)
    load
  end

  # search_condition_items を追加する。
  def add_item
    @search_condition = SearchCondition.find_or_create_by_person_id_and_display_id(User.current.person_id, @display.id)
  end

  # search_condition_items を削除する。
  def remove_item
    @search_condition = SearchCondition.find_or_create_by_person_id_and_display_id(User.current.person_id, @display.id)
  end

  # search_condition_items を並び替える。
  def order_item
    search_condition = verified_search_condition
    render :update do |page|
      page[:order_search_condition_items].value = params[:search_condition].to_json
    end
  end

  # 編集した検索条件を保存する。
  def save
    @search_condition = SearchCondition.find_or_create_by_person_id_and_display_id(User.current.person_id, @display.id)
    load
    begin
      @old_search_condition_items = ActiveSupport::JSON.decode(params[:old_search_condition_items] || "[]")
      raise "must be an array" unless @old_search_condition_items.is_a?(Array)
      @old_search_condition_items.each {|id| raise "must be an positive integer" unless id.is_a?(Integer) && id > 0}
    rescue ActiveSupport::JSON::ParseError
      @old_search_condition_items = []
    end
    begin
      @new_search_condition_items = ActiveSupport::JSON.decode(params[:new_search_condition_items] || "[]")
      raise "must be an array" unless @new_search_condition_items.is_a?(Array)
      @new_search_condition_items.each {|id| raise "must be an positive integer" unless id.is_a?(Integer) && id > 0}
    rescue ActiveSupport::JSON::ParseError
      @new_search_condition_items = []
    end
    begin
      @order_search_condition_items = ActiveSupport::JSON.decode(params[:order_search_condition_items] || "[]")
      raise "must be an array" unless @order_search_condition_items.is_a?(Array)
      @order_search_condition_items.each {|id| raise "must be a string" unless id.is_a?(String)}
    rescue ActiveSupport::JSON::ParseError
      @order_search_condition_items = []
    end
    proc = lambda do |item, prefix|
      if ( (item_id           = params["#{prefix}_item_id".to_sym]) &&
           (condition_value   = params["#{prefix}_condition_value".to_sym]) &&
           (condition_pattern = params["#{prefix}_condition_pattern".to_sym]) &&
           (order_by          = params["#{prefix}_order_by".to_sym]) )
        item.item_id             = item_id
        item.condition_value     = condition_value
        item.condition_pattern   = condition_pattern
        item.order_by            = order_by
        item.save!
      end
    end
    SearchConditionItem.transaction do
      items = []
      @search_condition.search_condition_items.each do |item|
        if @old_search_condition_items.include?(item.id)
          # remove the old item
          item.destroy
        elsif k = @order_search_condition_items.index("item_#{item.id}")
          # update the item
          proc.call(item, "item_#{item.id}")
          items[k] = item
        end
      end
      @new_search_condition_items.each do |n|
        if k = @order_search_condition_items.index("newbie_#{n}")
          # add a new item
          item = SearchConditionItem.new(:search_condition_id => @search_condition.id)
          proc.call(item, "newbie_#{n}")
          items[k] = item
        end
      end
      # sort items
      items.each_with_index {|item, i| item.insert_at(i + 1) if item}
    end
    x_close_or_redirect_to :controller => "product", :action => "list", :list => @display.id, :id => @display.product_id
  end

  private

  def load
    @search_condition_items = @search_condition.search_condition_items
    @parent_view = "view_m"
    @current_view = "view_search"
    @sub_view = "view_detail"
  end

  def verify_display_id
    unless params[:display_id]
      raise ArgumentError, "missing display_id"
    end
    @display = Display.find(params[:display_id].to_i)
  end

  def verified_search_condition_item
    @search_condition = SearchCondition.find_by_person_id_and_display_id(User.current.person_id, @display.id)
    raise ActiveRecord::RecordNotFound, "missing search_condition" unless @search_condition
    item = SearchConditionItem.find(params[:search_condition_item_id].to_i)
    raise ArgumentError, "search_condition_id mismatch" unless @search_condition.id == item.search_condition_id
    return item
  end

  def verified_search_condition
    @search_condition = SearchCondition.find_by_person_id_and_display_id(User.current.person_id, @display.id)
    raise ArgumentError, "search_condition_id mismatch" unless @search_condition.id == params[:id].to_i
    return @search_condition
  end
end
