# -*- coding: utf-8 -*-
# 検索区分を制御する。
class RetrievalDivisionController < ApplicationController

  before_filter :check_parameters, :except => [:test]

  # 検索区分ごとに選択できる値の一覧を表示する。
  def list
    options = {:conditions => {:retrieval_division => params[:retrieval_division]}, :select => "name", :order => "code"}
    @retrieval_divisions = RetrievalDivision.find(:all, options)
  end

  # (試験用)
  def test
  end

  private

  def check_parameters
    if params[:retrieval_division].blank? || params[:rfw].nil? || params[:rfw][:name].blank?
      raise ClientError, "rfw parameters are missing"
    end
  end

end
