# -*- coding: utf-8 -*-
# プロジェクトを制御する。
class ProjectController < ApplicationController

  before_filter :check_rfw_project, :only => [:list, :search_projects, :search_segments, :reset_project]
  before_filter :check_rfw_retrieval_divisions, :only => [:select_retrieval_divisions, :commit_retrieval_divisions]

  # プロジェクトを選択するための一覧を表示する。
  def list
    @code = params[:code]
    @name = params[:name]
    projects = Project.find(:all, :select => "id, code, name", :order => "code")
    projects = projects.select {|m| m.code && m.code.index(@code) == 0} unless @code.blank?
    projects = projects.select {|m| m.name && m.name.index(@name) == 0} unless @name.blank?
    @projects = projects
  end

  # プロジェクト/業務選択のため、プロジェクトを検索する。
  def search_projects
    prepare
  end

  # プロジェクト/業務選択のため、業務を検索する。
  def search_segments
    @project = Project.find(params[:project_id])
    @segments = @project.segments
  end

  # 区分選択を行う。
  def select_retrieval_divisions
  end

  # 区分選択を指定する。
  def commit_retrieval_divisions
    data = {}
    data[params[:rfw][:project_retrieval_divisions]] = @retrieval_divisions.map do |rd|
      value = params["retrieval_division_#{rd}"]
      value.blank? ? s_("pjc|Project|(unspecified)") : value
    end.join("-")
    @retrieval_divisions.each do |rd|
      key = params[:rfw]["project_retrieval_division_#{rd}"]
      value = params["retrieval_division_#{rd}"]
      data[key] = value
    end
    render :text => data.to_json
  end

  # 現在のプロジェクト/業務をリセットする。
  def reset_project
    session[:project_id] = nil
    session[:project_segment_id] = nil
    prepare
    render :action => "search_projects"
  end

  # (試験用)
  def test
  end

  private

  def check_rfw_project
    if params[:rfw].nil? || params[:rfw][:project].blank? || params[:rfw][:project_id].blank?
      raise ClientError, "rfw parameters are missing"
    end
  end

  def check_rfw_retrieval_divisions
    if params[:rfw].nil? || params[:rfw][:project_retrieval_divisions].blank?
      raise ClientError, "rfw parameters are missing"
    end
    @retrieval_divisions = (1..10)
  end

  def prepare
    @code = params[:code]
    @name = params[:name]
    projects = Project.find(:all, :select => "id, code, name", :order => "code")
    projects = projects.select {|m| m.code && m.code.index(@code) == 0} unless @code.blank?
    projects = projects.select {|m| m.name && m.name.index(@name) == 0} unless @name.blank?
    @projects = projects
    project_id = params[params[:rfw][:project_id]] || session[:project_id]
    unless project_id.blank?
      @project = Project.find(project_id)
      @segments = @project.segments
    end
  end

end
