# -*- coding: utf-8 -*-
# プロダクトの制御を行う:
# - 一覧画面
# - 詳細画面
# - 新規作成画面
# - 編集画面
# - 削除画面
class PjcTaskRecordController < ProductController
   def record_picker
       @task_record_product_id =params[:product_id]

       view_in :m
       prepare_display_to_list
       options = @display.query_options
       options.update(:order => "task_records.id desc")
       setup_list_id
       setup_per_page(PjcTaskRecord, options) do |default_per_page|
         sync_fragment("m", :per, default_per_page)
       end
       sync_fragment("m", :page, 1)
       @task_record_task_id = params[:task_id]
       options[:conditions] = "task_records.task_id = #{params[:task_id]}"
       @things =PjcTaskRecord.find(:all,:conditions => options[:conditions],
                                   :order => options[:order_by] || options[:order]) 
       @header_per_line = User.list_header_per_line
   end
      
   def precede_task_record_date
       type ="precede_task_record"
       if params[:task_record_id] && params[:domain_id]
          @precede_task_record = record_find(params[:task_record_id], params[:domain_id], type)
       end
       if params[:ahead_task_record_id] && params[:ahead_domain_id]
          @ahead_precede_task_record = record_find(params[:ahead_task_record_id], params[:ahead_domain_id], type) 
       end
       render :partial =>"precede_task_record_date"       
   end
   
   def task_milestone_record_date
       type ="task_milestone_record"
       if params[:task_record_id] && params[:domain_id]
          @task_milestone_record = record_find(params[:task_record_id], params[:domain_id], type)
       end
       if params[:ahead_task_record_id] && params[:ahead_domain_id]
          @ahead_task_milestone_record = record_find(params[:ahead_task_record_id], params[:ahead_domain_id], type) 
       end
       render :partial =>"task_milestone_record_date"       
   end
   
   def record_find(task_record_id, domain_id, type)
      conditions =["domain_id = ? and task_record_id = ?",domain_id, task_record_id]
      if type =="precede_task_record"
         date = PjcPrecedeTaskRecord.find(:all, :conditions =>conditions)    
      elsif type =="task_milestone_record"
         date = PjcTaskMilestoneRecord.find(:all, :conditions =>conditions)    
      end
      return date
   end
   
end
