class PjcSegmentChecklistController < ApplicationController
  include PaginationConfiguration
  include RandomId

  # <tt>list</tt> へリダイレクトする。
  def index
    redirect_to :action => :list
  end

  # 一覧画面を表示する。
  def list
    session[:checklist_product_id] = params[:product_id]
    @checklist_product_id = session[:checklist_product_id]
    view_in :m
    prepare_display_to_list
    if @display.narrowing?
      if params[:narrowing_text]
        session[:display_narrowing] ||= HashWithIndifferentAccess.new
        if params[:display_narrowing_id].blank? || params[:display_narrowing_id].to_i == 0
          display_narrowing = @display.active_display_narrowing(session)
        else
          display_narrowing = DisplayNarrowing.find(params[:display_narrowing_id].to_i)
        end
        dns = DisplayNarrowing.find(:all, :select => "display_id", :conditions => {:narrowing_id => display_narrowing.narrowing_id})
        dns.map(&:display_id).each do |display_id|
          session[:display_narrowing][display_id] ||= HashWithIndifferentAccess.new
          session[:display_narrowing][display_id][:id] = display_narrowing.narrowing_id
        end
        @display.narrowing_value_keys.each do |key|
          session[key] = nil
        end
        @display.narrowing_value_keys(session).each do |key|
          session[key] = params[:"narrowing_value_#{key}"]
        end
      end
      @display.narrow_to(session)
    end
    @items.each{|item|
      next unless item.condition_pattern == 'custom'
      keys = item.condition_value.split(';').last.split(',').map{|v| v.strip.to_sym }
      hash = {}
      keys.each{|k| hash[k] = params[k] }
      if hash.values.reject{|v| v.blank? }.empty?
        item.condition_hash = session["#{@display.id}_#{item.id}}"]
      else
        item.condition_hash = hash
        session["#{@display.id}_#{item.id}}"] = item.condition_hash
      end
    }
    case @display.code
    when "LIST"
      session[:segment_checklist_list_type] = "LIST"
      @model_class = PjcSegmentChecklist
      session[:segment_checklist_do_type] = session[:segment_checklist_do_mark] = session[:segment_checklist_project] = session[:segment_checklist_segment] = session[:segment_checklist_segment_checklist] = session[:segment_checklist_q] = nil
      options = @display.query_options(session)
      options.update({:select=>"segment_checklists.project_id as project_id,
                                segment_checklists.segment_id as segment_id,
                                segment_checklists.id as id,
                                segment_checklists.code as code,
                                segment_checklists.name as name,
                                segment_checklists.explanation as explanation"})
      options.update({:joins=>"Inner JOIN projects ON projects.id = segment_checklists.project_id
                               Inner JOIN project_segments ON project_segments.id = segment_checklists.segment_id and project_segments.project_id = segment_checklists.project_id"})
#      if options[:conditions]
#        options.update({:conditions=>options[:conditions].gsub(/segment_checklists.project_code/,"projects.code").gsub(/segment_checklists.project_name/,"projects.name").gsub(/segment_checklists.segment_name/,"project_segments.name")})
#      end
      options[:order] = "segment_checklists.project_id,segment_checklists.segment_id"
      setup_list_id
      setup_per_page(@model_class, options) do |default_per_page|
        sync_fragment("m", :per, default_per_page)
      end
      sync_fragment("m", :page, 1)
      @pages, @things = paginate(@model_class, options)
    when "TASK_LIST"
      session[:segment_checklist_list_type] = "TASK_LIST"
      @model_class = PjcSegmentChecklistTask
      session[:segment_checklist_q] = nil
      options = @display.query_options
      options.update({:select=>"segment_checklist_tasks.code as task_code,
                                segment_checklist_tasks.name as task_name,
                                segment_checklist_tasks.judgment as task_judgment, 
                                segment_checklist_tasks.id as id, 
                                segment_checklist_tasks.explanation as task_explanation, 
                                segment_checklist_tasks.task_level as task_level, 
                                segment_checklist_tasks.position as position, 
                                segment_checklist_tasks.parent_id as parent_id"})
      options.update({:joins=>"JOIN segment_checklists ON segment_checklists.id = segment_checklist_tasks.segment_checklist_id "})

      if params[:id]
        begin
          @it = PjcSegmentChecklist.find(params[:id], :readonly => true)
        rescue ActiveRecord::RecordNotFound
          flash[:notice] = s_("rfw|flash|notice|It does not exist.")
          x_close_or_redirect_to :action => "list"
          return
        end
      else
        @it = PjcSegmentChecklist.find(:first, :readonly => true)
      end
        session[:segment_checklist_id_for_task_csv] = @it.id
        if params[:project] && params[:project] != ""
          @selected_project = params[:project].to_i
        elsif session[:segment_checklist_project] && session[:segment_checklist_project] != ""
          @selected_project = session[:segment_checklist_project]
        else
          @selected_project = @it.project_id if @it && @it != {}
        end
       session[:segment_checklist_project] = @selected_project
       
        if params[:segment] && params[:segment] != ""
          if @selected_project == PjcProjectSegment.find(params[:segment]).project_id
            @selected_segment = params[:segment].to_i
          else
            p_s = PjcProjectSegment.find(:first, :conditions=>{:project_id=> @selected_project}, :order=>"code")
            if p_s != nil && p_s != ""
              @selected_segment = p_s.id
            else
            end
          end
        elsif session[:segment_checklist_segment] && session[:segment_checklist_segment] != ""
          @selected_segment =  session[:segment_checklist_segment]
        else
          p_s = PjcProjectSegment.find(:first, :conditions=>{:project_id=> @selected_project}, :order=>"code")
          if p_s != nil && p_s != ""
            @selected_segment = p_s.id
          else
          end
          @selected_segment = @it.segment_id if params[:id]
        end
       session[:segment_checklist_segment] = @selected_segment
       
        if params[:segment_checklist] && params[:segment_checklist] != ""
          if @selected_project == PjcSegmentChecklist.find(params[:segment_checklist]).project_id && @selected_segment == PjcSegmentChecklist.find(params[:segment_checklist]).segment_id
            @selected_segment_checklist = params[:segment_checklist].to_i
          else
            s_c = PjcSegmentChecklist.find(:first, :conditions=>{:project_id=> @selected_project, :segment_id=>@selected_segment}, :order=>"code")
            if s_c != nil && s_c != ""
              @selected_segment_checklist = s_c.id
            else
            end
          end
        elsif session[:segment_checklist_segment_checklist] && session[:segment_checklist_segment_checklist] != ""
          @selected_segment_checklist = session[:segment_checklist_segment_checklist]
        else
          s_c = PjcSegmentChecklist.find(:first, :conditions=>{:project_id=> @selected_project, :segment_id=>@selected_segment}, :order=>"code")
          if s_c != nil && s_c != ""
            @selected_segment_checklist = s_c.id
          else
          end
          @selected_segment_checklist = @it.id if params[:id]
        end
      session[:segment_checklist_segment_checklist] = @selected_segment_checklist
      
      @projects = Array.new
      if PjcProject.find(:all, :conditions=>{}, :order=>"code") != nil && PjcProject.find(:all, :conditions=>{}, :order=>"code") != "" && PjcProject.find(:all, :conditions=>{}, :order=>"code") != []
        @projects = PjcProject.find(:all, :conditions=>{}, :order=>"code")
      else
        @projects << PjcProject.new(:id=>"0",:name=>s_("PjcSegmentChecklist|no data"))
      end

      @segments = Array.new
      if PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code") != nil && PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code") != ""  && PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code") != []
        @segments = PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code")
      else
        @segments << PjcProjectSegment.new(:id=>"0",:name=>s_("PjcSegmentChecklist|no data"))
      end

      @segment_checklists = Array.new
      if PjcSegmentChecklist.find(:all, :conditions=>{:project_id=> @selected_project, :segment_id=> @selected_segment}, :order=>"code") != nil && PjcSegmentChecklist.find(:all, :conditions=>{:project_id=> @selected_project, :segment_id=> @selected_segment}, :order=>"code") != "" && PjcSegmentChecklist.find(:all, :conditions=>{:project_id=> @selected_project, :segment_id=> @selected_segment}, :order=>"code") != []
        @segment_checklists = PjcSegmentChecklist.find(:all, :conditions=>{:project_id=> @selected_project, :segment_id=> @selected_segment}, :order=>"code")
      else
        @segment_checklists << PjcSegmentChecklist.new(:id=>"0",:name=>s_("PjcSegmentChecklist|no data"))
      end
      
      @it = PjcSegmentChecklist.find(:first, :conditions=>{:project_id=>@selected_project ,:segment_id=>@selected_segment, :id=>@selected_segment_checklist}, :readonly => true)

      @ids = [0] if @it == nil || @it == ""
      
      @ids ||= PjcSegmentChecklistTask.find(:all, :conditions=>{:segment_checklist_id=>@it.id}, :order=>"position").map(&:id)
      
      @ids = [0] if @ids == "" || @ids == []
      
      @ids.each_with_index do |id,index|
        @ids[index] = id.to_s
      end
      
      if params[:task_ids]
        @ids = params[:task_ids]
      end
      
      if params[:close_mark]
        @ids = @ids.to_a - inside_task_id(params[:close_mark])
        params[:close_mark] = nil
      elsif params[:open_mark]
        @ids = @ids.to_a | inside_task_id(params[:open_mark])
        params[:open_mark] = nil
      end
      
      @ids = [0] if @ids == "" || @ids == []
      
      params[:do_type] ||= session[:segment_checklist_do_type]
      params[:do_mark] ||= session[:segment_checklist_do_mark]
      params[:do_mark] = params[:do_mark].to_s if params[:do_mark] && params[:do_mark] != ""
      case params[:do_type]
      when "copy"
        if params[:do_mark] == "root"
          @copy_ids = @ids
        else
          @copy_ids = inside_task_id(params[:do_mark]).unshift(params[:do_mark])
        end
        session[:segment_checklist_do_type] = params[:do_type]
        session[:segment_checklist_do_mark] = params[:do_mark]
        session[:segment_checklist_copy_ids] = @copy_ids
      when "cut"
        @cut_ids = inside_task_id(params[:do_mark]).unshift(params[:do_mark])
        @can_paste_ids = @ids - @cut_ids
        session[:segment_checklist_do_type] = params[:do_type]
        session[:segment_checklist_do_mark] = params[:do_mark]
        session[:segment_checklist_cut_ids] = @cut_ids
      else
      end
      if options[:conditions] && options[:conditions] != ""
        options[:conditions] += " and segment_checklist_tasks.id in (#{@ids.join(",")}) "
      else
        options[:conditions] = " segment_checklist_tasks.id in (#{@ids.join(",")}) "
      end
      
      options[:order] = "position"
      setup_list_id
      setup_per_page(@model_class, options) do |default_per_page|
        sync_fragment("m", :per, default_per_page)
      end
      sync_fragment("m", :page, 1)
#      @pages, @things = paginate(@model_class, options)
      @pages, @things = checklist_task_paginate(@model_class, options)

    when "JUDGMENT_LIST"
      session[:segment_checklist_list_type] = "JUDGMENT_LIST"
      @model_class = PjcSegmentChecklistTask
      session[:segment_checklist_q]= nil
      options = @display.query_options
      
      options.update(:select=>"segment_checklist_tasks.code as judgment_code,
                                segment_checklist_tasks.name as judgment_name,
                                segment_checklist_tasks.judgment as task_judgment, 
                                segment_checklist_tasks.id as id, 
                                segment_checklist_tasks.explanation as task_explanation, 
                                segment_checklist_tasks.task_level as task_level, 
                                segment_checklist_tasks.position as position, 
                                segment_checklist_tasks.parent_id as parent_id
                                  " )
#                                segment_checklist_judgments.judgment_result as judgment_result,
#                                segment_checklist_judgments.judgment_person_id as judgment_person,
#                                segment_checklist_judgments.segment_checklist_task_id as segment_checklist_task_id,
#                                segment_checklist_judgments.judgment_of as judgment_number,
#                                segment_checklist_judgments.judgment_date as judgment_date,
#                                segment_checklist_judgments.judgment_comment as judgment_explanation
      options.update(:join=>"   JOIN segment_checklists ON segment_checklists.id = segment_checklist_tasks.segment_checklist_id 
                                  " )
#                                LEFT JOIN segment_checklist_judgments ON segment_checklist_judgments.segment_checklist_task_id = segment_checklist_tasks.id and judgment_of
      
      if params[:id]
        begin
          @it = PjcSegmentChecklist.find(params[:id], :readonly => true)
        rescue ActiveRecord::RecordNotFound
          flash[:notice] = s_("rfw|flash|notice|It does not exist.")
          x_close_or_redirect_to :action => "list"
          return
        end
      else
        @it = PjcSegmentChecklist.find(:first, :readonly => true)
      end
        session[:segment_checklist_id_for_judgment_csv] = @it.id
        if params[:project] && params[:project] != ""
          @selected_project = params[:project].to_i
        elsif session[:segment_checklist_project] && session[:segment_checklist_project] != ""
          @selected_project = session[:segment_checklist_project]
        else
          @selected_project = @it.project_id if @it && @it != {}
        end
        session[:segment_checklist_project] = @selected_project

        if params[:segment] && params[:segment] != ""
          if @selected_project == PjcProjectSegment.find(params[:segment]).project_id
            @selected_segment = params[:segment].to_i
          else
            p_s = PjcProjectSegment.find(:first, :conditions=>{:project_id=> @selected_project}, :order=>"code")
            if p_s != nil && p_s != ""
              @selected_segment = p_s.id
            else
            end
          end
        elsif session[:segment_checklist_segment] && session[:segment_checklist_segment] != ""
          @selected_segment = session[:segment_checklist_segment]
        else
          p_s = PjcProjectSegment.find(:first, :conditions=>{:project_id=> @selected_project}, :order=>"code")
          if p_s != nil && p_s != ""
            @selected_segment = p_s.id
          else
          end
          @selected_segment = @it.segment_id if params[:id]
        end
       session[:segment_checklist_segment] = @selected_segment
       
        if params[:segment_checklist] && params[:segment_checklist] != ""
          if @selected_project == PjcSegmentChecklist.find(params[:segment_checklist]).project_id && @selected_segment == PjcSegmentChecklist.find(params[:segment_checklist]).segment_id
            @selected_segment_checklist = params[:segment_checklist].to_i
          else
            s_c = PjcSegmentChecklist.find(:first, :conditions=>{:project_id=> @selected_project, :segment_id=>@selected_segment}, :order=>"code")
            if s_c != nil && s_c != ""
              @selected_segment_checklist = s_c.id
            else
            end
          end
        elsif session[:segment_checklist_segment_checklist] && session[:segment_checklist_segment_checklist] != ""
          @selected_segment_checklist = session[:segment_checklist_segment_checklist]
        else
          s_c = PjcSegmentChecklist.find(:first, :conditions=>{:project_id=> @selected_project, :segment_id=>@selected_segment}, :order=>"code")
          if s_c != nil && s_c != ""
            @selected_segment_checklist = s_c.id
          else
          end
          @selected_segment_checklist = @it.id if params[:id]
        end
      session[:segment_checklist_segment_checklist] = @selected_segment_checklist

      @projects = Array.new
      if PjcProject.find(:all, :conditions=>{}, :order=>"code") != nil && PjcProject.find(:all, :conditions=>{}, :order=>"code") != "" && PjcProject.find(:all, :conditions=>{}, :order=>"code") != []
        @projects = PjcProject.find(:all, :conditions=>{}, :order=>"code")
      else
        @projects << PjcProject.new(:id=>"0",:name=>s_("PjcSegmentChecklist|no data"))
      end

      @segments = Array.new
      if PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code") != nil && PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code") != ""  && PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code") != []
        @segments = PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code")
      else
        @segments << PjcProjectSegment.new(:id=>"0",:name=>s_("PjcSegmentChecklist|no data"))
      end

      @segment_checklists = Array.new
      if PjcSegmentChecklist.find(:all, :conditions=>{:project_id=> @selected_project, :segment_id=> @selected_segment}, :order=>"code") != nil && PjcSegmentChecklist.find(:all, :conditions=>{:project_id=> @selected_project, :segment_id=> @selected_segment}, :order=>"code") != "" && PjcSegmentChecklist.find(:all, :conditions=>{:project_id=> @selected_project, :segment_id=> @selected_segment}, :order=>"code") != []
        @segment_checklists = PjcSegmentChecklist.find(:all, :conditions=>{:project_id=> @selected_project, :segment_id=> @selected_segment}, :order=>"code")
      else
        @segment_checklists << PjcSegmentChecklist.new(:id=>"0",:name=>s_("PjcSegmentChecklist|no data"))
      end      

      @it = PjcSegmentChecklist.find(:first, :conditions=>{:project_id=>@selected_project ,:segment_id=>@selected_segment, :id=>@selected_segment_checklist}, :readonly => true)

      @ids = [0] if @it == nil || @it == ""
      
      @ids ||= PjcSegmentChecklistTask.find(:all, :conditions=>{:segment_checklist_id=>@it.id}, :order=>"position").map(&:id)
      
      @ids = [0] if @ids == "" || @ids == []
      
      if params[:task_ids]
        @ids = params[:task_ids]
      end
      
      if params[:close_mark]
        @ids = @ids.to_a - inside_task_id(params[:close_mark])
        params[:close_mark] = nil
      elsif params[:open_mark]
        @ids = @ids.to_a | inside_task_id(params[:open_mark])
        params[:open_mark] = nil
      end
      
      @ids = [0] if @ids == "" || @ids == []
      if options[:conditions] && options[:conditions] != ""
        options[:conditions] += " and segment_checklist_tasks.id in (#{@ids.join(",")}) "
      else
        options[:conditions] = " segment_checklist_tasks.id in (#{@ids.join(",")}) "
      end
      options[:order] = "position"

      setup_list_id
      setup_per_page(@model_class, options) do |default_per_page|
      sync_fragment("m", :per, default_per_page)
      end
      sync_fragment("m", :page, 1)
      @pages, @things = paginate(@model_class, options)
      
    end

    @header_per_line = User.list_header_per_line
    

    # 再表示ボタンやperのonchangeのときにpageの変更と同じように
    # fragmentのpopup部分を削除する。
    if params["dummy_button"]
      delete_sub_view_fragment(@current_view.sub(/\Aview_/, ""))
    end
  end

  # 詳細画面を表示する。
  def show
    view_in :detail
    prepare_display_to :show
    @list_type = session[:segment_checklist_list_type]
    begin
      case @list_type
      when "LIST"
      @model_class = PjcSegmentChecklist
        @it = @model_class.find(params[:id], :readonly => true)
        @it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> @it.project_id}).name
        @it[:project_code] = PjcProject.find(:first, :conditions=>{:id=> @it.project_id}).code
        @it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> @it.segment_id, :project_id=> @it.project_id}).name
        @it[:checklists_name] = PjcChecklist.find(:first, :conditions=>{:id=> @it.checklist_id}).name
        @tasks = PjcSegmentChecklistTask.find(:all,:conditions=>{:segment_checklist_id=>@it.id}, :order=>"position")
      when "TASK_LIST"
        @model_class = PjcSegmentChecklistTask
        session[:segment_checklist_q] = nil
        @it = @model_class.find(params[:id], :readonly => true)
        @it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> session[:segment_checklist_project]}).name
        @it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> session[:segment_checklist_segment]}).name
        @it[:checklists_name] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).name
        @it[:checklists_code] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).code
      when "JUDGMENT_LIST"
        @model_class = PjcSegmentChecklistTask
        @it = @model_class.find(params[:id], :readonly => true)
        @it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> session[:segment_checklist_project]}).name
        @it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> session[:segment_checklist_segment]}).name
        @it[:checklists_name] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).name
        @it[:checklists_code] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).code
        @judgment_info = PjcSegmentChecklistJudgment.find(:all, :conditions=>{:segment_checklist_task_id=>@it.id}, :order=>"judgment_of desc")
        @per_for_data_info = PjcSegmentChecklistJudgment.find(:first, :conditions=>{:segment_checklist_task_id=>@it.id}, :order=>"judgment_of desc")
      end
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It does not exist.")
      x_close_or_redirect_to :action => "list"
      return
    end

    prepare_display_to_workflow
    if @product.is_a?(ProductDetailed)
      @details = @it.details
    end

    if @display.document?
      @tab_label = @it.__send__(@product.document_name_method)
      @id_suffix = "#{@it.id}of#{@product.id}_#{random_id}"
    end

    return if use_picker

    if @display.mail?
      @disable_mailsend = true
      if params[:mail] && !params[:mail][:recipients].blank?
        @disable_mailsend = false
      end
      if !@disable_mailsend && params[:mailsend]
        mail_to_queue(@it, true)
      end
    end
  end

  # 詳細画面(関連文書用)を表示する。
  def show_only
    @parent_view = "view_detail"
    # @current_view,@sub_view は後で設定
    prepare_display_to :show
    begin
      @it = @model_class.find(params[:id], :readonly => true)
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It does not exist.")
      x_close_or_redirect_to :action => "list"
      return
    end
    prepare_display_to_workflow
    if @product.is_a?(ProductDetailed)
      @details = @it.details
    end
    @id_suffix = "#{@it.id}of#{@product.id}_#{random_id}"
    @current_view = "view_detail#{@it.id}of#{@product.id}"
    @sub_view = "view_subofdetail#{@it.id}of#{@product.id}"

    return if use_picker

    if @display.mail?
      @disable_mailsend = true
      if params[:mail] && !params[:mail][:recipients].blank?
        @disable_mailsend = false
      end
      if !@disable_mailsend && params[:mailsend]
        mail_to_queue(@it, true)
      end
    end

    if params[:tab_id]
      render :update do |page|
        page.replace_html params[:tab_id], :partial => 'detail'
      end
    end
  end

  # 削除を行う。
  def destroy
    view_in :detail
    prepare_display_to :show
    @list_type = session[:segment_checklist_list_type]
    case @list_type
    when "LIST"
      @model_class = PjcSegmentChecklist
    when "TASK_LIST"
      @model_class = PjcSegmentChecklistTask
    when "JUSGMENT_LIST"
      @model_class = PjcSegmentChecklistJudgment
    end
    raise PermissionDenied, "product is not modifiable" unless @product.modifiable?
    raise DisabledException, "disabled with respect to button" unless @display.button_delete?
    unless request.post? && params[:id] && (params[:confirm_destroy] || request.xhr?)
      begin
        @it = @model_class.find(params[:id])
      rescue ActiveRecord::RecordNotFound
        flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
        x_close_or_redirect_to :action => "list"
        return
      end
      # @title : same as show
      @display = Object.new
      def @display.method_missing(sym, *args)
        return false
      end
      def @display.button_back?
        return true
      end
      render :action => :confirm_destroy
      return
    end
    begin
      @it = @model_class.find(params[:id])
      if @product.is_a?(ProductDetailed)
        @details = @it.details
        @details.each {|d| instance_variable_set("@details_#{d.id}", d)}
      end
      begin
        if @list_type == "TASK_LIST"
          for_del_id = inside_task_id(@it.id)
          for_del_id = [0] if for_del_id == nil || for_del_id == []
          for_del = @model_class.find(:all, :conditions=>"id in (#{for_del_id.join(',')})")
          if for_del != nil && for_del != []
            for_del.each do |a|
              a.destroy
            end
          end
        end
        if with_logic(@it, :destroy)
          flash[:notice] = s_("rfw|flash|notice|It was successfully destroyed.")
        else
          flash[:warning] = s_("rfw|flash|warning|It was failed to destroy.")
        end
      rescue WorkflowError
        flash[:warning] = s_("rfw|flash|warning|It could not be destroyed because of its workflow.")
      end
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
    end
    x_close_or_redirect_to :action => "list"
  end

  # 新規作成画面を表示し、新規作成を行う。
  def new
    @copying = !!params[:id]
    @form_type = "judgment_add"
    view_in :detail
    @list_type = session[:segment_checklist_list_type]
    create("form") do
      flash[:notice] = s_("rfw|flash|notice|It was successfully created.")
      x_close_or_redirect_to :action => "list"
    end
  end

  # 編集画面を表示し、編集を行う。
  def edit
    view_in :detail
    prepare_display_to :edit
    begin
      @form_type = "judgment_edit"
      @list_type = session[:segment_checklist_list_type]
      case @list_type
      when "LIST"
        @model_class = PjcSegmentChecklist
        @it = @model_class.find(params[:id])
#        @it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> @it.project_id}).name
#        @it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> @it.segment_id, :project_id=> @it.project_id}).name
#        @it[:checklists_name] = PjcChecklist.find(:first, :conditions=>{:id=> @it.checklist_id}).name
        @tasks = PjcSegmentChecklistTask.find(:all,:conditions=>{:segment_checklist_id=>@it.id})
      when "TASK_LIST"
        @model_class = PjcSegmentChecklistTask
        @it = @model_class.find(params[:id])
        @it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> session[:segment_checklist_project]}).name
        @it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> session[:segment_checklist_segment]}).name
        @it[:checklists_name] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).name
        @it[:checklists_code] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).code
        @for_it = @it
      when "JUDGMENT_LIST"
        @model_class = PjcSegmentChecklistJudgment
        @for_it = PjcSegmentChecklistTask.find(params[:id])
        @for_it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> session[:segment_checklist_project]}).name
        @for_it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> session[:segment_checklist_segment]}).name
        @for_it[:checklists_name] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).name
        @for_it[:checklists_code] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).code
        @it = @model_class.find(:first, :conditions=>{:segment_checklist_task_id=>@for_it.id}, :order=>"judgment_of desc")
#        @it[:judgment] = @for_it.judgment
        @it[:judgment_of] = @it.judgment_of
        @it[:judgment_person] = @it.judgment_person_id
        @it[:judgment_date] = Time.parse(@it.judgment_date).strftime("%Y/%m/%d")
        @it[:judgment_result] = @it.judgment_result
        @it[:judgment_comment] = @it.judgment_comment
        @it[:confirm_person] = @it.confirm_person_id
        @it[:confirm_date] = (@it.confirm_date != nil && @it.confirm_date != "") ? Time.parse(@it.confirm_date).strftime("%Y/%m/%d") : ""
        @it[:confirm_comment] = @it.confirm_comment
        @judgment_info = PjcSegmentChecklistJudgment.find(:all, :conditions=>{:segment_checklist_task_id=>@for_it.id}, :order=>"judgment_of desc")
        @judgment_info.shift
        @per_for_data_info = PjcSegmentChecklistJudgment.find(:first, :conditions=>{:segment_checklist_task_id=>@for_it.id}, :order=>"judgment_of desc")
      end
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
      x_close_or_redirect_to :action => "list"
      return
    end
    case @list_type
    when "LIST"
      @model_class = PjcSegmentChecklist
#      if params[:project]
#        @selected_project = params[:project].to_i
#      end
#      @selected_project ||= @it.project_id
#
#      if params[:segment]
#        @selected_segment = params[:segment].to_i
#      end
#      @selected_segment ||= @it.segment_id
#
#      if params[:checklist]
#        @selected_checklist = params[:checklist].to_i
#      end
#      @selected_checklist ||= @it.checklist_id

#      @projects = Array.new
#      @projects = PjcProject.find(:all, :conditions=>{}, :order=>"code")
#
#      @segments = Array.new
#      @segments = PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code")
#
#      @checklists = Array.new
#      @checklists = PjcChecklist.find(:all, :conditions=>{}, :order=>"code")
    when "TASK_LIST"
      @model_class = PjcSegmentChecklistTask
    when "JUDGMENT_LIST"
      @model_class = PjcSegmentChecklistJudgment
    end
    
    prepare_display_to_workflow

    return if use_picker

    if @product.is_a?(ProductDetailed)
      @details = @it.details
      @details.each {|d| instance_variable_set("@details_#{d.id}", d)}
      begin
        @old_details = ActiveSupport::JSON.decode(params[:old_details] || "[]")
      rescue ActiveSupport::JSON::ParseError
        @old_details = []
      end
      set_new_details
      set_order_details
    end

    if params[:it]
      if @list_type == "LIST"
        @it = PjcSegmentChecklist.find(params[:id])
      elsif @list_type == "TASK_LIST"
        @it = PjcSegmentChecklistTask.find(params[:id])
      end
      if params[:judgment_update]
        set_attributes
        if valid?(@it)
          @it.judgment_person_id = params[:it][:judgment_person]
          @it.segment_checklist_task_id = @for_it.id
          @it.judgment_date = params[:it][:judgment_date].delete("/") if params[:it][:judgment_date] != nil && params[:it][:judgment_date] != ""
          @it.judgment_result = params[:it][:judgment_result]
          @it.judgment_comment = params[:it][:judgment_comment]
          @it.confirm_person_id = params[:it][:confirm_person]
          @it.confirm_date = params[:it][:confirm_date].delete("/") if params[:it][:confirm_date] != nil && params[:it][:confirm_date] != ""
          @it.confirm_comment = params[:it][:confirm_comment]
        else
        end
        begin
          if with_logic(@it, :update)
            flash[:notice] = s_("rfw|flash|notice|It was successfully updated.")
            x_close_or_redirect_to :action => "list"
            return
          end
        rescue ActiveRecord::StaleObjectError
          @stale_object_error = true
        rescue WorkflowError
          set_attributes
          @workflow_error = true
        end
      end
      if request.post? && params[:update]
        if @list_type == "LIST"
#          @it.project_id = @selected_project
#          @it.segment_id = @selected_segment
#          @it.checklist_id = @selected_checklist
#          @it.code = params[:it][:code]
#          @it.name = params[:it][:name]
#          @it.explanation = params[:it][:explanation]
          set_attributes
          
          # update
          begin
            if with_logic(@it, :update)
              flash[:notice] = s_("rfw|flash|notice|It was successfully updated.")
              x_close_or_redirect_to :action => "list"
              return
            end
          rescue ActiveRecord::StaleObjectError
            @stale_object_error = true
          rescue WorkflowError
            set_attributes
            @workflow_error = true
          end
        elsif @list_type == "TASK_LIST"
          @it.code = params[:it][:code]
          @it.name = params[:it][:name]
          @it.judgment = params[:it][:judgment] == "on" ? true : false
          @it.explanation = params[:it][:explanation]
          if @it.name != "" && @it.code != ""
            # update
            begin
              if with_logic(@it, :update)
                flash[:notice] = s_("rfw|flash|notice|It was successfully updated.")
                x_close_or_redirect_to :action => "list"
                return
              end
            rescue ActiveRecord::StaleObjectError
              @stale_object_error = true
            rescue WorkflowError
              set_attributes
              @workflow_error = true
            end
          else
            params[:edit] = "edit"
            @it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> session[:segment_checklist_project]}).name
            @it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> session[:segment_checklist_segment]}).name
            @it[:checklists_name] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).name
            @it[:checklists_code] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).code
            @for_it = @it
            if params[:it][:code] == "" && params[:it][:name] == ""
              @for_code_nil_err = s_("PjcSegmentChecklistTask|code can not be null")
              @for_name_nil_err = s_("PjcSegmentChecklistTask|name can not be null")
              @code_err = true
              @name_err = true
            elsif params[:it][:code] == ""
              @for_code_nil_err = s_("PjcSegmentChecklistTask|code can not be null")
              @code_err = true
            elsif params[:it][:name] == ""
              @for_name_nil_err = s_("PjcSegmentChecklistTask|name can not be null")
              @name_err = true
            end
          end
        end
      end
    end

    render :action => "form"
  end

  # タブ内に編集画面を表示する
  # 編集する
  def edit_only
    prepare_display_to :edit
    begin
      @it = @model_class.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
      x_close_or_redirect_to :action => "list"
      return
    end

    prepare_display_to_workflow

    @current_view = "view_detail#{@it.id}of#{@product.id}"
    @sub_view = "view_picker"

    return if use_picker

    if @product.is_a?(ProductDetailed)
      @details = @it.details
      @details.each {|d| instance_variable_set("@details_#{d.id}", d)}
      begin
        @old_details = ActiveSupport::JSON.decode(params[:old_details] || "[]")
      rescue ActiveSupport::JSON::ParseError
        @old_details = []
      end
      set_new_details
      set_order_details
    end

    if params[:it]
      set_attributes
      if request.post? && params[:update]
        # update
        begin
          if with_logic(@it, :update)
            flash[:notice] = s_("rfw|flash|notice|It was successfully updated.")
            redirect_to :action => 'show_only', :id => params[:id], :tab_id => params[:tab_id]
            return
          end
        rescue ActiveRecord::StaleObjectError
          @stale_object_error = true
        rescue BusinessLogic::Failure => failure
          set_attributes
          @business_logic_failure = failure.message
        rescue WorkflowError
          set_attributes
          @workflow_error = true
        end
      end
    end

    render :update do |page|
      page.replace_html params[:tab_id], :partial => 'form'
    end
  end

  # 関連文書を選択するための一覧を表示する。
  def select_document
    view_in :document
    prepare_display_to_list
    options = @display.query_options
    setup_per_page(@model_class, options) do |default_per_page|
      params[:per] ||= default_per_page
    end
    @pages, @things = paginate(@model_class, options)
    @header_per_line = User.list_header_per_line
    begin
      @relatable = params[:type].constantize.find(params[:id])
    rescue
      @relatable = nil
    end
  end

  # 関連文書向けに新規作成する
  def create_document
    @copying = false
    view_in :document
    create("create_document") do
      p = {
        :type => params[:type],
        :product_id => params[:relatable_product_id],
        :target_id => @it.id,
        :target_type => @it.class.to_s,
        :target_product_id => @product.id,
      }
      p[:id] = params[:id] unless params[:id].blank?
      render :update do |page|
        page << "new Ajax.Updater('document_table_base', '#{url_for(:controller => "document", :action => "select")}', {onComplete: function(){$('view_dp').innerHTML = '';}, parameters: #{p.to_json}})"
      end
    end
  end

  # 詳細を並び替える。
  def order_details
    render :update do |page|
      page[:order_details].value = params[:details_table_body].to_json
    end
  end

  # 詳細を追加する
  def add_detail
  end

  private

  def view_in(key)
    case key
    when :m
      @parent_view = "view_main"
      @current_view = "view_m"
      @sub_view = "view_detail"
    when :detail
      @parent_view = "view_m"
      @current_view = "view_detail"
      @sub_view = "view_picker"
    when :document
      @parent_view = "view_de"
      @current_view = "view_dp"
      @sub_view = "view_dpp"
    end
    params[:id] ||= fetch_fragment(@current_view.sub(/\Aview_/, ""), "id", nil)
  end

  def prepare_display_to(display_type, display_class="display_to_#{display_type}".classify)
    product = Product.find_by_domain_id_and_model_name(User.current.domain_id,"PjcSegmentChecklist")
    if product && product != {}
      @product = product
      @checklist_product_id = product.id
    elsif session[:checklist_product_id]
      @product = Product.find(session[:checklist_product_id])
      @checklist_product_id = session[:checklist_product_id]
    else
      @product = Product.find(params[:product_id])
      @checklist_product_id = params[:product_id]
      session[:checklist_product_id] = @menu_select_product_id
      @checklist_product_id = session[:checklist_product_id]
    end
    case display_type
    when :show, :list
      raise PermissionDenied, "product is invisible" unless @product.visible?
    when :edit, :new
      raise PermissionDenied, "product is not modifiable" unless @product.modifiable?
    else
      raise ArgumentError, "unknown display type: #{display_type}"
    end
    @display ||= @product.displays.find_by_type(display_class)
    raise NotFoundException, "display not found" unless @display
    raise DisabledException, "display disabled" unless @display.enabled?
    Display.current = @display

    tp = @display.code
    if session[:segment_checklist_list_type] && session[:segment_checklist_list_type] != ""
      tp = session[:segment_checklist_list_type]
    end

    case tp
    when "LIST"
      @model_class = PjcSegmentChecklist
      case display_type
      when :show
        @title = s_"PjcSegmentChecklist|title|show"
      when :edit
        @title = s_"PjcSegmentChecklist|title|edit"
      when :new
        @title = s_"PjcSegmentChecklist|title|new"
      end
    when "TASK_LIST"
      @model_class = PjcSegmentChecklistTask
      case display_type
      when :show
        @title = s_"PjcSegmentChecklistTask|title|show"
      when :edit
        @title = s_"PjcSegmentChecklistTask|title|edit"
      when :new
        @title = s_"PjcSegmentChecklistTask|title|new"
      end
    when "JUDGMENT_LIST"
      @model_class = PjcSegmentChecklistJudgment
      case display_type
      when :show
        @title = s_"PjcSegmentChecklistJudgment|title|show"
      when :edit
        @title = s_"PjcSegmentChecklistJudgment|title|edit"
      when :new
        @title = s_"PjcSegmentChecklistJudgment|title|new"
      end
    end
    @title ||= @display.name
    @title = "no title" if @title.blank?
    @items = @display.items.find(:all, :conditions => ["layout > 0"], :order => "layout,id")
    @items = @items.select(&:selected?) if @display.is_a?(DisplayToListPrivate)
    if @product.is_a?(ProductDetailed)
      items = @items.select {|item| item.table_name == @product.table_name}
      @items, @detail_items = items, (@items - items)
    end
  end

  def prepare_display_to_list
    display_type = :list
    display_class = "display_to_#{display_type}".classify
    begin
      @product = Product.find(params[:product_id])
      session[:checklist_product_id] = @product.id
    rescue ActiveRecord::RecordNotFound
      raise NotFoundException, "product not found"
    end
    @display_list = @product.displays.select do |display|
      (display.is_a?(DisplayToListPrivate) && display.person_id == User.current.person_id) ||
        (display.class == DisplayToList && display.enabled?)
    end.sort_by do |display|
      display.position || 0
    end
    raise NotFoundException, "display not found" if @display_list.empty?
    list_id = params[:list] || fetch_fragment("m", :list, nil)
    if user_id = User.current_id
      if @default_list = DefaultList.find_by_product_id_and_user_id(@product.id, user_id)
        # use the default list unless specified
        list_id ||= @default_list.display_id
      end
    end
    if list_id
      params[:list] = list_id
      list_id = list_id.to_i
      @display = @display_list.find {|d| d.id == list_id }
    end
    @title = @product.name
    prepare_display_to(display_type, display_class)
  end

  def prepare_display_to_workflow
    return unless @display.workflow_enabled?
    client = WorkflowClient.client('probe')
    @wf_config = client.configuration(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                                      WorkflowStruct::Message.new(:body => wf_message_body),
                                      @product.workflow)
    wf_items = @wf_config.items
    @items.each do |item|
      if wf_items && (i = wf_items.detect{|v| v.id == item.id })
        item.validates_presence = i.validates_presence
      else
        item.instance_variable_set(:@writable, false)
      end
    end
    params[:workflow] ||= {}
    params[:workflow][:option] ||= {}
  rescue Errno::ECONNREFUSED => ex
    logger.error("ERROR: workflow server down")
    logger.error(ex)
    logger.error(ex.backtrace.join("\n"))
    raise ServiceUnavailable, "Workflow server down"
  end

  def set_new_details
    begin
      @new_details = ActiveSupport::JSON.decode(params[:new_details] || "[]")
    rescue ActiveSupport::JSON::ParseError
      @new_details = []
    end
    @new_details.each do |n|
      instance_variable_set("@new_details_#{n}", @product.detail_class.new)
    end
  end

  def set_order_details
    begin
      @order_details = ActiveSupport::JSON.decode(params[:order_details] || "[]")
    rescue ActiveSupport::JSON::ParseError
      @order_details = []
    end
  end

  def create(template, &block)
    prepare_display_to :new
    params[:mail] ||= {}
    @list_type = params[:list_type] = "TASK_LIST" if params[:task_add] || params[:task_create] || params[:task_paste]
    case @list_type
    when "LIST"
      @model_class = PjcSegmentChecklist
      @it = @model_class.new
#      @for_it = @model_class.find(params[:id])
    when "TASK_LIST"
      @model_class = PjcSegmentChecklistTask
      @copying = false
      if params[:task_paste] && params[:task_paste] != ""
        if params[:it]
          index = params[:it][:index]
          params[:do_type] = session[:segment_checklist_do_type]
          @child_tasks = session[:segment_checklist_child_tasks]
          @old_tasks = PjcSegmentChecklistTask.find(:all, :conditions=>{:segment_checklist_id=>session[:segment_checklist_segment_checklist]}, :order=>"position")
          @for_it = session[:segment_checklist_for_it]
          case params[:do_type]
          when "copy"
            @copy_ids = session[:segment_checklist_copy_ids]
            @wait_for_update = make_task_paste_date(@old_tasks,@child_tasks,@copy_ids,index,@for_it)
            per_position = 0
            @wait_for_update.each do |task|
              per_position += 1
              if task.is_a?(PjcSegmentChecklistTask)
                task.position = per_position
                task.save!
              else
                if @old_parent_id == nil || @old_parent_id == ""
                  if session[:segment_checklist_do_mark] == "root" 
                    @new_parent_id = ""
                    @for_it.task_level = 0
                  else
                    @new_parent_id = @for_it.id
                  end
                elsif @old_parent_id != task[:parent_id] || @parent_level < task[:task_level]
                  @new_parent_id = @new_id
                else
                end
                @parent_level = task[:task_level]
                @old_parent_id = task[:parent_id]
                @old_parent_id = "null" if @old_parent_id == nil || @old_parent_id == ""
                @old_level ||= task[:task_level]
                a = task[:task_level] - @old_level + 1
                new_task = PjcSegmentChecklistTask.new
                new_task.segment_checklist_id = @for_it.segment_checklist_id
                new_task.parent_id = @new_parent_id
                new_task.code = task[:code]
                new_task.name = task[:name]
                new_task.explanation = task[:explanation]
                new_task.judgment = task[:judgment]
                new_task.position = per_position
                new_task.task_level = @for_it.task_level + a
                new_task.save!
                @new_id = new_task.id
              end
            end
          when "cut"
            @cut_ids = session[:segment_checklist_cut_ids]
            @wait_for_update = make_task_paste_date(@old_tasks,@child_tasks,@cut_ids,index,@for_it)
            per_position = 0
            @wait_for_update.each do |task|
              if task.is_a?(PjcSegmentChecklistTask)
                if @cut_ids.include?("#{task.id}")
                  task.destroy
                else
                  per_position += 1
                  task.position = per_position
                  task.save!
                end
              else
                per_position += 1
                if @old_parent_id == nil || @old_parent_id == ""
                  if session[:segment_checklist_do_mark] == "root" 
                    @new_parent_id = ""
                    @for_it.task_level = 0
                  else
                    @new_parent_id = @for_it.id
                  end
                elsif @old_parent_id != task[:parent_id] || @parent_level < task[:task_level]
                  @new_parent_id = @new_id
                else
                end
                @parent_level = task[:task_level]
                @old_parent_id = task[:parent_id]
                @old_parent_id = "null" if @old_parent_id == nil || @old_parent_id == ""
                @old_level ||= task[:task_level]
                a = task[:task_level] - @old_level + 1
                new_task = PjcSegmentChecklistTask.new
                new_task.segment_checklist_id = @for_it.segment_checklist_id
                new_task.parent_id = @new_parent_id
                new_task.code = task[:code]
                new_task.name = task[:name]
                new_task.explanation = task[:explanation]
                new_task.judgment = task[:judgment]
                new_task.position = per_position
                new_task.task_level = @for_it.task_level + a
                new_task.save!
                @new_id = new_task.id
              end
            end
          end
        end
        session[:segment_checklist_do_type] = session[:segment_checklist_do_mark] = session[:segment_checklist_q] = nil
        flash[:notice] = s_("PjcSegmentChecklist|notice|It was successfully pasted.")
        x_close_or_redirect_to :action => "list"
        return
      end
      unless params[:task_create]
        if params[:task_add]
          @it = PjcSegmentChecklistTask.new
          @it = session[:segment_checklist_it]
          @for_it = session[:segment_checklist_for_it]
          @child_tasks = session[:segment_checklist_child_tasks]
          @wait_for_update = session[:segment_checklist_wait_for_update]
          if params[:it]
            unless params[:it][:code] == "" || params[:it][:name] == ""
              index = params[:it][:index]
  #            session[:segment_checklist_q] ||= 0
              if index == "last"
                if @wait_for_update == nil || @wait_for_update == []
                  o = []
                  o << params[:it]
                  @wait_for_update = o
                  @child_tasks << params[:it]
                else
  #              session[:segment_checklist_q] += 1
                  if @child_tasks && @child_tasks != []
                    last = @child_tasks[-1]
                    for_no = @wait_for_update.index(last) + 1
                  else
                    for_no = @wait_for_update.index(@for_it) + 1
                  end
                  o = @wait_for_update[0,for_no]
                  p = @wait_for_update - o
                  o << params[:it]
                  @wait_for_update = o + p
                  @child_tasks << params[:it]
                end
              else
                a = @child_tasks[0, index.to_i]
                b = @child_tasks - a
                m = b[0]
                n = @wait_for_update.index(m)
                x = @wait_for_update[0, n.to_i]
                y = @wait_for_update - x
                x << params[:it]
                x += y
                @wait_for_update = x
                a << params[:it]
                a += b
                @child_tasks = a
              end
              @for_code_nil_err = ""
              @for_name_nil_err = ""
              @taskcode = ""
              @taskname = ""
              @taskexplanation = ""
              @taskjudgment = ""
            else
              if params[:it][:code] == "" && params[:it][:name] == ""
                @for_code_nil_err = s_("PjcSegmentChecklistTask|code can not be null")
                @for_name_nil_err = s_("PjcSegmentChecklistTask|name can not be null")
                @code_err = true
                @name_err = true
                @taskexplanation = params[:it][:explanation]
                @taskjudgment = "checked" if params[:it][:judgment] == "on"
              elsif params[:it][:code] == ""
                @for_code_nil_err = s_("PjcSegmentChecklistTask|code can not be null")
                @code_err = true
                @taskname = params[:it][:name]
                @taskexplanation = params[:it][:explanation]
                @taskjudgment = "checked" if params[:it][:judgment] == "on"
              elsif params[:it][:name] == ""
                @for_name_nil_err = s_("PjcSegmentChecklistTask|name can not be null")
                @name_err = true
                @taskcode = params[:it][:code]
                @taskexplanation = params[:it][:explanation]
                @taskjudgment = "checked" if params[:it][:judgment] == "on"
              end
            end
          else
          end
          session[:segment_checklist_it] = @it
          session[:segment_checklist_child_tasks] = @child_tasks
          session[:segment_checklist_wait_for_update] = @wait_for_update
        elsif params[:button_name] == "task_clear"
          @it = session[:segment_checklist_it]
          @for_it = session[:segment_checklist_for_it]
          @child_tasks = session[:segment_checklist_child_tasks]
          @wait_for_update = session[:segment_checklist_wait_for_update]
        else
          @it = PjcSegmentChecklistTask.new
          @it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> params[:project]}).name
          params[:segment]
          @it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> params[:segment]}).name
          @it[:checklists_name] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> params[:segment_checklist]}).name
          @it[:checklists_code] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> params[:segment_checklist]}).code
          @it[:index] = 0
          if params[:id] && params[:id] != "" && params[:id] != "0"
            @for_it = PjcSegmentChecklistTask.find(params[:id])
            @for_it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> params[:project]}).name
            @for_it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> params[:segment]}).name
            @for_it[:checklists_name] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> params[:segment_checklist]}).name
            @for_it[:checklists_code] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> params[:segment_checklist]}).code
            @for_it[:index] = 0
            @child_tasks = PjcSegmentChecklistTask.find(:all, :conditions=>{:parent_id=>params[:id]}, :order=>"position")
          else
            @for_it = PjcSegmentChecklistTask.find(:first,:conditions=>{:segment_checklist_id=>session[:segment_checklist_segment_checklist]})
            @for_it = PjcSegmentChecklistTask.new if  @for_it == nil || @for_it == []
            @for_it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> params[:project]}).name
            @for_it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> params[:segment]}).name
            @for_it[:checklists_name] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> params[:segment_checklist]}).name
            @for_it[:checklists_code] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> params[:segment_checklist]}).code
            @for_it[:index] = 0
            @child_tasks = PjcSegmentChecklistTask.find(:all, :conditions=>{:task_level=>1,:segment_checklist_id=>session[:segment_checklist_segment_checklist]}, :order=>"position")   
            session[:segment_checklist_do_mark] = "root"  if params[:do_mark] == "root"            
          end
          
          @wait_for_update = PjcSegmentChecklistTask.find(:all, :conditions=>{:segment_checklist_id=>session[:segment_checklist_segment_checklist]}, :order=>"position")
          session[:segment_checklist_wait_for_update] = @wait_for_update
          session[:segment_checklist_it] = @it
          session[:segment_checklist_for_it] = @for_it
          session[:segment_checklist_child_tasks] = @child_tasks
        end
      else
        @wait_for_update = session[:segment_checklist_wait_for_update]
        if @wait_for_update == PjcSegmentChecklistTask.find(:all, :conditions=>{:segment_checklist_id=>session[:segment_checklist_segment_checklist]}, :order=>"position")
          @not_add_task_err = true
          @it = session[:segment_checklist_it]
          @for_it = session[:segment_checklist_for_it]
          @child_tasks = session[:segment_checklist_child_tasks]
          @wait_for_update = session[:segment_checklist_wait_for_update]
          return render(:action => template)
        else
          @for_it = session[:segment_checklist_for_it]
          per_position = 0
          if params[:id] && params[:id] != "" && params[:id] != "0"
            @wait_for_update.each do |it|
              per_position += 1
              if it.is_a?(PjcSegmentChecklistTask)
                it.position = per_position
                it.save!
              else
                new_task = PjcSegmentChecklistTask.new
                new_task.segment_checklist_id = @for_it.segment_checklist_id
                new_task.parent_id = @for_it.id
                new_task.code = it["code"]
                new_task.name = it["name"]
                new_task.explanation = it["explanation"]
                new_task.judgment = it["judgment"] == "on" ? true : false
                new_task.position = per_position
                new_task.task_level = @for_it.task_level + 1
                new_task.save!
              end
            end
          else
            @wait_for_update.each do |it|
              per_position += 1
              if it.is_a?(PjcSegmentChecklistTask)
                it.position = per_position
                it.save!
              else
                new_task = PjcSegmentChecklistTask.new
                new_task.segment_checklist_id = @for_it.segment_checklist_id
                new_task.segment_checklist_id = session[:segment_checklist_segment_checklist] if @for_it.segment_checklist_id == nil
  #              new_task.parent_id = @for_it.id
                new_task.code = it["code"]
                new_task.name = it["name"]
                new_task.explanation = it["explanation"]
                new_task.judgment = it["judgment"] == "on" ? true : false
                new_task.position = per_position
                new_task.task_level = 1
                new_task.save!
              end
            end
          end
          flash[:notice] = s_("rfw|flash|notice|It was successfully created.")
          x_close_or_redirect_to :action => "list"
          return
        end
      end
    when "JUDGMENT_LIST"
      @copying = false
      @model_class = PjcSegmentChecklistJudgment
      @for_it = PjcSegmentChecklistTask.find(params[:id])
      @for_it[:project_name] = PjcProject.find(:first, :conditions=>{:id=> session[:segment_checklist_project]}).name
      @for_it[:segment_name] = PjcProjectSegment.find(:first, :conditions=>{:id=> session[:segment_checklist_segment]}).name
      @for_it[:checklists_name] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).name
      @for_it[:checklists_code] = PjcSegmentChecklist.find(:first, :conditions=>{:id=> session[:segment_checklist_segment_checklist]}).code
      @it ||= @model_class.new
      @it[:judgment_of] ||= @it.judgment_of
      @it[:judgment_person] ||= @it.judgment_person_id
      @it[:judgment_person_id] ||= @it.judgment_person_id
      @it[:judgment_date] ||= @it.judgment_date
      @it[:judgment_result] ||= @it.judgment_result
      @it[:judgment_comment] ||= @it.judgment_comment
      @it[:judgment_person] ||= CacheEachRequest.current[:user].person_id
      @it[:judgment_date] ||= Time.now.strftime("%Y/%m/%d")
      @judgment_info = PjcSegmentChecklistJudgment.find(:all, :conditions=>{:segment_checklist_task_id=>@for_it.id}, :order=>"judgment_of desc")
      @judgment_last = PjcSegmentChecklistJudgment.find(:first, :conditions=>{:segment_checklist_task_id=>@for_it.id}, :order=>"judgment_of desc")
      @per_for_data_info = PjcSegmentChecklistJudgment.find(:first, :conditions=>{:segment_checklist_task_id=>@for_it.id}, :order=>"judgment_of desc")
    end
    
    @details = []
    @old_details = []
#    if params[:project]
#      @selected_project = params[:project].to_i
#    end
#    @selected_project ||= 0
#
#    if params[:segment]
#      @selected_segment = params[:segment].to_i
#    end
#    @selected_segment ||= 0
#    
#    if params[:checklist]
#      @selected_checklist = params[:checklist].to_i
#    end
#    @selected_checklist ||= 0
#    
#    @projects = Array.new
#    @projects << PjcProject.new(:id=>"0", :name=>s_("PjcSegmentChecklist|select project"))
#    @projects += PjcProject.find(:all, :conditions=>{}, :order=>"code")
#    
#    @segments = Array.new
#    @segments << PjcProjectSegment.new(:id=>"0", :name=>s_("PjcSegmentChecklist|select segment"))
#    @segments += PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code")
#
#    @checklists = Array.new
#    @checklists << PjcChecklist.new(:id=>"0", :name=>s_("PjcSegmentChecklist|select checklist"))
#    @checklists += PjcChecklist.find(:all, :conditions=>{}, :order=>"code")
    
    return if use_picker

    if params[:it] && @list_type != "TASK_LIST"
        set_attributes
      if request.post? && params[:judgment_add]
        @it.judgment_person_id = params[:it][:judgment_person]
        @it.segment_checklist_task_id = @for_it.id
        @it.judgment_date = params[:it][:judgment_date].delete("/")
        @it.judgment_result = params[:it][:judgment_result]
        @it.judgment_comment = params[:it][:judgment_comment]
        @it.judgment_of = PjcSegmentChecklistJudgment.find(:first, :conditions=>{:segment_checklist_task_id=>@for_it.id}, :order=>"judgment_of desc") ? PjcSegmentChecklistJudgment.find(:first, :conditions=>{:segment_checklist_task_id=>@for_it.id}, :order=>"judgment_of desc").judgment_of + 1 : 1
        if with_logic(@it, :create)
          yield
          return
        end
        return render(:action => template)
      elsif @list_type != "JUDGMENT_LIST"
        if request.post? && params[:create]
#          @it.project_id = @selected_project
#          @it.segment_id = @selected_segment
#          @it.checklist_id = @selected_checklist
#          @it.code = params[:it][:code]
#          @it.name = params[:it][:name]
#          @it.explanation = params[:it][:explanation]
          per_checklist_tasks = PjcChecklistTask.find(:all, :conditions=>{:checklist_id=>@it.checklist_id}, :order=>"position")
          if with_logic(@it, :create)
            if per_checklist_tasks && per_checklist_tasks != nil
              new_tasks = Array.new
              per_checklist_tasks.each do |c_t|
               p_id = ""
               if c_t.parent_checklist_task_id != nil && c_t.parent_checklist_task_id != ""
                 p = per_checklist_tasks.index(PjcChecklistTask.find(c_t.parent_checklist_task_id))
                 p_id = new_tasks[p].id
               end
               new_tasks << PjcSegmentChecklistTask.create!({
                            :segment_checklist_id => @it.id,
                            :parent_id            => p_id,
                            :code                 => c_t.code,
                            :name                 => c_t.name,
                            :explanation          => c_t.explanation,
                            :judgment             => c_t.judgment,
                            :position             => c_t.position,
                            :task_level           => c_t.task_level,
                            :lock_version         => 0
                            })
              end
            end
            yield
            return
          end
        end
        return render(:action => template)
      end
    end

    # start creating a brand new it
    if @display.attachment?
      # clean up uploaded_attachments
      session[:uploaded_attachments] ||= []
      session[:uploaded_attachments].delete_if do |attachment|
        @it.is_a?(attachment.attachable_type.constantize) && !attachment.attachable_id && attachment.destroy
      end
    end
    if @display.document?
      # clean up added documents
      session[:added_documents] ||= []
      session[:added_documents].delete_if do |document|
        @it.is_a?(document.relatable_type.constantize) && !document.relatable_id
      end
    end
    if @copying
      begin
        item = @model_class.find(params[:id])
        @selected_project = item.project_id
        @selected_segment = item.segment_id
        @selected_checklist = item.checklist_id

        @segments = Array.new
        @segments << PjcProjectSegment.new(:id=>"0", :name=>s_("PjcSegmentChecklist|select segment"))
        @segments += PjcProjectSegment.find(:all, :conditions=>{:project_id=> @selected_project}, :order=>"code")

      rescue ActiveRecord::RecordNotFound
        flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
        x_close_or_redirect_to :action => "list"
        return
      end
      @items.each do |i|
        next unless i.readable?
        key = i.column_name
        next if key == "id" # id must not copy
        case i
        when ItemProper, ItemPlural, ItemPolymorphic
          @it.__send__("#{key}=", item.__send__(key))
        end
      end
      if @product.is_a?(ProductDetailed)
        @new_details = []
        item.details.each_with_index do |d, k|
          copied_detail = @product.detail_class.new
          @detail_items.each do |i|
            next unless i.readable?
            key = i.column_name
            next if key == "id" # id must not copy
            case i
            when ItemProper, ItemPlural, ItemPolymorphic
              copied_detail.__send__("#{key}=", d.__send__(key))
            end
          end
          instance_variable_set("@new_details_#{k + 1}", copied_detail)
          @new_details.push(k + 1)
        end
      end
    else
      @new_details = []
      @items.each do |i|
        i.initialize_column_of(@it)
        if i.input_type == 'picker'
          if /\A(matter|project|project_segment)/ =~ i.input_parameter
            @it[i.column_name] = initialize_id_with_narrowing(i)
          end
        end
      end
    end
    render :action => template
  end

  def setup_per_page(model_class, options, &block)
    @allowed_per_page_options = ALLOWED_PER_PAGE.map do |n|
      if n == 0
        [s_("rfw|select|option|ALL"), n]
      else
        [(ns_("rfw|select|option|per %{n} page", "per %{n} pages", n) % {:n => n}), n]
      end
    end

    default_per_page = User.list_default_per_page
    yield(default_per_page) if block_given?
    per_page = params[:per].to_i
    if per_page == 0
      options[:per_page] = checklist_count_collection_for_pagination(model_class, options,@display.code)
    elsif ALLOWED_PER_PAGE.include?(per_page)
      options[:per_page] = per_page
    else
      options[:per_page] = per_page = default_per_page
    end
    options[:per_page] = 1 if options[:per_page] <= 0
  end

  def setup_list_id
    params[:list] ||= fetch_fragment("m", :list, nil)
    update_fragment("m", :list, @default_list && @default_list.display_id)
  end

  def default_url_options(options)
    h = super || {}
    # testのときにはparamsがnilになっているため。
    if params
      h.merge({
          :product_id => params[:product_id],
        })
    end
    return h
  end

  def set_attributes
    @items = @items[0,5] if @list_type == "LIST"
    @items = @items[3,5] if @list_type == "LIST" && params[:update]
    @items = @items - @items[0,5] if @list_type == "JUDGMENT_LIST"
    @items.each do|i|
      if (@list_type == "LIST" && i.layout < 10)
        i.set_attributes(@it, params[:it])
      elsif (@list_type == "JUDGMENT_LIST" && i.layout > 10)
        i.model_name = "PjcSegmentChecklistJudgment"
        i.set_attributes(@it, params[:it])
      end
    end
    @it.lock_version = params[:it][:lock_version]
    add_singleton_validations(@it, @items)
    if @product.is_a?(ProductDetailed)
      @details.each do |d|
        unless @old_details.include?(d.id)
          detail = instance_variable_get("@details_#{d.id}")
          @detail_items.each {|i| i.set_attributes(detail, params["details_#{d.id}".to_sym])}
          add_singleton_validations(detail, @detail_items)
        end
      end
      @new_details.each do |n|
        if detail = instance_variable_get("@new_details_#{n}")
          @detail_items.each {|i| i.set_attributes(detail, params["new_details_#{n}".to_sym])}
          add_singleton_validations(detail, @detail_items)
        end
      end
    end
  end

  def add_singleton_validations(x, items, action = :save)
    x.extend ::CustomValidations::SingletonValidateable
    items.each {|i| i.apply_validations(x, action) } unless items.blank?
  end

  def valid?(it)
    v = it.valid?
    if @product.is_a?(ProductDetailed)
      @details.each do |d|
        unless @old_details.include?(d.id)
          detail = instance_variable_get("@details_#{d.id}")
          v &= detail.valid?
        end
      end
      @new_details.each do |n|
        detail = instance_variable_get("@new_details_#{n}")
        v &= detail.valid?
      end
    end
    return v
  end

  def valid_on_destroy?(it)
    v = it.valid_on_destroy?
    if @product.is_a?(ProductDetailed)
      @details.each do |d|
        detail = instance_variable_get("@details_#{d.id}")
        v &= detail.valid_on_destroy?
      end
    end
    return v
  end

  def with_before_and_after(detail, *options)
    action = options.first
    message = (action == :destroy) ? :destroy : :save
    if message == :destroy
      add_singleton_validations(detail, @detail_items, :destroy)
    end
    unless detail = @display.inject_logic(:before, detail, action)
      raise BusinessLogic::Failure, "beforeprocess returns #{detail}, so reverted"
    end
    unless detail.valid_on_destroy?
      raise BusinessLogic::Failure, "validation on destroy was failed"
    end
    unless detail.__send__(message)
      raise "#{detail} could not process, so reverted"
    end
    unless after = @display.inject_logic(:after, detail, action)
      raise BusinessLogic::Failure, "afterprocess returns #{after}, so reverted"
    end
  end

  def with_logic(it, *options)
    action = options.first
    message = (action == :destroy) ? :destroy : :save
    newbie = it.new_record?
    if message == :save
      return false unless valid?(it)
    end
    # validate before executing
    if message == :destroy
      add_singleton_validations(it, @items, :destroy)
      return false unless valid_on_destroy?(it)
    end
    # execute
    it.class.transaction do
      unless it = @display.inject_logic(:pre, it, action)
        raise BusinessLogic::Failure, "preprocess returns #{it}, so reverted"
      end
      unless it.__send__(message)
        raise "#{it} could not process, so reverted"
      end
      if @product.is_a?(ProductDetailed)
        unless mid = @display.inject_logic(:mid, it, action)
          raise BusinessLogic::Failure, "midprocess returns #{mid}, so reverted"
        end
        if message == :save
          details = []
          @details.each do |d|
            detail = instance_variable_get("@details_#{d.id}")
            if @old_details.include?(d.id)
              with_before_and_after(detail, :destroy)
            else
              with_before_and_after(detail, *options)
              if k = params[:order_details].index("details_#{d.id}")
                details[k] = detail
              end
            end
          end
          @new_details.each do |n|
            detail = instance_variable_get("@new_details_#{n}")
            detail.header = it
            with_before_and_after(detail, *options)
            if k = params[:order_details].index("new_details_#{n}")
              details[k] = detail
            end
          end
          # order details
          details.each_with_index {|detail,k| detail.insert_at(k + 1) if detail}
        else
          @details.each do |d|
            detail = instance_variable_get("@details_#{d.id}")
            with_before_and_after(detail, *options)
          end
        end
      end
      if message == :save
        commit_attachments(it, newbie) if @display.attachment?
        commit_documents(it, newbie) if @display.document?
        mail_to_queue(it) if @display.mail?
      end
      unless post = @display.inject_logic(:post, it, action)
        raise BusinessLogic::Failure, "postprocess returns #{post}, so reverted"
      end
      # call workflow web service
      if @display.workflow_enabled? && !params[:workflow].blank?
        case message
        when :save
          wf_action_name = params[:workflow][:action]
          if wf_action_name && WorkflowStruct::Configuration::POSSIBLE_RESPONSES.include?(wf_action_name)
            @wf_response = __send__("wf_#{wf_action_name}".to_sym)
            raise WorkflowError if @wf_response.failure?
          end
        when :destroy
          @wf_response = User.current.admin? ? wf_delete : wf_destroy
          raise WorkflowError if @wf_response.failure?
        end
      end
    end
    return true
  end
  
#   return true when rendered
  def use_picker
    session[:picker] ||= {}
    picker_session = session[:picker]
    if picker_session[:it_before_picker] &&
#        picker_session[:workflow_before_picker] &&
        picker_session[:return_to] &&
        picker_session[:return_to][:controller] == params[:controller] &&
#        picker_session[:return_to][:product_id] == params[:product_id] &&
        picker_session[:return_to][:action] == params[:action] &&
        picker_session[:return_to][:id] == params[:id]
      params[:workflow] = picker_session[:workflow_before_picker]
      # TODO : 他のも戻す
#      unless @it.readonly?
        params[:it] = picker_session[:it_before_picker]
#        if @list_type == "JUDGMENT_LIST" && params[:it]
#          case @form_type
#          when "judgment_add"
#            @it[:judgment_person] = params[:it][:judgment_person]
#            @it[:judgment_person_id] = params[:it][:judgment_person]
#            @it[:judgment_result] = params[:it][:judgment_result]
#            @it[:judgment_date] = params[:it][:judgment_date]
#            @it[:judgment_explanation] = params[:it][:judgment_explanation]
#          when "judgment_edit"
#            @it[:judgment_person] = params[:it][:judgment_person]
#            @it[:segment_checklist_task_id] = @for_it.id
#            @it[:judgment_date] = params[:it][:judgment_date]
#            @it[:judgment_result] = params[:it][:judgment_result]
#            @it[:judgment_explanation] = params[:it][:judgment_explanation]
#            @it[:confirm_person] = params[:it][:confirm_person]
#            @it[:confirm_date] = params[:it][:confirm_date]
#            @it[:confirm_comment] = params[:it][:confirm_comment]
##          end
#        end
#        @items.each {|i| i.set_attributes(@it, params[:it])}
        @it.lock_version = params[:it][:lock_version]
#      end
      params[:mail] = picker_session[:mail_before_picker]

      if @product.is_a?(ProductDetailed)
        %w|new_details old_details order_details|.each do |k|
          params[k.to_sym] = picker_session["#{k}_before_picker".to_sym]
        end
        picker_session.each do |k,v|
          if /\A((?:new_)?details_\d+)_before_picker\z/ =~ k.to_s
            params[$1.to_sym] = v
          end
        end
      end
      session[:picker] = nil
      if flash[:pick]
        if flash[:pick][:mail]
          params[:mail] = flash[:pick][:mail]
        end
      end
    elsif params[:picker]
      picker, = params[:picker].keys
      field, item_id = get_picker_fields(picker)
      if field
        if "calendar" == field
          item = Item.find(item_id)
          if /\A(\d{4})\D?(\d{1,2})/ =~ params[:it][item.column_name]
            flash[:year], flash[:month] = $1, $2
          end
        end
        picker_session[:return_to] = {
          :controller => params[:controller],
          :product_id => params[:product_id],
          :action     => params[:action],
          :id         => params[:id],
          :tab_id     => params[:tab_id],
        }
        picker_session[:it_before_picker] = params[:it] || {}
        picker_session[:workflow_before_picker] = params[:workflow] || {}
        # TODO: picker で取得したデータを保存する
        picker_session[:mail_before_picker] = params[:mail]
        if @product.is_a?(ProductDetailed)
          %w|new_details old_details order_details|.each do |k|
            picker_session["#{k}_before_picker".to_sym] = params[k.to_sym]
          end
          params.each do |k,v|
            if /\A(?:new_)?details_\d+\z/ =~ k.to_s
              picker_session["#{k}_before_picker".to_sym] = v
            end
          end
        end
        x_redirect_to @sub_view, picker, {
          :controller   => "picker",
          :action       => field,
          :return_field => field,
        }
        return true
      end
    end
    return false
  end
  
#    def use_picker
#    session[:picker] ||= {}
#    picker_session = session[:picker]
#    if picker_session[:it_before_picker] &&
#        picker_session[:workflow_before_picker] &&
#        picker_session[:return_to] &&
#        picker_session[:return_to][:controller] == params[:controller] &&
#        picker_session[:return_to][:product_id] == params[:product_id] &&
#        picker_session[:return_to][:action] == params[:action] &&
#        picker_session[:return_to][:id] == params[:id]
#      params[:workflow] = picker_session[:workflow_before_picker]
#      # TODO : 他のも戻す
#      unless @it.readonly?
#        params[:it] = picker_session[:it_before_picker]
#        @items.each {|i| i.set_attributes(@it, params[:it])}
#        @it.lock_version = params[:it][:lock_version]
#      end
#      params[:mail] = picker_session[:mail_before_picker]
#      if @product.is_a?(ProductDetailed)
#        %w|new_details old_details order_details|.each do |k|
#          params[k.to_sym] = picker_session["#{k}_before_picker".to_sym]
#        end
#        picker_session.each do |k,v|
#          if /\A((?:new_)?details_\d+)_before_picker\z/ =~ k.to_s
#            params[$1.to_sym] = v
#          end
#        end
#      end
#      session[:picker] = nil
#      if flash[:pick]
#        if flash[:pick][:mail]
#          params[:mail] = flash[:pick][:mail]
#        end
#      end
#    elsif params[:picker]
#      picker, = params[:picker].keys
#      field, item_id = get_picker_fields(picker)
#      if field
#        if "calendar" == field
#          item = Item.find(item_id)
#          if /\A(\d{4})\D?(\d{1,2})/ =~ params[:it][item.column_name]
#            flash[:year], flash[:month] = $1, $2
#          end
#        end
#        picker_session[:return_to] = {
#          :controller => params[:controller],
#          :product_id => params[:product_id],
#          :action     => params[:action],
#          :id         => params[:id],
#          :tab_id     => params[:tab_id],
#        }
#        picker_session[:it_before_picker] = params[:it] || {}
#        picker_session[:workflow_before_picker] = params[:workflow] || {}
#        # TODO: picker で取得したデータを保存する
#        picker_session[:mail_before_picker] = params[:mail]
#        if @product.is_a?(ProductDetailed)
#          %w|new_details old_details order_details|.each do |k|
#            picker_session["#{k}_before_picker".to_sym] = params[k.to_sym]
#          end
#          params.each do |k,v|
#            if /\A(?:new_)?details_\d+\z/ =~ k.to_s
#              picker_session["#{k}_before_picker".to_sym] = v
#            end
#          end
#        end
#        x_redirect_to @sub_view, picker, {
#          :controller   => "picker",
#          :action       => field,
#          :return_field => field,
#        }
#        return true
#      end
#    end
#    return false
#  end
  
  def get_picker_fields(key)
    # modify: add param(destination|bizcardcompany|bizcardbranch|bizcardperso) 2009/2/27 h.nakamura
    if /\A(?:mail|(company|organization|person|post|group|calendar|lump|destination|bizcardcompany|bizcardorganization|bizcardbranch|bizcardperson)(\d+)(?:_(?:new_)?details_\d+)?)\z/ =~ key
      return $1 || 'mail', $2
    elsif (/\Aworkflow/ === key)
      return 'person', nil
    else
      nil
    end
  end

  def commit_attachments(x, newbie)
    if session[:deleted_attachments].is_a?(Array)
      session[:deleted_attachments].delete_if do |attachment|
        attachment.attachable == x && attachment.destroy
      end
    end
    if session[:uploaded_attachments].is_a?(Array)
      if newbie
        session[:uploaded_attachments].delete_if do |a|
          if x.is_a?(a.attachable_type.constantize) && !a.attachable_id
            a.attachable_id = x.id
            a.save
          else
            false
          end
        end
      else
        session[:uploaded_attachments].delete_if {|a| x == a.attachable && a.save}
      end
    end
  end

  def commit_documents(x, newbie)
    if !newbie && session[:deleted_documents].is_a?(Array)
      session[:deleted_documents].delete_if(&:destroy)
    end
    if session[:added_documents].is_a?(Array)
      if newbie
        session[:added_documents].delete_if do |d|
          if x.is_a?(d.relatable_type.constantize) && !d.relatable_id
            d.relatable_id = x.id
            d.save
          else
            false
          end
        end
      else
        session[:added_documents].delete_if {|d| x == d.relatable && d.save}
      end
    end
  end

  def mail_to_queue(it, flash_now=false)
    mail = params[:mail]
    if mail && !mail[:recipients].blank?
      fragment = FragmentHash.new(params[:fragment])
      menu_id = fragment.motion("m").to_i
      mail_queue = MailQueue.create!({
          :menu_id => menu_id,
          :product_id => @product.id,
          :document => it,
          :from => User.current.person,
          :recipient_ids => mail[:recipients],
          :comment_message => mail[:comment],
          :field_type => mail[:field_type],
          :has_attachment => mail[:attachment],
          :mail_mode => "auto login",
          :copy_to_sender => false,
          :processed => false,
          :auto_login_url => url_for({
              :controller => "user",
              :action => "auto",
              # :t => "/", # "/" is default
              :f => fragment_for(:menu => Menu.find(menu_id), :document => it),
            }),
        })
      url = url_for(:only_path => true, :controller => "mail_sender", :action => "post", :id => mail_queue.id)
#       MiddleMan.new_worker(:class => :mail_sender_worker, :args => {:post => [mail_queue.id, url]})
      ap4r.async_to({
          :controller => "mail_sender",
          :action => "post",
        }, {
          :id => mail_queue.id,
        })
      if flash_now
        flash.now[:message] = s_("rfw|flash|message|Mail queued for delivery.")
      else
        flash[:message] = s_("rfw|flash|message|Mail queued for delivery.")
      end
    end
  end

  # workflow:起票 (申請)
  def wf_issue
    client = WorkflowClient.client('action')
    assignment = wf_get_assignments(params[:workflow][:option][:assignment])
    candidates = wf_get_assignments(params[:workflow][:option][:candidates])
    issue_option = params[:workflow][:option].dup
    issue_option[:assignment] = assignment.first
    issue_option[:candidates] = candidates
    response = client.issue(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                            WorkflowStruct::Department.new(:id => params[:workflow][:department_id]),
                            WorkflowStruct::Message.new(:body => wf_message_body),
                            WorkflowStruct::Route.new(:workflow => @product.workflow, :workflow_aux => params[:workflow][:workflow_aux]),
                            WorkflowStruct::IssueOption.new(issue_option))
  end

  # workflow:承認
  def wf_accept
    client = WorkflowClient.client('action')
    assignment = wf_get_assignments(params[:workflow][:option][:assignment])
    accept_option = params[:workflow][:option].dup
    accept_option[:assignment] = assignment.first
    accept_option[:condition_parameters] = wf_get_condition_parameters
    response = client.accept(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                             WorkflowStruct::Issue.new(:id => params[:workflow][:issue_id]),
                             WorkflowStruct::AcceptOption.new(accept_option))
  end

  # workflow:差戻し
  def wf_reject
    client = WorkflowClient.client('action')
    response = client.reject(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                             WorkflowStruct::Issue.new(:id => params[:workflow][:issue_id]))
  end

  # workflow:取消
  def wf_cancel
    client = WorkflowClient.client('action')
    response = client.cancel(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                             WorkflowStruct::Issue.new(:id => params[:workflow][:issue_id]))
  end

  # workflow:棄却
  def wf_withdraw
    client = WorkflowClient.client('action')
    response = client.withdraw(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                               WorkflowStruct::Issue.new(:id => params[:workflow][:issue_id]))
  end

  # workflow:削除
  def wf_destroy
    client = WorkflowClient.client('action')
    response = client.destroy(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                              WorkflowStruct::Issue.new(:id => params[:workflow][:issue_id]))
  end

  # workflow:管理者による削除
  def wf_delete
    client = WorkflowClient.client('action')
    response = client.delete(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                             WorkflowStruct::Message.new(:body => wf_message_body))
  end

  # params[:workflow][:option] から必要なデータを取り出して加工する
  def wf_get_assignments(assignments)
    return [] if assignments.blank?
    assignments.map{|k, v|
      WorkflowStruct::Assignment.new(:id => k.to_i,
                                     :authorizers => v.values.reject{|id| id.blank? }.map{|person_id|
                                       WorkflowStruct::Account.new(:person_id => person_id.to_i)
                                     })
    }
  end

  def wf_get_condition_parameters
    return nil if @wf_config.condition_parameters.blank?
    @wf_config.condition_parameters.map{|c|
      v = ItemMethodChain.resole_method_chain(@it, c.key)
      to_x = case v
             when String  then 'to_s'
             when Integer then 'to_i'
             when Float   then 'to_f'
             else              'to_s'
             end
      WorkflowStruct::ConditionParameter.new(:key   => c.key,
                                             :value => v,
                                             :to_x  => to_x)
    }
  end

  def wf_message_body
    # __send__ できるメソッドを制限する
    unless @it.class.column_names.include?(@product.workflow_body_method)
      raise ClientError, "Invalid workflow_body_method: #{@product.workflow_body_method}"
    end
    @it.__send__(@product.workflow_body_method)
  end
  
  def inside_task_id(it)
    inside_task_id = Array.new
    it = PjcSegmentChecklistTask.find_by_id(it)
    PjcSegmentChecklistTask.find(:all, :conditions=>" segment_checklist_id = #{it.segment_checklist_id} and position > #{it.position} ", :order=>"position").each do |task|
      if task.task_level > it.task_level
        inside_task_id << task.id.to_s
      else
        return inside_task_id
      end
    end
    return inside_task_id
  end
  
  def make_task_paste_date(wait_for_update,child_tasks,do_ids,index,new_parent)  
    paste_dates = Array.new
    a = PjcSegmentChecklistTask.find(:all,:conditions=>"id in (#{do_ids.join(',')})", :order=>"position")
    PjcSegmentChecklistTask.find(:all,:conditions=>"id in (#{do_ids.join(',')})", :order=>"position").each do|do_task|
      paste_date = Hash.new
      paste_date[:code] = do_task.code
      paste_date[:name] = do_task.name
      paste_date[:judgment] = do_task.judgment
      paste_date[:explanation] = do_task.explanation
      paste_date[:task_level] = do_task.task_level
      paste_date[:parent_id] = do_task.parent_id
      paste_dates << paste_date
    end

    if index == "last"
      if session[:segment_checklist_do_mark] == "root"
        wait_for_update += paste_dates 
      else
        if child_tasks && child_tasks != []
          for_in = inside_task_id(new_parent.id)
          last = PjcSegmentChecklistTask.find(:first, :conditions=>" id in (#{for_in.join(',')})", :order=>"position desc")
          for_no = wait_for_update.index(last) + 1
        else
          for_no = wait_for_update.index(new_parent) + 1
        end
        o = wait_for_update[0,for_no]
        p = wait_for_update - o
        wait_for_update = o + paste_dates + p
      end
    else
      a = child_tasks[0, index.to_i]
      b = child_tasks - a
      m = b[0]
      n = wait_for_update.index(m)
      x = wait_for_update[0, n.to_i]
      y = wait_for_update - x
      x += paste_dates
      x += y
      wait_for_update = x
    end
    return wait_for_update
  end

  def initialize_id_with_narrowing(item)
    return nil unless item.is_a?(ItemProper)
    id = item.default_id_with_narrowing(session)
    return id if id
    return nil if item.input_initializer.blank?
    case item.input_initializer.strip
    when /\Anarrowing\((\d+)\)\z/
      narrowing = NarrowingById.find($1.to_i)
      key = narrowing.value_keys.first
      return session[key]
    end
  rescue ActiveRecord::RecordNotFound
    # fall through
  ensure
    nil
  end  
  
end
