# -*- coding: utf-8 -*-
# プロダクトの制御を行う:
# - 一覧画面
# - 詳細画面
# - 新規作成画面
# - 編集画面
# - 削除画面
class PjcAttachmentListController < ApplicationController
  include PaginationConfiguration
  include RandomId

  # <tt>list</tt> へリダイレクトする。
  def index
    redirect_to :action => :list
  end

  # 一覧画面を表示する。
  def list
    if params[:product_id]
       @menu_select_product_id = params[:product_id]
       session[:menu_select_product_id] = params[:product_id]
    else
       @menu_select_product_id = session[:menu_select_product_id]
    end
    @check_date =nil
    if params[:search_for_list]
       if (params[:it][:headline_start_day] && params[:it][:headline_start_day] !="") &&
          (params[:it][:headline_end_day] && params[:it][:headline_end_day] !="") && 
          (params[:it][:headline_start_day].gsub("/","").to_i >params[:it][:headline_end_day].gsub("/","").to_i)
          @selected_product_id =params[:selected_product_id]
          @inputed_code =params[:inputed_code]
          @inputed_project_name =params[:inputed_project_name]
          @inputed_title_name =params[:inputed_title_name]
          @inputed_file_name =params[:inputed_file_name]
          @inputed_description =params[:inputed_description] 
          @inputed_created_by_name =params[:inputed_created_by] 
          @headline_start_day =params[:it][:headline_start_day]
          @headline_end_day =params[:it][:headline_end_day]
          @check_date =false 
       else
          @check_date =true
       end
    end
    
    if params[:search_for_list] && @check_date==true
        @selected_selected_product_id =@selected_product_id =params[:selected_product_id]
        session[:selected_product_id] = params[:selected_product_id]
        @selected_code =@inputed_code =params[:inputed_code]
        session[:inputed_code] = params[:inputed_code]
        @selected_project_name = @inputed_project_name =params[:inputed_project_name]
        session[:inputed_project_name] = params[:inputed_project_name]
        @selected_title_name =@inputed_title_name =params[:inputed_title_name]
        session[:inputed_title_name] = params[:inputed_title_name]        
        @selected_file_name =@inputed_file_name =params[:inputed_file_name]
        session[:inputed_file_name] = params[:inputed_file_name]
        @selected_description =@inputed_description =params[:inputed_description] 
        session[:inputed_description] = params[:inputed_description]
        @selected_created_by_name =@inputed_created_by_name =params[:inputed_created_by] 
        session[:inputed_created_by] = params[:inputed_created_by]
        @selected_headline_start_day =@headline_start_day =params[:it][:headline_start_day]
        session[:headline_start_day] = params[:it][:headline_start_day]
        @selected_headline_end_day =@headline_end_day =params[:it][:headline_end_day]
        session[:headline_end_day] = params[:it][:headline_end_day]
    elsif @check_date !=false 
        @selected_selected_product_id =@selected_product_id =session[:selected_product_id]
        @selected_code =@inputed_code =session[:inputed_code]
        @selected_project_name =@inputed_project_name =session[:inputed_project_name]
        @selected_title_name =@inputed_title_name =session[:inputed_title_name]
        @selected_file_name =@inputed_file_name =session[:inputed_file_name]
        @selected_description =@inputed_description =session[:inputed_description]
        @selected_created_by_name =@inputed_created_by_name =session[:inputed_created_by]
        @selected_headline_start_day =@headline_start_day =session[:headline_start_day]
        @selected_headline_end_day =@headline_end_day =session[:headline_end_day]
    else
        @selected_selected_product_id =session[:selected_product_id]
        @selected_code =session[:inputed_code]
        @selected_project_name =session[:inputed_project_name]
        @selected_title_name =session[:inputed_title_name]
        @selected_file_name =session[:inputed_file_name]
        @selected_description =session[:inputed_description]
        @selected_created_by_name =session[:inputed_created_by]
        @selected_headline_start_day =session[:headline_start_day]
        @selected_headline_end_day =session[:headline_end_day]      
    end 

    
    view_in :m
    prepare_display_to_list
    return if use_picker

    if @display.narrowing?
      if params[:narrowing]
        session[@display.narrowing_key]    = params[:narrowing]
        session[@display.narrowing_id_key] = params[:narrowing_id]
      end
      @display.narrow_to(session[@display.narrowing_id_key])
    end
    prepare_product_name_to_list
    options ={}
    # データの検索処理
    # 登録日範囲の選択
    if @selected_headline_start_day==nil || @selected_headline_start_day ==""
       headline_start_day ="00000000"             
    else
       headline_start_day= @headline_start_day    
    end
    if @selected_headline_end_day==nil || @selected_headline_end_day ==""
       headline_end_day ="20990000"
    else
       headline_end_day = @selected_headline_end_day     
    end
    attachments =[]
    attachment_count =0
    join_product_model_name =""
    if @selected_selected_product_id && @selected_selected_product_id !="(no_selected)" # 機能の選択処理
      begin
        products =[Product.find(@selected_selected_product_id)]
      rescue ActiveRecord::RecordNotFound
        raise NotFoundException, "product not found"
      end
    else
        products =Product.find(:all, :conditions =>["code !=? and attachment =?","ROOT",1]) 
    end
    if products !=[]
      products.each do |product|
        join_product_model_name ="and attachments.attachable_type ='#{product.model_name}'" unless product ==nil
        attachment_list =PjcAttachmentList.find(:first,:conditions =>["table_name =?",product.table_name]) unless product ==nil
        join_narrowing_column =""
        select_join_code ="''"
        select_project_name ="''"
        select_join_title_name ="''"
        select_join_file_name =""
        if attachment_list
          # ワークフローの部分
          case attachment_list.table_name
          # 名刺情報
          when "business_cards"
            join_table_name ="INNER JOIN business_cards ON attachments.attachable_id =business_cards.id
                              INNER JOIN business_card_companies ON business_card_companies.id =business_cards.company_id
                              and '' LIKE '%#{@selected_code}%'
                              and '' LIKE '%#{@selected_project_name}%'
                              and business_card_companies.name LIKE '%#{@selected_title_name}%'"
            select_join_code ="''"
            select_project_name ="''"
            select_join_title_name ="business_card_companies.name" 
          # 名刺企業情報  
          when "business_card_companies"
            join_table_name ="INNER JOIN business_card_companies ON attachments.attachable_id =business_card_companies.id
                              and ((business_card_companies.code or business_card_companies.official_company_name) LIKE '%#{@selected_title_name}%')
                              and '' LIKE '%#{@selected_project_name}%'
                              and business_card_companies.code LIKE '%#{@selected_code}%'"
            select_join_code ="business_card_companies.code"
            select_project_name ="''"
            select_join_title_name ="business_card_companies.name" 
          # 回覧板  
          when "circulars"     
            conditions =Circular.new.per_division
            circular =Circular.find(:all,:conditions =>conditions).map(&:id)
            if circular && circular !=[]
               join_table_name="INNER JOIN circulars ON attachments.attachable_id in (#{circular.join(",")})
                                and '' LIKE '%#{@selected_title_name}%'
                                and '' LIKE '%#{@selected_project_name}%'
                                and '' LIKE '%#{@selected_code}%'"
            else
               join_table_name="INNER JOIN circulars ON circulars.id =0"
            end
            select_join_code ="circulars.circular_number"
            select_project_name ="''"
            select_join_title_name ="circulars.subject" 
          # 掲示板   
          when "bulletin_boards"
            join_table_name ="INNER JOIN bulletin_boards ON attachments.attachable_id =bulletin_boards.id
                              INNER JOIN news ON news.bulletin_board_id =bulletin_boards.id
                              and news.publish_end_day >= #{Date.today.strftime("%Y%m%d")}
                              and '' LIKE '%#{@selected_code}%'
                              and news.subject LIKE '%#{@selected_title_name}%'
                              and bulletin_boards.name LIKE '%#{@selected_project_name}%'"
            select_join_code ="''"
            select_project_name ="bulletin_boards.name"
            select_join_title_name ="news.subject" 
          # ＰＪチェック
          # フレームワークタスク
          when "framework_tasks"
            join_table_name ="INNER JOIN framework_tasks ON attachments.attachable_id =framework_tasks.id
                              INNER JOIN frameworks ON frameworks.id =framework_tasks.framework_id
                              and '' LIKE '%#{@selected_code}%'
                              and framework_tasks.name LIKE '%#{@selected_title_name}%'
                              and frameworks.name LIKE '%#{@selected_project_name}%'"
            select_join_code ="''"
            select_project_name ="frameworks.name"
            select_join_title_name ="framework_tasks.name" 
          # チェックリストタスク
          when "checklist_tasks"
            join_table_name ="INNER JOIN checklist_tasks ON attachments.attachable_id =checklist_tasks.id
                              INNER JOIN checklists ON checklists.id =checklist_tasks.checklist_id
                              and '' LIKE '%#{@selected_code}%'
                              and checklist_tasks.name LIKE '%#{@selected_title_name}%'
                              and checklists.name LIKE '%#{@selected_project_name}%'"
            select_join_code ="''"
            select_project_name ="checklists.name"
            select_join_title_name ="checklist_tasks.name"
          # 設備
          when "equipments"
            join_table_name ="INNER JOIN equipments ON attachments.attachable_id =equipments.id
                              and equipments.name LIKE '%#{@selected_project_name}%'
                              and equipments.code LIKE '%#{@selected_code}%'
                              and '' LIKE '%#{@selected_title_name}%'"
            select_join_code ="equipments.code"
            select_project_name ="equipments.name"
            select_join_title_name ="''"
          # 作業報告 
          when "work_reports" 
            join_table_name ="INNER JOIN work_reports ON attachments.attachable_id =work_reports.id
                              and people.id = work_reports.created_by
                              and work_reports.subject LIKE '%#{@selected_title_name}%'
                              and people.name LIKE '%#{@selected_project_name}%'
                              and work_reports.work_report_number LIKE '%#{@selected_code}%'"
            select_join_code ="work_reports.work_report_number"
            select_project_name ="people.name"
            select_join_title_name ="work_reports.subject"
          else 
          # 検索の共通部分            
              if attachment_list.table_name && attachment_list.table_name !=""                              # 機能名
                 table_name = attachment_list.table_name
                 join_table_name ="INNER JOIN #{table_name} ON attachments.attachable_id =#{table_name}.id"
                 if attachment_list.document_number_column && attachment_list.document_number_column !=""   # 管理番号
                    code =attachment_list.document_number_column
                    join_table_name +=" and #{table_name}.#{code} LIKE '%#{@selected_code}%'"
                    select_join_code ="#{table_name}.#{code}"
                 else
                    join_table_name +=" and '' LIKE '%#{@selected_code}%'"
                 end
                 if attachment_list.subject_column && attachment_list.subject_column !=""                   # 件名・タイトル
                    name =attachment_list.subject_column
                    join_table_name +=" and #{table_name}.#{name} LIKE '%#{@selected_title_name}%'"
                    select_join_title_name ="#{table_name}.#{name}"
                 else
                    join_table_name +=" and '' LIKE '%#{@selected_title_name}%'"
                 end
              else
                 join_table_name +=""
              end 

              if attachment_list.narrowing_column && attachment_list.narrowing_column !=""                  # 案件・プロジェクト-業務
                  project_name =attachment_list.narrowing_column
                  case project_name
                    when "project_segments"                                                                 # プロジェクト-業務
                        if table_name =="projects"
                          project_ids =permissible_table_ids("#{product.model_name}","#{product.table_name}")
                          unless project_ids ==""
                            join_narrowing_column ="and (#{project_ids}) and projects.name LIKE '%#{@selected_project_name}%'"
                          else
                            join_narrowing_column ="and projects.name LIKE '%#{@selected_project_name}%'"
                          end
                          select_project_name ="projects.name"
                        elsif table_name =="project_segments"
                          project_segment_ids =permissible_table_ids("#{product.model_name}","#{product.table_name}")
                          unless project_segment_ids ==""
                            join_narrowing_column ="and (#{project_segment_ids}) and project_segments.name LIKE '%#{@selected_project_name}%'"
                          else
                            join_narrowing_column ="and project_segments.name LIKE '%#{@selected_project_name}%'"
                          end
                          select_project_name ="project_segments.name"
                        else
                          project_segment_ids =permissible_table_ids("#{product.model_name}","#{product.table_name}")
                          unless project_segment_ids ==""
                              join_narrowing_column ="INNER JOIN projects ON projects.id = #{table_name}.project_id
                                                      and projects.domain_id =#{User.current.domain_id}
                                                      INNER JOIN project_segments ON project_segments.id = #{table_name}.segment_id
                                                      and (#{project_segment_ids})
                                                      and (projects.name LIKE '%#{@selected_project_name}%'
                                                      or projects.code LIKE '%#{@selected_project_name}%'
                                                      or project_segments.name LIKE '%#{@selected_project_name}%')"
                          else
                              join_narrowing_column ="INNER JOIN projects ON projects.id = #{table_name}.project_id
                                                      and projects.domain_id =#{User.current.domain_id}
                                                      INNER JOIN project_segments ON project_segments.id = #{table_name}.segment_id
                                                      and (projects.name LIKE '%#{@selected_project_name}%'
                                                      or projects.code LIKE '%#{@selected_project_name}%'
                                                      or project_segments.name LIKE '%#{@selected_project_name}%')"
                          end
                          select_project_name ="projects.name or projects.code or project_segments.name"
                        end               
                    when "matters"                                                                          # 案件
                        if table_name =="matters"
                          join_narrowing_column ="and matters.name LIKE '%#{@selected_project_name}%'"
                        else
                          join_narrowing_column ="INNER JOIN matters ON matters.id = #{table_name}.matter_id
                                                  and matters.name LIKE '%#{@selected_project_name}%'"
                        end
                        select_project_name ="matters.name"                 
                  else
                    if "#{product.model_name}".constantize.new.respond_to?(project_name)
                      join_narrowing_column +=" and #{table_name}.#{project_name} LIKE '%#{@selected_project_name}%'"
                      select_project_name ="#{table_name}.#{project_name}"
                    else
                      join_narrowing_column +=" and '' LIKE '%#{@selected_project_name}%'"
                    end     
                  end
              else
                 join_narrowing_column +=" and '' LIKE '%#{@selected_project_name}%'"
              end
          end
          join_file_types =[]
          join_file_types << "INNER JOIN binary_objects ON attachments.file_type ='BinaryObject' 
                                    and binary_objects.id = attachments.file_id
                                    and binary_objects.name LIKE '%#{@selected_file_name}%'" 
          join_file_types << "INNER JOIN storage_objects ON attachments.file_type ='StorageObject' 
                                    and storage_objects.id = attachments.file_id
                                    and storage_objects.name LIKE '%#{@selected_file_name}%'"
          permissible_products =Product.permissible.map(&:id)
              join_file_types.each do |join_file_type|
                  options.update(:joins => "INNER JOIN products ON attachments.attachable_type = products.model_name 
                                    and products.attachment ='1'
                                    and products.id in (#{permissible_products.join(",")})
                                    and attachments.description LIKE '%#{@selected_description}%'
                                    and attachments.created_at >= #{(headline_start_day.gsub("/","")+"000000").to_i}
                                    and attachments.created_at <= #{(headline_end_day.gsub("/","")+"999999").to_i}
                                    INNER JOIN users ON users.id = attachments.created_by
                                    INNER JOIN people ON people.id = users.person_id
                                    and people.name LIKE '%#{@selected_created_by_name}%'
                                    #{join_product_model_name}
                                    #{join_table_name}
                                    #{join_narrowing_column}
                                    #{join_file_type}
                  ") 
                  if join_file_type == join_file_types[0]
                     select_join_file_name ="binary_objects.name as file_name,"
                  elsif join_file_type == join_file_types[1]
                     select_join_file_name ="storage_objects.name as file_name,"                
                  end
                  select = "attachments.* ,products.id as product_id,
                                           products.code as product_code,
                                           '' as product_name,
                                           #{select_join_code} as code,
                                           #{select_project_name} as project_name,
                                           #{select_join_title_name} as title_name,
                                           #{select_join_file_name}
                                           people.phonetic as created_by_name"
                  Attachment.find(:all,:select =>select, :conditions => options[:conditions],
                                           :order => options[:order_by] || options[:order],
                                           :joins => options[:join] || options[:joins],
                                           :limit => options[:per_page],
                                           :group => options[:group]).each do |attachment|
                      attachment.product_name = Product.find(attachment.product_id).name
                      attachments << attachment 
                  end
              end
        end
      end
    end 
    attachments =attachments.uniq
    attachment_count = attachments.length     
    # 並び順のクリア処理
    if params[:sort_clear]
       session[:attachment_order_by_asc] =nil
       session[:attachment_order_by_desc] =nil
    end 
    
    # 一覧並び順の変わる処理
    if params[:attachment_order_by_asc]
       session[:attachment_order_by_asc] = params[:attachment_order_by_asc]
       session[:attachment_order_by_desc] =nil 
       attachments=attachments.sort_by{|a|[a.__send__(params[:attachment_order_by_asc])]}
    elsif params[:attachment_order_by_desc]
       session[:attachment_order_by_desc] = params[:attachment_order_by_desc]
       session[:attachment_order_by_asc] =nil
       attachments=attachments.sort_by{|a|[a.__send__(params[:attachment_order_by_desc])]}.reverse
    elsif session[:attachment_order_by_asc]
       attachments=attachments.sort_by{|a|[a.__send__(session[:attachment_order_by_asc])]}
    elsif session[:attachment_order_by_desc]
       attachments=attachments.sort_by{|a|[a.__send__(session[:attachment_order_by_desc])]}
    else
       attachments=attachments.sort_by{|a|[a.product_code]}
    end

    setup_list_id
    setup_per_page("Attachment".constantize,options,attachment_count) do |default_per_page|
      sync_fragment("m", :per, default_per_page)
    end
    sync_fragment("m", :page, 1)
    @pages, @things = attachment_list_paginate("Attachment".constantize, attachments,attachment_count, options)
    @header_per_line = User.list_header_per_line

    # 再表示ボタンやperのonchangeのときにpageの変更と同じように
    # fragmentのpopup部分を削除する。
    if params["dummy_button"]
      delete_sub_view_fragment(@current_view.sub(/\Aview_/, ""))
    end
    
#    return if use_picker
  end
  
  # 添付ファイルをダウンロードする。
  def download
    begin
      attachment = Attachment.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      raise NotFoundException, "attachment not found: #{params[:id]}"
    end
    file = attachment.file
    return send_data(file.content, :type => file.mime_type, :filename => file.name) if file.is_a?(BinaryObject)
    return send_file(file.path, :type => file.mime_type, :filename => file.name) if file.is_a?(StorageObject)
    raise NotFoundException, "file not found"
  end

  private

  def view_in(key)
    case key
    when :m
      @parent_view = "view_main"
      @current_view = "view_m"
      @sub_view = "view_detail"
    when :detail
      @parent_view = "view_m"
      @current_view = "view_detail"
      @sub_view = "view_picker"
    when :document
      @parent_view = "view_de"
      @current_view = "view_dp"
      @sub_view = "view_dpp"
    end
    params[:id] ||= fetch_fragment(@current_view.sub(/\Aview_/, ""), "id", nil)
  end

  def permissible_table_ids(model_name,table_name)
    table_ids =model_name.constantize.find(:all).map(&:id)
    table_id =""
    if table_ids !=[]
      table_ids.each do |t|
       if table_id ==""
         table_id << "#{table_name}.id =#{t}"
       else
         table_id << " or #{table_name}.id =#{t}"
       end
      end
    end
    return table_id
  end

  def prepare_display_to_list
    display_type = :list
    display_class = "display_to_#{display_type}".classify
    begin
      @product = Product.find(@menu_select_product_id)
    rescue ActiveRecord::RecordNotFound
      raise NotFoundException, "product not found"
    end
    @display_list = @product.displays.select do |display|
      (display.is_a?(DisplayToListPrivate) && display.person_id == User.current.person_id) ||
        (display.class == DisplayToList && display.enabled?)
    end.sort_by do |display|
      display.position || 0
    end
    raise NotFoundException, "display not found" if @display_list.empty?
    list_id = params[:list] || fetch_fragment("m", :list, nil)
    if user_id = User.current_id
      if @default_list = DefaultList.find_by_product_id_and_user_id(@product.id, user_id)
        # use the default list unless specified
        list_id ||= @default_list.display_id
      end
    end
    if list_id
      params[:list] = list_id
      list_id = list_id.to_i
      @display = @display_list.find {|d| d.id == list_id }
    end
    @title = @product.name
    prepare_display_to(display_type, display_class)
  end

  def prepare_display_to_workflow
    return unless @display.workflow_enabled?
    client = WorkflowClient.client('probe')
    @wf_config = client.configuration(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                                      WorkflowStruct::Message.new(:body => wf_message_body),
                                      @product.workflow)
    wf_items = @wf_config.items
    @items.each do |item|
      if wf_items && (i = wf_items.detect{|v| v.id == item.id })
        item.validates_presence = i.validates_presence
      else
        item.instance_variable_set(:@writable, false)
      end
    end
    params[:workflow] ||= {}
    params[:workflow][:option] ||= {}
  rescue Errno::ECONNREFUSED => ex
    logger.error("ERROR: workflow server down")
    logger.error(ex)
    logger.error(ex.backtrace.join("\n"))
    raise ServiceUnavailable, "Workflow server down"
  end

  def prepare_display_to(display_type, display_class="display_to_#{display_type}".classify)
    @product ||= Product.find(params[:product_id])
    case display_type
    when :show, :list
      raise PermissionDenied, "product is invisible" unless @product.visible?
    when :edit, :new
      raise PermissionDenied, "product is not modifiable" unless @product.modifiable?
    else
      raise ArgumentError, "unknown display type: #{display_type}"
    end
    @display ||= @product.displays.find_by_type(display_class)
    raise NotFoundException, "display not found" unless @display
    raise DisabledException, "display disabled" unless @display.enabled?
    Display.current = @display
    @title ||= @display.name
    @title = "no title" if @title.blank?
    @model_class = @product.model_class
    @items = @display.items.find(:all, :conditions => ["layout > 0"], :order => "layout,id")
    @items = @items.select(&:selected?) if @display.is_a?(DisplayToListPrivate)
    if @product.is_a?(ProductDetailed)
      items = @items.select {|item| item.table_name == @product.table_name}
      @items, @detail_items = items, (@items - items)
    end
  end
  
  def use_picker
    session[:picker] ||= {}
    picker_session = session[:picker]
    if picker_session[:it_before_picker] &&
#        picker_session[:workflow_before_picker] &&
        picker_session[:return_to] &&
        picker_session[:return_to][:controller] == params[:controller] &&
#        picker_session[:return_to][:product_id] == params[:product_id] &&
        picker_session[:return_to][:action] == params[:action]
#        picker_session[:return_to][:id] == params[:id] 
      @selected_product_id =session[:picker][:selected_product_id]
      @inputed_code =session[:picker][:inputed_code]
      @inputed_project_name =session[:picker][:inputed_project_name]
      @inputed_title_name =session[:picker][:inputed_title_name]
      @inputed_file_name =session[:picker][:inputed_file_name]
      @inputed_description =session[:picker][:inputed_description]
      @inputed_created_by_name =session[:picker][:inputed_created_by]
      @headline_start_day =session[:picker][:headline_start_day]
      @headline_end_day =session[:picker][:headline_end_day]
      session[:picker] = nil
      if flash[:pick]
        if flash[:pick][:mail]
          params[:mail] = flash[:pick][:mail]
        end
      end
    elsif params[:picker]
      picker, = params[:picker].keys
      if /\A(?:mail|diversity|(company|organization|person|post|group|calendar|lump|record)(\d+)(?:_(?:new_)?details_\d+)?)\z/ =~ picker
        field = "calendar"

        flash[:year], flash[:month] = $1, $2

        picker_session[:return_to] = {
          :controller => params[:controller],
          :product_id => params[:product_id],
          :action     => params[:action],
          :id         => params[:id],
        }
        session[:picker][:selected_product_id] =params[:selected_product_id]
        session[:picker][:inputed_code] =params[:inputed_code]
        session[:picker][:inputed_project_name] = params[:inputed_project_name]
        session[:picker][:inputed_title_name] =params[:inputed_title_name]
        session[:picker][:inputed_file_name] =params[:inputed_file_name]
        session[:picker][:inputed_description] =params[:inputed_description]
        session[:picker][:inputed_created_by] =params[:inputed_created_by]
        session[:picker][:headline_start_day] = params[:it][:headline_start_day]
        session[:picker][:headline_end_day] = params[:it][:headline_end_day]
        
        picker_session[:it_before_picker] = params[:it] || {}
        
        x_redirect_to @sub_view, picker, {
          :controller   => "picker",
          :action       => field,
          :return_field => field,
        }
        return true
      end
    end
    return false
  end
  
  def get_picker_fields(key)
    if /\A(?:mail|(company|organization|person|post|group|calendar|lump)(\d+)(?:_(?:new_)?details_\d+)?)\z/ =~ key
      return $1 || 'mail', $2
    elsif (/\Aworkflow/ === key)
      return 'person', nil
    else
      nil
    end
  end
  
  # 機能名の選択
  def prepare_product_name_to_list
    products =Product.permissible.sort_by{|p|p.code}
    @product_name_all =[["(#{s_("PjcAttachmentList|Attachment_select_tag|no_selected")})","(no_selected)"]]
    products.each do |product|
       @product_name_all << [product.name,product.id] if product.attachment==true
    end
  end
  
  def setup_per_page(model_class, options, attachment_count)
    @allowed_per_page_options = ALLOWED_PER_PAGE.map do |n|
      if n == 0
        [s_("rfw|select|option|ALL"), n]
      else
        [(ns_("rfw|select|option|per %{n} page", "per %{n} pages", n) % {:n => n}), n]
      end
    end

    default_per_page = User.list_default_per_page
    yield(default_per_page) if block_given?
    per_page = params[:per].to_i
    if per_page == 0
      options[:per_page] = attachment_count+1
    elsif ALLOWED_PER_PAGE.include?(per_page)
      options[:per_page] = per_page
    else
      options[:per_page] = per_page = default_per_page
    end
  end

  def setup_list_id
    params[:list] ||= fetch_fragment("m", :list, nil)
    update_fragment("m", :list, @default_list && @default_list.display_id)
  end

end
