# -*- coding: utf-8 -*-
# プロジェクトを制御する。
class Pick::ProjectController < ApplicationController
  include Picker::Controller
  include ProjectCollaboration::ProjectHelper::Controller

  before_filter :check_rfw_project, :only => [:search, :search_projects, :search_segments, :reset_project_and_segment]
  before_filter :check_rfw_retrieval_divisions, :only => [:narrow_retrieval_divisions, :select_retrieval_divisions, :commit_retrieval_divisions]
  before_filter :set_retrieval_divisions, :set_current_project_and_segment

  # プロジェクトを選択するための一覧を表示する。
  def search
    prepare_projects
    expose_writable_only
  end

  # プロジェクト/業務選択のため、プロジェクトを検索する。
  def search_projects
    prepare(params[params[:rfw][:project_id]] || session[:project_id])
    expose_writable_only
  end

  # プロジェクト/業務選択のため、業務を検索する。
  def search_segments
    prepare_segments
    expose_writable_only
  end

  # 区分選択を行う。
  def select_retrieval_divisions
  end

  # プロジェクト選択による絞り込みを行う画面を表示する。
  def narrow
    prepare(params[params[:rfw][:project_id]] || session[:project_id])
  end

  # プロジェクト業務選択による絞り込みを行う画面を表示する。
  # 事前に選択されている可能性があるプロジェクトを展開する。
  def narrow_p
    prepare(params[params[:rfw][:project_id]] || session[:project_id])
  end

  # プロジェクト業務選択による絞り込みを行う画面を表示する。
  # 事前に選択されている可能性がある業務について、
  # その業務が属するプロジェクトを展開する。
  def narrow_s
    prepare(nil, params[params[:rfw][:project_segment_id]] || session[:project_segment_id])
    render :action => "narrow_p"
  end

  # プロジェクト/業務選択による絞り込みを行う、業務を検索する。
  def narrow_segments
    prepare_segments
  end

  # 区分選択による絞り込みを行う画面を表示する。
  def narrow_retrieval_divisions
  end

  # 区分選択を指定する。
  def commit_retrieval_divisions
    apply_retrieval_divisions
  end

  # 選択したプロジェクトを保存する。
  def save_project
    save do
      case params["saved"]
      when /\Aproject_(\d+)\z/
        id = $1
        x = picker_model_class("Project").find(id)
      else
        id = x = nil
      end
      [id, x, "narrow"]
    end
  end

  # 保存されているプロジェクトをリセットする。
  # 現在のプロジェクトもリセットする。
  def reset_project
    destroy_default_narrowings
    session[:project_id] = session[:project_segment_id] = nil
    @current_project = @current_segment = nil
    prepare(nil)
    data = {}
    data[:display_id] = params[:display_id]
    data[params[:rfw][:project_id]] = ''
    data[:narrowing_text] = ''
    data[params[:rfw][:display_narrowing_id]] = ''
    render :text => data.to_json
  end

  # 選択したプロジェクト/業務を保存する.
  def save_project_and_segment
    save do
      case params["saved"]
      when /\Aproject_(\d+)\z/
        id = $1
        x = picker_model_class("Project").find(id)
        action_name = "narrow_p"
      when /\Asegment_(\d+)\z/
        id = $1
        x = picker_model_class("ProjectSegment").find(id)
        action_name = "narrow_s"
      else
        id = x = action_name = nil
      end
      [id, x, action_name]
    end
  end

  # 保存されているプロジェクト/業務をリセットする。
  # 現在のプロジェクト/業務もリセットする。
  def reset_project_and_segment
    destroy_default_narrowings
    session[:project_id] = session[:project_segment_id] = nil
    @current_project = @current_segment = nil
    prepare(nil)
    data = {}
    data[:display_id] = params[:display_id]
    data[params[:rfw][:project_id]] = ''
    data[params[:rfw][:project_segment_id]] = ''
    data[:narrowing_text] = ''
    data[params[:rfw][:display_narrowing_id]] = ''
    render :text => data.to_json
  end

  # 選択した区分を保存する。
  def save_retrieval_divisions
    apply_retrieval_divisions do |data|
      destroy_default_narrowings
      c = {:user_id => User.current_id, :narrowing_id => 4}
      default_narrowing = DefaultNarrowing.find(:first, :conditions => c)
      default_narrowing ||= DefaultNarrowing.new(c)
      data.delete(nil)
      default_narrowing.narrowing_value = data.to_json
      default_narrowing.narrowing_text = data[:narrowing_text]
      default_narrowing.save!
    end
  end

  # 現在の区分をリセットする。
  def reset_retrieval_divisions
    destroy_default_narrowings
    data = {}
    data[params[:rfw][:project_retrieval_divisions]] = s_("rfw|submit_tag|Pick ProjectRetrievalDivision")
    data[params[:rfw][:narrowing_text]] = ''
    @retrieval_divisions.each do |rd|
      k = params[:rfw]["project_retrieval_division_#{rd}"]
      data[k] = ''
    end
    data[:display_narrowing_id] = display_narrowing_id("pick/project", "narrow_retrieval_divisions")
    render :text => data.to_json
  end

  # (試験用)
  def test
  end

  private

  def check_rfw_project
    if params[:rfw].nil? || params[:rfw][:project_id].blank?
      raise ClientError, "rfw parameters are missing"
    end
  end

  def check_rfw_retrieval_divisions
    if params[:rfw].nil? #|| params[:rfw][:project_retrieval_divisions].blank?
      raise ClientError, "rfw parameters are missing"
    end
  end

  def set_retrieval_divisions
    @retrieval_divisions = (1..10)
  end

  def save(&block)
    destroy_default_narrowings

    id, x, action_name = yield

    data = {}
    data[:display_id] = params[:display_id]
    if x
      narrowing = Narrowing.find(:first, :conditions => {:controller_path => controller_path, :action_name => action_name})
      c = {:user_id => User.current_id, :narrowing_id => narrowing.id}
      default_narrowing = DefaultNarrowing.find(:first, :conditions => c)
      default_narrowing ||= DefaultNarrowing.new(c)
      default_narrowing.narrowing_value = id
      default_narrowing.narrowing_text = x.to_text
      default_narrowing.save!

      case x
      when picker_model_class("Project")
        data[params[:rfw][:project_id]] = id
        data[params[:rfw][:project_segment_id]] = ''
      when picker_model_class("ProjectSegment")
        data[params[:rfw][:project_id]] = x.project_id
        data[params[:rfw][:project_segment_id]] = id
      end
      data[:narrowing_text] = x.to_text
      display_narrowing = DisplayNarrowing.find(:first, :conditions => {:display_id => params[:display_id], :narrowing_id => narrowing.id})
      data[params[:rfw][:display_narrowing_id]] = display_narrowing.id if display_narrowing
    end
    render :text => data.to_json
  end

  def apply_retrieval_divisions(&block)
    data = HashWithIndifferentAccess.new
    name = Array.new 
    @retrieval_divisions.map do |rd|
      value = params["retrieval_division_#{rd}"]
#      value.blank? ? s_("pjc|Project|(unspecified)") : value
      name << value unless params["retrieval_division_#{rd}"].blank?
    end
    name = name.join("-")
    data[params[:rfw][:project_retrieval_divisions]] = s_("rfw|submit_tag|Pick ProjectRetrievalDivision")
    data[params[:rfw][:narrowing_text]] = name
    @retrieval_divisions.each do |rd|
      k = params[:rfw]["project_retrieval_division_#{rd}"]
      v = params["retrieval_division_#{rd}"]
      data[k] = v
    end
    data[:display_narrowing_id] = display_narrowing_id("pick/project", "narrow_retrieval_divisions")
    yield(data) if block_given?
    render :text => data.to_json
  end

end
